/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.finra.herd.dao.EmrClusterDefinitionDao;
import org.finra.herd.dao.NamespaceDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.EmrClusterDefinitionKey;
import org.finra.herd.model.jpa.EmrClusterDefinitionEntity;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.EmrClusterDefinitionDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class EmrClusterDefinitionDaoHelperTest
extends AbstractServiceTest {
    @Mock
    private EmrClusterDefinitionDao emrClusterDefinitionDao;
    @InjectMocks
    private EmrClusterDefinitionDaoHelper emrClusterDefinitionDaoHelper;
    @Mock
    private NamespaceDao namespaceDao;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testGetEmrClusterDefinitionEntity() {
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        EmrClusterDefinitionEntity emrClusterDefinitionEntity = new EmrClusterDefinitionEntity();
        EmrClusterDefinitionKey emrClusterDefinitionKey = new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd(NAMESPACE)).thenReturn((Object)namespaceEntity);
        Mockito.when((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME)).thenReturn((Object)emrClusterDefinitionEntity);
        EmrClusterDefinitionEntity result = this.emrClusterDefinitionDaoHelper.getEmrClusterDefinitionEntity(emrClusterDefinitionKey);
        ((NamespaceDao)Mockito.verify((Object)this.namespaceDao)).getNamespaceByCd(NAMESPACE);
        ((EmrClusterDefinitionDao)Mockito.verify((Object)this.emrClusterDefinitionDao)).getEmrClusterDefinitionByNamespaceAndName(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)emrClusterDefinitionEntity, (Object)result);
    }

    @Test
    public void testGetEmrClusterDefinitionEntityNamespaceNoExists() {
        EmrClusterDefinitionKey emrClusterDefinitionKey = new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME);
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd(NAMESPACE)).thenReturn(null);
        try {
            this.emrClusterDefinitionDaoHelper.getEmrClusterDefinitionEntity(emrClusterDefinitionKey);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("EMR cluster definition with name \"%s\" doesn't exist for namespace \"%s\".", EMR_CLUSTER_DEFINITION_NAME, NAMESPACE), (Object)e.getMessage());
        }
        ((NamespaceDao)Mockito.verify((Object)this.namespaceDao)).getNamespaceByCd(NAMESPACE);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetEmrClusterDefinitionKeys() {
        NamespaceEntity namespaceEntity = new NamespaceEntity();
        ArrayList emrClusterDefinitionKeys = Lists.newArrayList((Object[])new EmrClusterDefinitionKey[]{new EmrClusterDefinitionKey(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME)});
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd(NAMESPACE)).thenReturn((Object)namespaceEntity);
        Mockito.when((Object)this.emrClusterDefinitionDao.getEmrClusterDefinitionKeysByNamespace(namespaceEntity)).thenReturn((Object)emrClusterDefinitionKeys);
        List result = this.emrClusterDefinitionDaoHelper.getEmrClusterDefinitionKeys(NAMESPACE);
        ((NamespaceDao)Mockito.verify((Object)this.namespaceDao)).getNamespaceByCd(NAMESPACE);
        ((EmrClusterDefinitionDao)Mockito.verify((Object)this.emrClusterDefinitionDao)).getEmrClusterDefinitionKeysByNamespace(namespaceEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)emrClusterDefinitionKeys, (Object)result);
    }

    @Test
    public void testGetEmrClusterDefinitionKeysNamespaceNoExists() {
        Mockito.when((Object)this.namespaceDao.getNamespaceByCd(NAMESPACE)).thenReturn(null);
        List result = this.emrClusterDefinitionDaoHelper.getEmrClusterDefinitionKeys(NAMESPACE);
        ((NamespaceDao)Mockito.verify((Object)this.namespaceDao)).getNamespaceByCd(NAMESPACE);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.emrClusterDefinitionDao, this.namespaceDao});
    }
}

