/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.amazonaws.services.elasticmapreduce.model.Cluster;
import com.amazonaws.services.elasticmapreduce.model.ClusterSummary;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.finra.herd.model.api.xml.EmrCluster;
import org.finra.herd.model.api.xml.EmrClusterCreateRequest;
import org.finra.herd.model.api.xml.EmrClusterDefinition;
import org.finra.herd.model.api.xml.EmrHadoopJarStep;
import org.finra.herd.model.api.xml.EmrHiveStep;
import org.finra.herd.model.api.xml.EmrPigStep;
import org.finra.herd.model.api.xml.EmrShellStep;
import org.finra.herd.model.api.xml.NodeTag;
import org.finra.herd.model.dto.AwsParamsDto;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.EmrStepHelper;
import org.junit.Assert;
import org.junit.Test;

public class EmrHelperTest
extends AbstractServiceTest {
    @Test
    public void testCreateEmrClusterBlankTags() throws Exception {
        this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        NodeTag nodeTag1 = new NodeTag();
        nodeTag1.setTagName("NO_TAG_VALUE");
        NodeTag nodeTag2 = new NodeTag();
        nodeTag2.setTagValue("NO_TAG_NAME");
        ArrayList<NodeTag> nodeTagList = new ArrayList<NodeTag>();
        nodeTagList.add(nodeTag1);
        nodeTagList.add(nodeTag2);
        emrClusterDefinition.setNodeTags(nodeTagList);
        this.emrDao.createEmrCluster(EMR_CLUSTER_DEFINITION_NAME, emrClusterDefinition, this.emrHelper.getAwsParamsDto());
    }

    @Test
    public void testEmrAddStepsAllTypesNegativeTestCase() throws Exception {
        NamespaceEntity namespaceEntity = this.namespaceDaoTestHelper.createNamespaceEntity(NAMESPACE);
        this.emrClusterDefinitionDaoTestHelper.createEmrClusterDefinitionEntity(namespaceEntity, EMR_CLUSTER_DEFINITION_NAME, IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream()));
        this.ec2OnDemandPricingDaoTestHelper.createEc2OnDemandPricingEntities();
        EmrClusterCreateRequest request = this.getNewEmrClusterCreateRequest();
        EmrCluster emrCluster = this.emrService.createCluster(request);
        ArrayList<String> shellScriptArgs = new ArrayList<String>();
        shellScriptArgs.add("Hello");
        shellScriptArgs.add("herd");
        shellScriptArgs.add("How Are You");
        ArrayList<Object> steps = new ArrayList<Object>();
        EmrShellStep shellStep = new EmrShellStep(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, request.getEmrClusterName(), null, null, null, null, null, null);
        shellStep.setScriptLocation("s3://test-bucket-managed/app-a/test/test_script.sh");
        shellStep.setStepName("Test Shell Script");
        shellStep.setScriptArguments(shellScriptArgs);
        shellStep.setContinueOnError(Boolean.valueOf(true));
        steps.add(shellStep);
        EmrHiveStep hiveStep = new EmrHiveStep(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, request.getEmrClusterName(), null, null, null, null, null, null);
        hiveStep.setStepName("Test Hive");
        hiveStep.setScriptLocation("s3://test-bucket-managed/app-a/test/test_hive.hql");
        hiveStep.setContinueOnError(Boolean.valueOf(true));
        steps.add(hiveStep);
        EmrPigStep pigStep = new EmrPigStep(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, request.getEmrClusterName(), null, null, null, null, null, null);
        pigStep.setStepName("Test Pig");
        pigStep.setContinueOnError(Boolean.valueOf(true));
        pigStep.setScriptLocation("s3://test-bucket-managed/app-a/test/test_pig.pig");
        steps.add(pigStep);
        shellStep = new EmrShellStep(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, request.getEmrClusterName(), null, null, null, null, null, null);
        shellStep.setScriptLocation("s3://test-bucket-managed/app-a/bootstrap/install_oozie.sh");
        shellStep.setStepName("Install Oozie");
        ArrayList<String> shellScriptArgsOozie = new ArrayList<String>();
        shellScriptArgsOozie.add("s3://test-bucket-managed/app-a/bootstrap/oozie-4.0.1-distro.tar");
        shellStep.setScriptArguments(shellScriptArgsOozie);
        steps.add(shellStep);
        EmrHadoopJarStep hadoopJarStep = new EmrHadoopJarStep(NAMESPACE, EMR_CLUSTER_DEFINITION_NAME, request.getEmrClusterName(), null, null, null, null, null, null, null);
        hadoopJarStep.setContinueOnError(Boolean.valueOf(true));
        hadoopJarStep.setStepName("Hadoop Jar");
        hadoopJarStep.setJarLocation("s3://test-bucket-managed/app-a/test/hadoop-mapreduce-examples-2.4.0.jar");
        hadoopJarStep.setMainClass("wordcount");
        steps.add(hadoopJarStep);
        for (Object e : steps) {
            EmrStepHelper stepHelper = this.emrStepHelperFactory.getStepHelper(e.getClass().getName());
            this.emrDao.addEmrStep(emrCluster.getId(), stepHelper.getEmrStepConfig(e), this.emrHelper.getAwsParamsDto());
        }
    }

    @Test
    public void testEmrAwsDtoBlankProxy() throws Exception {
        AwsParamsDto awsParamsDto = this.emrHelper.getAwsParamsDto();
        awsParamsDto.setHttpProxyHost("");
        this.emrDao.getEmrClient(awsParamsDto);
    }

    @Test
    public void testGetActiveEmrClusterByName() throws Exception {
        String configXml = IOUtils.toString((InputStream)this.resourceLoader.getResource("classpath:testEmrClusterDefinition.xml").getInputStream());
        EmrClusterDefinition emrClusterDefinition = (EmrClusterDefinition)this.xmlHelper.unmarshallXmlToObject(EmrClusterDefinition.class, configXml);
        ClusterSummary clusterSummary = this.emrDao.getActiveEmrClusterByName("mock_cluster_name", this.emrHelper.getAwsParamsDto());
        Assert.assertNull((Object)clusterSummary);
        String clusterId = this.emrDao.createEmrCluster("mock_cluster_name", emrClusterDefinition, this.emrHelper.getAwsParamsDto());
        clusterSummary = this.emrDao.getActiveEmrClusterByName("mock_cluster_name", this.emrHelper.getAwsParamsDto());
        Assert.assertNotNull((Object)clusterSummary);
        Assert.assertEquals((Object)clusterId, (Object)clusterSummary.getId());
    }

    @Test
    public void testGetEmrClusterByIdNull() throws Exception {
        Cluster cluster = this.emrDao.getEmrClusterById(null, null);
        Assert.assertNull((Object)cluster);
    }

    @Test
    public void testGetEmrClusterStatusByIdWithBlank() throws Exception {
        this.emrDao.getEmrClusterStatusById(EMR_CLUSTER_DEFINITION_NAME, this.emrHelper.getAwsParamsDto());
    }

    private EmrClusterCreateRequest getNewEmrClusterCreateRequest() throws Exception {
        EmrClusterCreateRequest request = new EmrClusterCreateRequest();
        request.setNamespace(NAMESPACE);
        request.setEmrClusterDefinitionName(EMR_CLUSTER_DEFINITION_NAME);
        request.setEmrClusterName("UT_EMR_CLUSTER" + String.format("-%.3f", Math.random()));
        return request;
    }
}

