/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.api.xml.GlobalAttributeDefinitionKey;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.GlobalAttributeDefinitionHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class GlobalAttributeDefinitionHelperTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @InjectMocks
    private GlobalAttributeDefinitionHelper globalAttributeDefinitionHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testValidateGlobalAttributeDefinitionKey() {
        GlobalAttributeDefinitionKey globalAttributeDefinitionKey = new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("global attribute definition level", "BUS_OBJCT_FRMT")).thenReturn((Object)"BUS_OBJCT_FRMT");
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("global attribute definition name", GLOBAL_ATTRIBUTE_DEFINITON_NAME)).thenReturn((Object)GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        this.globalAttributeDefinitionHelper.validateGlobalAttributeDefinitionKey(globalAttributeDefinitionKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("global attribute definition level", "BUS_OBJCT_FRMT");
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("global attribute definition name", GLOBAL_ATTRIBUTE_DEFINITON_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
        Assert.assertEquals((Object)new GlobalAttributeDefinitionKey("BUS_OBJCT_FRMT", GLOBAL_ATTRIBUTE_DEFINITON_NAME), (Object)globalAttributeDefinitionKey);
    }

    @Test
    public void testValidateGlobalAttributeDefinitionKeyMissingRequiredParameters() {
        try {
            this.globalAttributeDefinitionHelper.validateGlobalAttributeDefinitionKey(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A global attribute definition key must be specified.", (Object)e.getMessage());
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }
}

