/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Session;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.HerdJmsDestinationResolver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;

public class HerdJmsDestinationResolverTest
extends AbstractServiceTest {
    @Autowired
    HerdJmsDestinationResolver herdJmsDestinationResolver;

    @Test
    public void testResolveDestinationNameNoExists() throws Exception {
        try {
            this.herdJmsDestinationResolver.resolveDestinationName(null, "queue_not_exists", false);
            Assert.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)String.format("Failed to resolve the SQS queue: \"%s\".", ""), (Object)ex.getMessage());
        }
    }

    @Test
    public void testResolveDestinationNameNoQueueExists() throws Exception {
        try {
            this.herdJmsDestinationResolver.resolveDestinationName(null, "herd_incoming_queue", false);
            Assert.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((String)"\"Failed to resolve the SQS queue:\" error message doesn't match", (boolean)ex.getMessage().startsWith("Failed to resolve the SQS queue:"));
        }
    }

    @Test
    public void testResolveDestinationNameNoConfig() throws Exception {
        this.removeReloadablePropertySourceFromEnvironment();
        try {
            this.herdJmsDestinationResolver.resolveDestinationName(null, "herd_incoming_queue", false);
            Assert.fail((String)"Should throw an IllegalStateException.");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)String.format("SQS queue name not found. Ensure the \"%s\" configuration entry is configured.", ConfigurationValue.HERD_NOTIFICATION_SQS_INCOMING_QUEUE_NAME.getKey()), (Object)ex.getMessage());
        }
        finally {
            this.restorePropertySourceInEnvironment();
        }
    }

    @Test
    public void testResolveDestinationHerdIncoming() throws Exception {
        Session session = (Session)Mockito.mock(Session.class);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)session.createQueue((String)Matchers.any())).thenReturn((Object)queue);
        Destination destination = this.herdJmsDestinationResolver.resolveDestinationName(session, "herd_incoming_queue", false);
        MatcherAssert.assertThat((String)"Destination is null.", (Object)destination, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).createQueue((String)Matchers.any());
    }

    @Test
    public void testResolveDestinationStoragePolicy() throws Exception {
        Session session = (Session)Mockito.mock(Session.class);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)session.createQueue((String)Matchers.any())).thenReturn((Object)queue);
        Destination destination = this.herdJmsDestinationResolver.resolveDestinationName(session, "storage_policy_selector_job_sqs_queue", false);
        MatcherAssert.assertThat((String)"Destination is null.", (Object)destination, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).createQueue((String)Matchers.any());
    }

    @Test
    public void testResolveDestinationSampleData() throws Exception {
        Session session = (Session)Mockito.mock(Session.class);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)session.createQueue((String)Matchers.any())).thenReturn((Object)queue);
        Destination destination = this.herdJmsDestinationResolver.resolveDestinationName(session, "sample_data_queue", false);
        MatcherAssert.assertThat((String)"Destination is null.", (Object)destination, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).createQueue((String)Matchers.any());
    }

    @Test
    public void testResolveDestinationSearchIndexUpdate() throws Exception {
        Session session = (Session)Mockito.mock(Session.class);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)session.createQueue((String)Matchers.any())).thenReturn((Object)queue);
        Destination destination = this.herdJmsDestinationResolver.resolveDestinationName(session, "search_index_update_queue", false);
        MatcherAssert.assertThat((String)"Destination is null.", (Object)destination, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).createQueue((String)Matchers.any());
    }
}

