/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.amazonaws.services.s3.event.S3EventNotification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.finra.herd.core.ApplicationContextHolder;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.model.api.xml.Attribute;
import org.finra.herd.model.api.xml.BusinessObjectDefinition;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDefinitionKey;
import org.finra.herd.model.api.xml.SampleDataFile;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.jpa.BusinessObjectDefinitionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.SampleDataJmsMessageListener;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.test.util.ReflectionTestUtils;

public class SampleDataJmsMessageListenerTest
extends AbstractServiceTest {
    @Autowired
    private SampleDataJmsMessageListener sampleDataJmsMessageListener;

    @Test
    public void testS3Message() throws Exception {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME)));
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        String fileName = "test1.csv";
        String filePath = NAMESPACE + "/" + BDEF_NAME + "/" + fileName;
        long fileSize = 1024L;
        S3EventNotification.S3Entity s3Entity = new S3EventNotification.S3Entity(null, null, new S3EventNotification.S3ObjectEntity(filePath, Long.valueOf(fileSize), null, null), null);
        ArrayList<S3EventNotification.S3EventNotificationRecord> records = new ArrayList<S3EventNotification.S3EventNotificationRecord>();
        records.add(new S3EventNotification.S3EventNotificationRecord(null, null, null, null, null, null, null, s3Entity, null));
        S3EventNotification s3EventNotification = new S3EventNotification(records);
        this.sampleDataJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)s3EventNotification), null);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(NAMESPACE, BDEF_NAME);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(businessObjectDefinitionKey, Boolean.valueOf(false));
        List<SampleDataFile> sampleDataFiles = Arrays.asList(new SampleDataFile(NAMESPACE + "/" + BDEF_NAME + "/", fileName));
        Assert.assertEquals((Object)new BusinessObjectDefinition(updatedBusinessObjectDefinition.getId(), NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, sampleDataFiles, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testS3MessageWithDashCharacterName() throws Exception {
        String namespace = "testnamespace-1";
        String businessObjectDefinitionName = "testbdefname-1";
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting(namespace, DATA_PROVIDER_NAME);
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME)));
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest(namespace, businessObjectDefinitionName, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        BusinessObjectDefinitionEntity businessObjectDefinitionEntity = this.businessObjectDefinitionDao.getBusinessObjectDefinitionByKey(new BusinessObjectDefinitionKey(namespace, businessObjectDefinitionName));
        Assert.assertNotNull((Object)businessObjectDefinitionEntity);
        String fileName = "test1.csv";
        String filePath = namespace + "/" + businessObjectDefinitionName + "/" + fileName;
        long fileSize = 1024L;
        S3EventNotification.S3Entity s3Entity = new S3EventNotification.S3Entity(null, null, new S3EventNotification.S3ObjectEntity(filePath, Long.valueOf(fileSize), null, null), null);
        ArrayList<S3EventNotification.S3EventNotificationRecord> records = new ArrayList<S3EventNotification.S3EventNotificationRecord>();
        records.add(new S3EventNotification.S3EventNotificationRecord(null, null, null, null, null, null, null, s3Entity, null));
        S3EventNotification s3EventNotification = new S3EventNotification(records);
        this.sampleDataJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)s3EventNotification), null);
        BusinessObjectDefinitionKey businessObjectDefinitionKey = new BusinessObjectDefinitionKey(namespace, businessObjectDefinitionName);
        BusinessObjectDefinition updatedBusinessObjectDefinition = this.businessObjectDefinitionService.getBusinessObjectDefinition(businessObjectDefinitionKey, Boolean.valueOf(false));
        List<SampleDataFile> sampleDataFiles = Arrays.asList(new SampleDataFile(namespace + "/" + businessObjectDefinitionName + "/", fileName));
        Assert.assertEquals((Object)new BusinessObjectDefinition(updatedBusinessObjectDefinition.getId(), namespace, businessObjectDefinitionName, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, NO_BDEF_SHORT_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes(), NO_DESCRIPTIVE_BUSINESS_OBJECT_FORMAT, sampleDataFiles, businessObjectDefinitionEntity.getCreatedBy(), businessObjectDefinitionEntity.getUpdatedBy(), HerdDateUtils.getXMLGregorianCalendarValue((Date)businessObjectDefinitionEntity.getUpdatedOn()), NO_BUSINESS_OBJECT_DEFINITION_CHANGE_EVENTS), (Object)updatedBusinessObjectDefinition);
    }

    @Test
    public void testS3MessageWithWrongFormat() throws Exception {
        this.businessObjectDefinitionServiceTestHelper.createDatabaseEntitiesForBusinessObjectDefinitionTesting();
        this.storageDaoTestHelper.createStorageEntity("S3_MANAGED_SAMPLE_DATA", Arrays.asList(new Attribute(this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME), S3_BUCKET_NAME)));
        BusinessObjectDefinitionCreateRequest request = new BusinessObjectDefinitionCreateRequest(NAMESPACE, BDEF_NAME, DATA_PROVIDER_NAME, BDEF_DESCRIPTION, BDEF_DISPLAY_NAME, this.businessObjectDefinitionServiceTestHelper.getNewAttributes());
        this.businessObjectDefinitionService.createBusinessObjectDefinition(request);
        String fileName = "test1.csv";
        String filePath = NAMESPACE + "/" + BDEF_NAME + fileName;
        long fileSize = 1024L;
        S3EventNotification.S3Entity s3Entity = new S3EventNotification.S3Entity(null, null, new S3EventNotification.S3ObjectEntity(filePath, Long.valueOf(fileSize), null, null), null);
        ArrayList<S3EventNotification.S3EventNotificationRecord> records = new ArrayList<S3EventNotification.S3EventNotificationRecord>();
        records.add(new S3EventNotification.S3EventNotificationRecord(null, null, null, null, null, null, null, s3Entity, null));
        S3EventNotification s3EventNotification = new S3EventNotification(records);
        try {
            this.sampleDataJmsMessageListener.processMessage(this.jsonHelper.objectToJson((Object)s3EventNotification), null);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail();
        }
    }

    @Test
    public void testControlListener() {
        this.configurationHelper = (ConfigurationHelper)Mockito.mock(ConfigurationHelper.class);
        ReflectionTestUtils.setField((Object)this.sampleDataJmsMessageListener, (String)"configurationHelper", (Object)this.configurationHelper);
        MessageListenerContainer mockMessageListenerContainer = (MessageListenerContainer)Mockito.mock(MessageListenerContainer.class);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SAMPLE_DATA_JMS_LISTENER_ENABLED)).thenReturn((Object)"false");
        JmsListenerEndpointRegistry registry = (JmsListenerEndpointRegistry)ApplicationContextHolder.getApplicationContext().getBean("org.springframework.jms.config.internalJmsListenerEndpointRegistry", JmsListenerEndpointRegistry.class);
        Mockito.when((Object)registry.getListenerContainer("sample_data_queue")).thenReturn((Object)mockMessageListenerContainer);
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)false);
        this.sampleDataJmsMessageListener.controlSampleDataJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).stop();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).start();
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)true);
        this.sampleDataJmsMessageListener.controlSampleDataJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer)).stop();
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.SAMPLE_DATA_JMS_LISTENER_ENABLED)).thenReturn((Object)"true");
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)true);
        this.sampleDataJmsMessageListener.controlSampleDataJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer, (VerificationMode)Mockito.times((int)0))).start();
        Mockito.when((Object)mockMessageListenerContainer.isRunning()).thenReturn((Object)false);
        this.sampleDataJmsMessageListener.controlSampleDataJmsMessageListener();
        ((MessageListenerContainer)Mockito.verify((Object)mockMessageListenerContainer)).start();
    }

    @Configuration
    static class ContextConfiguration {
        ContextConfiguration() {
        }

        @Bean(name={"org.springframework.jms.config.internalJmsListenerEndpointRegistry"})
        JmsListenerEndpointRegistry registry() {
            try {
                Class.forName("org.mockito.Mockito");
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
            return (JmsListenerEndpointRegistry)Mockito.mock(JmsListenerEndpointRegistry.class);
        }
    }
}

