/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.SearchIndexKey;
import org.finra.herd.model.jpa.SearchIndexEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.junit.Assert;
import org.junit.Test;

public class SearchIndexDaoHelperTest
extends AbstractServiceTest {
    @Test
    public void testGetSearchIndexEntity() {
        SearchIndexEntity searchIndexEntity = this.searchIndexDaoTestHelper.createSearchIndexEntity(SEARCH_INDEX_NAME, SEARCH_INDEX_TYPE, SEARCH_INDEX_STATUS);
        Assert.assertEquals((Object)searchIndexEntity, (Object)this.searchIndexDaoHelper.getSearchIndexEntity(new SearchIndexKey(SEARCH_INDEX_NAME)));
        try {
            this.searchIndexDaoHelper.getSearchIndexEntity(new SearchIndexKey("I_DO_NOT_EXIST"));
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Search index with name \"%s\" doesn't exist.", "I_DO_NOT_EXIST"), (Object)e.getMessage());
        }
    }

    @Test
    public void testUpdateSearchIndexStatus() {
        SearchIndexEntity searchIndexEntity = this.searchIndexDaoTestHelper.createSearchIndexEntity(SEARCH_INDEX_NAME, SEARCH_INDEX_TYPE, SEARCH_INDEX_STATUS);
        this.searchIndexStatusDaoTestHelper.createSearchIndexStatusEntity(SEARCH_INDEX_STATUS_2);
        this.searchIndexDaoHelper.updateSearchIndexStatus(new SearchIndexKey(SEARCH_INDEX_NAME), SEARCH_INDEX_STATUS_2);
        Assert.assertEquals((Object)SEARCH_INDEX_STATUS_2, (Object)searchIndexEntity.getStatus().getCode());
    }

    @Test
    public void testActivateSearchIndexEntitySingleEntity() {
        SearchIndexEntity searchIndexEntity = this.searchIndexDaoTestHelper.createSearchIndexEntity(SEARCH_INDEX_NAME, SEARCH_INDEX_TYPE, SEARCH_INDEX_STATUS);
        this.searchIndexDaoHelper.activateSearchIndex(searchIndexEntity);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)searchIndexEntity.getActive());
    }

    @Test
    public void testActivateSearchIndexEntity() {
        SearchIndexEntity searchIndexEntity = this.searchIndexDaoTestHelper.createSearchIndexEntity(SEARCH_INDEX_NAME, SEARCH_INDEX_TYPE, SEARCH_INDEX_STATUS);
        SearchIndexEntity searchIndexEntity1 = this.searchIndexDaoTestHelper.createSearchIndexEntity(SEARCH_INDEX_NAME_2, SEARCH_INDEX_TYPE, SEARCH_INDEX_STATUS);
        this.searchIndexDaoHelper.activateSearchIndex(searchIndexEntity);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)searchIndexEntity.getActive());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)searchIndexEntity1.getActive());
    }
}

