/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.dao.SecurityFunctionDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.jpa.SecurityFunctionEntity;
import org.finra.herd.service.helper.SecurityFunctionDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SecurityFunctionDaoHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private SecurityFunctionDao securityFunctionDao;
    @InjectMocks
    private SecurityFunctionDaoHelper securityFunctionDaoHelper = new SecurityFunctionDaoHelper();

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGetSecurityFunctionEntity() {
        SecurityFunctionEntity securityFunctionEntity = new SecurityFunctionEntity();
        Mockito.when((Object)this.securityFunctionDao.getSecurityFunctionByName(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)securityFunctionEntity);
        SecurityFunctionEntity result = this.securityFunctionDaoHelper.getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION);
        Assert.assertEquals((Object)securityFunctionEntity, (Object)result);
        ((SecurityFunctionDao)Mockito.verify((Object)this.securityFunctionDao)).getSecurityFunctionByName(AbstractDaoTest.SECURITY_FUNCTION);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityFunctionEntitySecurityFunctionNoExists() {
        Mockito.when((Object)this.securityFunctionDao.getSecurityFunctionByName(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn(null);
        this.expectedException.expect(ObjectNotFoundException.class);
        this.expectedException.expectMessage(String.format("Security function with name \"%s\" doesn't exist.", AbstractDaoTest.SECURITY_FUNCTION));
        this.securityFunctionDaoHelper.getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION);
        ((SecurityFunctionDao)Mockito.verify((Object)this.securityFunctionDao)).getSecurityFunctionByName(AbstractDaoTest.SECURITY_FUNCTION);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityFunctionDao});
    }
}

