/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.model.api.xml.SecurityFunctionKey;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.SecurityFunctionHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SecurityFunctionHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @InjectMocks
    private SecurityFunctionHelper securityFunctionHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testValidateAndTrimSecurityFunctionKey() {
        SecurityFunctionKey securityFunctionKey = new SecurityFunctionKey(AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION_2);
        this.securityFunctionHelper.validateAndTrimSecurityFunctionKey(securityFunctionKey);
        Assert.assertEquals((Object)new SecurityFunctionKey(AbstractDaoTest.SECURITY_FUNCTION_2), (Object)securityFunctionKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }

    @Test
    public void testValidateAndTrimSecurityFunctionKeyMissingSecurityFunctionKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A security function key must be specified.");
        this.securityFunctionHelper.validateAndTrimSecurityFunctionKey(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }
}

