/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.dao.SecurityRoleDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.jpa.SecurityRoleEntity;
import org.finra.herd.service.helper.SecurityRoleDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SecurityRoleDaoHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private SecurityRoleDao securityRoleDao;
    @InjectMocks
    private SecurityRoleDaoHelper securityRoleDaoHelper = new SecurityRoleDaoHelper();

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGetSecurityRoleEntity() {
        SecurityRoleEntity securityRoleEntity = new SecurityRoleEntity();
        Mockito.when((Object)this.securityRoleDao.getSecurityRoleByName(AbstractDaoTest.SECURITY_ROLE)).thenReturn((Object)securityRoleEntity);
        SecurityRoleEntity result = this.securityRoleDaoHelper.getSecurityRoleEntity(AbstractDaoTest.SECURITY_ROLE);
        Assert.assertEquals((Object)securityRoleEntity, (Object)result);
        ((SecurityRoleDao)Mockito.verify((Object)this.securityRoleDao)).getSecurityRoleByName(AbstractDaoTest.SECURITY_ROLE);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityRoleEntitySecurityRoleNoExists() {
        this.expectedException.expect(ObjectNotFoundException.class);
        this.expectedException.expectMessage(String.format("Security role with name \"%s\" doesn't exist.", AbstractDaoTest.SECURITY_ROLE));
        Mockito.when((Object)this.securityRoleDao.getSecurityRoleByName(AbstractDaoTest.SECURITY_ROLE)).thenReturn(null);
        this.securityRoleDaoHelper.getSecurityRoleEntity(AbstractDaoTest.SECURITY_ROLE);
        ((SecurityRoleDao)Mockito.verify((Object)this.securityRoleDao)).getSecurityRoleByName(AbstractDaoTest.SECURITY_ROLE);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityRoleDao});
    }
}

