/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.dao.SecurityRoleFunctionDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.SecurityRoleFunctionKey;
import org.finra.herd.model.jpa.SecurityRoleFunctionEntity;
import org.finra.herd.service.helper.SecurityRoleFunctionDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SecurityRoleFunctionDaoHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private SecurityRoleFunctionDao securityRoleFunctionDao;
    @InjectMocks
    private SecurityRoleFunctionDaoHelper securityRoleFunctionDaoHelper = new SecurityRoleFunctionDaoHelper();

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGetSecurityRoleFunctionEntity() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleFunctionEntity securityRoleFunctionEntity = new SecurityRoleFunctionEntity();
        Mockito.when((Object)this.securityRoleFunctionDao.getSecurityRoleFunctionByKey(securityRoleFunctionKey)).thenReturn((Object)securityRoleFunctionEntity);
        SecurityRoleFunctionEntity result = this.securityRoleFunctionDaoHelper.getSecurityRoleFunctionEntity(securityRoleFunctionKey);
        Assert.assertEquals((Object)securityRoleFunctionEntity, (Object)result);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).getSecurityRoleFunctionByKey(securityRoleFunctionKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityRoleFunctionEntitySecurityRoleFunctionNoExists() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.when((Object)this.securityRoleFunctionDao.getSecurityRoleFunctionByKey(securityRoleFunctionKey)).thenReturn(null);
        this.expectedException.expect(ObjectNotFoundException.class);
        this.expectedException.expectMessage(String.format("Security role to function mapping with \"%s\" security role name and \"%s\" security function name doesn't exist.", AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION));
        this.securityRoleFunctionDaoHelper.getSecurityRoleFunctionEntity(securityRoleFunctionKey);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).getSecurityRoleFunctionByKey(securityRoleFunctionKey);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityRoleFunctionDao});
    }
}

