/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.model.api.xml.SecurityRoleFunctionCreateRequest;
import org.finra.herd.model.api.xml.SecurityRoleFunctionKey;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.SecurityRoleFunctionHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SecurityRoleFunctionHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @InjectMocks
    private SecurityRoleFunctionHelper securityRoleFunctionHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testValidateAndTrimSecurityRoleFunctionCreateRequest() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleFunctionCreateRequest securityRoleFunctionCreateRequest = new SecurityRoleFunctionCreateRequest(securityRoleFunctionKey);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("security role name", AbstractDaoTest.SECURITY_ROLE)).thenReturn((Object)AbstractDaoTest.SECURITY_ROLE_2);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION_2);
        this.securityRoleFunctionHelper.validateAndTrimSecurityRoleFunctionCreateRequest(securityRoleFunctionCreateRequest);
        Assert.assertEquals((Object)new SecurityRoleFunctionCreateRequest(new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE_2, AbstractDaoTest.SECURITY_FUNCTION_2)), (Object)securityRoleFunctionCreateRequest);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security role name", AbstractDaoTest.SECURITY_ROLE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }

    @Test
    public void testValidateAndTrimSecurityRoleFunctionCreateRequestMissingSecurityRoleFunctionCreateRequest() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A security role to function mapping create request must be specified.");
        this.securityRoleFunctionHelper.validateAndTrimSecurityRoleFunctionCreateRequest(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }

    @Test
    public void testValidateAndTrimSecurityRoleFunctionCreateRequestMissingSecurityRoleFunctionKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A security role to function mapping key must be specified.");
        this.securityRoleFunctionHelper.validateAndTrimSecurityRoleFunctionCreateRequest(new SecurityRoleFunctionCreateRequest());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }

    @Test
    public void testValidateAndTrimSecurityRoleFunctionKey() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("security role name", AbstractDaoTest.SECURITY_ROLE)).thenReturn((Object)AbstractDaoTest.SECURITY_ROLE_2);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION_2);
        this.securityRoleFunctionHelper.validateAndTrimSecurityRoleFunctionKey(securityRoleFunctionKey);
        Assert.assertEquals((Object)new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE_2, AbstractDaoTest.SECURITY_FUNCTION_2), (Object)securityRoleFunctionKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security role name", AbstractDaoTest.SECURITY_ROLE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }

    @Test
    public void testValidateAndTrimSecurityRoleFunctionKeyMissingSecurityRoleFunctionKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A security role to function mapping key must be specified.");
        this.securityRoleFunctionHelper.validateAndTrimSecurityRoleFunctionKey(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }
}

