/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.model.api.xml.SecurityRoleKey;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.SecurityRoleHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SecurityRoleHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @InjectMocks
    private SecurityRoleHelper securityRoleHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testValidateAndTrimSecurityRoleKey() {
        SecurityRoleKey securityRoleKey = new SecurityRoleKey(AbstractDaoTest.SECURITY_ROLE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("security role name", AbstractDaoTest.SECURITY_ROLE)).thenReturn((Object)AbstractDaoTest.SECURITY_ROLE_2);
        this.securityRoleHelper.validateAndTrimSecurityRoleKey(securityRoleKey);
        Assert.assertEquals((Object)new SecurityRoleKey(AbstractDaoTest.SECURITY_ROLE_2), (Object)securityRoleKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security role name", AbstractDaoTest.SECURITY_ROLE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }

    @Test
    public void testValidateAndTrimSecurityRoleKeyMissingSecurityRoleKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A security role key must be specified.");
        this.securityRoleHelper.validateAndTrimSecurityRoleKey(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper});
    }
}

