/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.util.ArrayList;
import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.model.ObjectNotFoundException;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.MessageNotificationEventService;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.helper.StorageUnitStatusDaoHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StorageUnitDaoHelperTest {
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private MessageNotificationEventService messageNotificationEventService;
    @Mock
    private StorageUnitDao storageUnitDao;
    @InjectMocks
    private StorageUnitDaoHelper storageUnitDaoHelper;
    @Mock
    private StorageUnitStatusDaoHelper storageUnitStatusDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testGetStorageUnitEntityByBusinessObjectDataAndStorage() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageEntity storageEntity = new StorageEntity();
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        Mockito.when((Object)this.storageUnitDao.getStorageUnitByBusinessObjectDataAndStorage(businessObjectDataEntity, storageEntity)).thenReturn((Object)storageUnitEntity);
        StorageUnitEntity result = this.storageUnitDaoHelper.getStorageUnitEntityByBusinessObjectDataAndStorage(businessObjectDataEntity, storageEntity);
        Assert.assertEquals((Object)storageUnitEntity, (Object)result);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitByBusinessObjectDataAndStorage(businessObjectDataEntity, storageEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitEntityByBusinessObjectDataAndStorageName() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        Mockito.when((Object)this.storageUnitDao.getStorageUnitByBusinessObjectDataAndStorageName(businessObjectDataEntity, AbstractDaoTest.STORAGE_NAME)).thenReturn((Object)storageUnitEntity);
        StorageUnitEntity result = this.storageUnitDaoHelper.getStorageUnitEntity(AbstractDaoTest.STORAGE_NAME, businessObjectDataEntity);
        Assert.assertEquals((Object)storageUnitEntity, (Object)result);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitByBusinessObjectDataAndStorageName(businessObjectDataEntity, AbstractDaoTest.STORAGE_NAME);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitEntityByBusinessObjectDataAndStorageNameStorageUnitNoExists() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        Mockito.when((Object)this.storageUnitDao.getStorageUnitByBusinessObjectDataAndStorageName(businessObjectDataEntity, AbstractDaoTest.STORAGE_NAME)).thenReturn(null);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)AbstractServiceTest.BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.storageUnitDaoHelper.getStorageUnitEntity(AbstractDaoTest.STORAGE_NAME, businessObjectDataEntity);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"%s\" storage for the business object data {%s}.", AbstractDaoTest.STORAGE_NAME, AbstractServiceTest.BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitByBusinessObjectDataAndStorageName(businessObjectDataEntity, AbstractDaoTest.STORAGE_NAME);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitEntityByBusinessObjectDataAndStorageStorageUnitNoExists() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(AbstractDaoTest.STORAGE_NAME);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitByBusinessObjectDataAndStorage(businessObjectDataEntity, storageEntity)).thenReturn(null);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)AbstractServiceTest.BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.storageUnitDaoHelper.getStorageUnitEntityByBusinessObjectDataAndStorage(businessObjectDataEntity, storageEntity);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Could not find storage unit in \"%s\" storage for the business object data {%s}.", AbstractDaoTest.STORAGE_NAME, AbstractServiceTest.BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitByBusinessObjectDataAndStorage(businessObjectDataEntity, storageEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitEntityByKey() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(AbstractDaoTest.BDEF_NAMESPACE, AbstractDaoTest.BDEF_NAME, AbstractDaoTest.FORMAT_USAGE_CODE, AbstractDaoTest.FORMAT_FILE_TYPE_CODE, AbstractDaoTest.FORMAT_VERSION, AbstractDaoTest.PARTITION_VALUE, AbstractDaoTest.SUBPARTITION_VALUES, AbstractDaoTest.DATA_VERSION, AbstractDaoTest.STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        Mockito.when((Object)this.storageUnitDao.getStorageUnitByKey(businessObjectDataStorageUnitKey)).thenReturn((Object)storageUnitEntity);
        StorageUnitEntity result = this.storageUnitDaoHelper.getStorageUnitEntityByKey(businessObjectDataStorageUnitKey);
        Assert.assertEquals((Object)storageUnitEntity, (Object)result);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitByKey(businessObjectDataStorageUnitKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitEntityByKeyStorageUnitNoExists() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(AbstractDaoTest.BDEF_NAMESPACE, AbstractDaoTest.BDEF_NAME, AbstractDaoTest.FORMAT_USAGE_CODE, AbstractDaoTest.FORMAT_FILE_TYPE_CODE, AbstractDaoTest.FORMAT_VERSION, AbstractDaoTest.PARTITION_VALUE, AbstractDaoTest.SUBPARTITION_VALUES, AbstractDaoTest.DATA_VERSION, AbstractDaoTest.STORAGE_NAME);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitByKey(businessObjectDataStorageUnitKey)).thenReturn(null);
        try {
            this.storageUnitDaoHelper.getStorageUnitEntityByKey(businessObjectDataStorageUnitKey);
            Assert.fail();
        }
        catch (ObjectNotFoundException e) {
            Assert.assertEquals((Object)String.format("Business object data storage unit {namespace: \"%s\", businessObjectDefinitionName: \"%s\", businessObjectFormatUsage: \"%s\", businessObjectFormatFileType: \"%s\", businessObjectFormatVersion: %d, businessObjectDataPartitionValue: \"%s\", businessObjectDataSubPartitionValues: \"%s,%s,%s,%s\", businessObjectDataVersion: %d, storageName: \"%s\"} doesn't exist.", AbstractDaoTest.BDEF_NAMESPACE, AbstractDaoTest.BDEF_NAME, AbstractDaoTest.FORMAT_USAGE_CODE, AbstractDaoTest.FORMAT_FILE_TYPE_CODE, AbstractDaoTest.FORMAT_VERSION, AbstractDaoTest.PARTITION_VALUE, AbstractDaoTest.SUBPARTITION_VALUES.get(0), AbstractDaoTest.SUBPARTITION_VALUES.get(1), AbstractDaoTest.SUBPARTITION_VALUES.get(2), AbstractDaoTest.SUBPARTITION_VALUES.get(3), AbstractDaoTest.DATA_VERSION, AbstractDaoTest.STORAGE_NAME), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitByKey(businessObjectDataStorageUnitKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testSetStorageUnitStatus() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(AbstractDaoTest.BDEF_NAMESPACE, AbstractDaoTest.BDEF_NAME, AbstractDaoTest.FORMAT_USAGE_CODE, AbstractDaoTest.FORMAT_FILE_TYPE_CODE, AbstractDaoTest.FORMAT_VERSION, AbstractDaoTest.PARTITION_VALUE, AbstractDaoTest.SUBPARTITION_VALUES, AbstractDaoTest.DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(AbstractDaoTest.STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStorage(storageEntity);
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode(AbstractDaoTest.STORAGE_UNIT_STATUS);
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity)).thenReturn((Object)businessObjectDataKey);
        this.storageUnitDaoHelper.setStorageUnitStatus(storageUnitEntity, storageUnitStatusEntity);
        Assert.assertEquals((Object)AbstractDaoTest.STORAGE_UNIT_STATUS, (Object)storageUnitEntity.getStatus().getCode());
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(businessObjectDataEntity);
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processStorageUnitStatusChangeNotificationEvent(businessObjectDataKey, AbstractDaoTest.STORAGE_NAME, AbstractDaoTest.STORAGE_UNIT_STATUS, AbstractDaoTest.NO_STORAGE_UNIT_STATUS);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateStorageUnitStatusNewStatusPassedAsEntity() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(AbstractDaoTest.BDEF_NAMESPACE, AbstractDaoTest.BDEF_NAME, AbstractDaoTest.FORMAT_USAGE_CODE, AbstractDaoTest.FORMAT_FILE_TYPE_CODE, AbstractDaoTest.FORMAT_VERSION, AbstractDaoTest.PARTITION_VALUE, AbstractDaoTest.SUBPARTITION_VALUES, AbstractDaoTest.DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(AbstractDaoTest.STORAGE_NAME);
        StorageUnitStatusEntity oldStorageUnitStatusEntity = new StorageUnitStatusEntity();
        oldStorageUnitStatusEntity.setCode(AbstractDaoTest.STORAGE_UNIT_STATUS);
        StorageUnitStatusEntity newStorageUnitStatusEntity = new StorageUnitStatusEntity();
        newStorageUnitStatusEntity.setCode(AbstractDaoTest.STORAGE_UNIT_STATUS_2);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setStatus(oldStorageUnitStatusEntity);
        storageUnitEntity.setHistoricalStatuses(new ArrayList());
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity)).thenReturn((Object)businessObjectDataKey);
        this.storageUnitDaoHelper.updateStorageUnitStatus(storageUnitEntity, newStorageUnitStatusEntity, AbstractDaoTest.STORAGE_UNIT_STATUS_2);
        Assert.assertEquals((Object)AbstractDaoTest.STORAGE_UNIT_STATUS_2, (Object)storageUnitEntity.getStatus().getCode());
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).saveAndRefresh((Object)storageUnitEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(businessObjectDataEntity);
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processStorageUnitStatusChangeNotificationEvent(businessObjectDataKey, AbstractDaoTest.STORAGE_NAME, AbstractDaoTest.STORAGE_UNIT_STATUS_2, AbstractDaoTest.STORAGE_UNIT_STATUS);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateStorageUnitStatusNewStatusPassedAsString() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(AbstractDaoTest.BDEF_NAMESPACE, AbstractDaoTest.BDEF_NAME, AbstractDaoTest.FORMAT_USAGE_CODE, AbstractDaoTest.FORMAT_FILE_TYPE_CODE, AbstractDaoTest.FORMAT_VERSION, AbstractDaoTest.PARTITION_VALUE, AbstractDaoTest.SUBPARTITION_VALUES, AbstractDaoTest.DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(AbstractDaoTest.STORAGE_NAME);
        StorageUnitStatusEntity oldStorageUnitStatusEntity = new StorageUnitStatusEntity();
        oldStorageUnitStatusEntity.setCode(AbstractDaoTest.STORAGE_UNIT_STATUS);
        StorageUnitStatusEntity newStorageUnitStatusEntity = new StorageUnitStatusEntity();
        newStorageUnitStatusEntity.setCode(AbstractDaoTest.STORAGE_UNIT_STATUS_2);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setStatus(oldStorageUnitStatusEntity);
        storageUnitEntity.setHistoricalStatuses(new ArrayList());
        Mockito.when((Object)this.storageUnitStatusDaoHelper.getStorageUnitStatusEntity(AbstractDaoTest.STORAGE_UNIT_STATUS_2)).thenReturn((Object)newStorageUnitStatusEntity);
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity)).thenReturn((Object)businessObjectDataKey);
        this.storageUnitDaoHelper.updateStorageUnitStatus(storageUnitEntity, AbstractDaoTest.STORAGE_UNIT_STATUS_2, AbstractDaoTest.STORAGE_UNIT_STATUS_2);
        Assert.assertEquals((Object)AbstractDaoTest.STORAGE_UNIT_STATUS_2, (Object)storageUnitEntity.getStatus().getCode());
        ((StorageUnitStatusDaoHelper)Mockito.verify((Object)this.storageUnitStatusDaoHelper)).getStorageUnitStatusEntity(AbstractDaoTest.STORAGE_UNIT_STATUS_2);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).saveAndRefresh((Object)storageUnitEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(businessObjectDataEntity);
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processStorageUnitStatusChangeNotificationEvent(businessObjectDataKey, AbstractDaoTest.STORAGE_NAME, AbstractDaoTest.STORAGE_UNIT_STATUS_2, AbstractDaoTest.STORAGE_UNIT_STATUS);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataHelper, this.messageNotificationEventService, this.storageUnitDao, this.storageUnitStatusDaoHelper});
    }
}

