/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.finra.herd.core.HerdDateUtils;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.Storage;
import org.finra.herd.model.api.xml.StorageDirectory;
import org.finra.herd.model.api.xml.StorageUnit;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class StorageUnitHelperTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private StorageFileHelper storageFileHelper;
    @InjectMocks
    private StorageUnitHelper storageUnitHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCreateBusinessObjectDataStorageUnitKey() {
        BusinessObjectDataStorageUnitKey result = this.storageUnitHelper.createBusinessObjectDataStorageUnitKey(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), STORAGE_NAME);
        Assert.assertEquals((Object)new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), (Object)result);
    }

    @Test
    public void testCreateStorageUnitKey() {
        BusinessObjectDataStorageUnitKey result = this.storageUnitHelper.createStorageUnitKey(new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), STORAGE_NAME);
        Assert.assertEquals((Object)new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), (Object)result);
    }

    @Test
    public void testCreateStorageUnitKeyFromEntity() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(businessObjectDataStorageUnitKey, STORAGE_UNIT_STATUS);
        Mockito.when((Object)this.businessObjectDataHelper.getSubPartitionValues(storageUnitEntity.getBusinessObjectData())).thenReturn((Object)SUBPARTITION_VALUES);
        BusinessObjectDataStorageUnitKey result = this.storageUnitHelper.createStorageUnitKeyFromEntity(storageUnitEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getSubPartitionValues(storageUnitEntity.getBusinessObjectData());
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), (Object)result);
    }

    @Test
    public void testCreateStorageUnitsFromEntities() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        Timestamp restoredExpirationOn = new Timestamp(new Date().getTime());
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(businessObjectDataStorageUnitKey, STORAGE_UNIT_STATUS);
        storageUnitEntity.setDirectoryPath(STORAGE_DIRECTORY_PATH);
        storageUnitEntity.setStoragePolicyTransitionFailedAttempts(STORAGE_POLICY_TRANSITION_FAILED_ATTEMPTS);
        storageUnitEntity.setRestoreExpirationOn(restoredExpirationOn);
        List result = this.storageUnitHelper.createStorageUnitsFromEntities(Arrays.asList(storageUnitEntity), NO_INCLUDE_STORAGE_UNIT_STATUS_HISTORY);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals(Arrays.asList(new StorageUnit(new Storage(STORAGE_NAME, "S3", null), new StorageDirectory(STORAGE_DIRECTORY_PATH), null, STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS_HISTORY, STORAGE_POLICY_TRANSITION_FAILED_ATTEMPTS, HerdDateUtils.getXMLGregorianCalendarValue((Date)restoredExpirationOn))), (Object)result);
    }

    @Test
    public void testGetBusinessObjectDataKey() {
        BusinessObjectDataKey result = this.storageUnitHelper.getBusinessObjectDataKey(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME));
        Assert.assertEquals((Object)new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION), (Object)result);
    }

    @Test
    public void testGetStorageUnitIds() {
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setId(INTEGER_VALUE);
        List result = this.storageUnitHelper.getStorageUnitIds(Arrays.asList(storageUnitEntity));
        Assert.assertEquals(Arrays.asList(INTEGER_VALUE), (Object)result);
        result = this.storageUnitHelper.getStorageUnitIds(new ArrayList());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testValidateBusinessObjectDataStorageUnitKey() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", BDEF_NAMESPACE)).thenReturn((Object)BDEF_NAMESPACE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object definition name", BDEF_NAME)).thenReturn((Object)BDEF_NAME);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object format usage", FORMAT_USAGE_CODE)).thenReturn((Object)FORMAT_USAGE_CODE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("business object format file type", FORMAT_FILE_TYPE_CODE)).thenReturn((Object)FORMAT_FILE_TYPE_CODE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("partition value", PARTITION_VALUE)).thenReturn((Object)PARTITION_VALUE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("storage name", STORAGE_NAME)).thenReturn((Object)STORAGE_NAME);
        this.storageUnitHelper.validateBusinessObjectDataStorageUnitKey(businessObjectDataStorageUnitKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", BDEF_NAMESPACE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object definition name", BDEF_NAME);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object format usage", FORMAT_USAGE_CODE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("business object format file type", FORMAT_FILE_TYPE_CODE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("partition value", PARTITION_VALUE);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).validateSubPartitionValues(SUBPARTITION_VALUES);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("storage name", STORAGE_NAME);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateBusinessObjectDataStorageUnitKeyInvalidParameters() {
        try {
            this.storageUnitHelper.validateBusinessObjectDataStorageUnitKey(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data storage unit key must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitHelper.validateBusinessObjectDataStorageUnitKey(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format version must be specified.", (Object)e.getMessage());
        }
        try {
            this.storageUnitHelper.validateBusinessObjectDataStorageUnitKey(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, NO_DATA_VERSION, STORAGE_NAME));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data version must be specified.", (Object)e.getMessage());
        }
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.businessObjectDataHelper, this.storageFileHelper});
    }
}

