/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.helper;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.TagKey;
import org.finra.herd.model.jpa.TagEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.TagHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TagHelperTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private JsonHelper jsonHelper;
    @InjectMocks
    private TagHelper tagHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testExecuteFunctionForTagEntities() {
        List<TagEntity> tagEntities = Collections.unmodifiableList(Arrays.asList(this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION), this.tagDaoTestHelper.createTagEntity(TAG_TYPE_2, TAG_CODE_2, TAG_DISPLAY_NAME_2, TAG_DESCRIPTION_2)));
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenReturn((Object)JSON_STRING);
        this.tagHelper.executeFunctionForTagEntities(SEARCH_INDEX_NAME, SEARCH_INDEX_DOCUMENT_TYPE, tagEntities, (indexName, documentType, id, json) -> {});
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper, (VerificationMode)Mockito.times((int)tagEntities.size()))).objectToJson(Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.jsonHelper});
    }

    @Test
    public void testSafeObjectMapperWriteValueAsString() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenReturn((Object)JSON_STRING);
        String result = this.tagHelper.safeObjectMapperWriteValueAsString(tagEntity);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson(Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.jsonHelper});
        Assert.assertEquals((Object)JSON_STRING, (Object)result);
    }

    @Test
    public void testSafeObjectMapperWriteValueAsStringJsonParseException() {
        TagEntity tagEntity = this.tagDaoTestHelper.createTagEntity(TAG_TYPE, TAG_CODE, TAG_DISPLAY_NAME, TAG_DESCRIPTION);
        Mockito.when((Object)this.jsonHelper.objectToJson(Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException((Throwable)new JsonParseException("Failed to Parse", new JsonLocation((Object)"SRC", 100L, 1, 2)))});
        String result = this.tagHelper.safeObjectMapperWriteValueAsString(tagEntity);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson(Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.jsonHelper});
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testValidateTagKey() {
        TagKey tagKey = new TagKey(TAG_TYPE, TAG_CODE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("tag type code", TAG_TYPE)).thenReturn((Object)TAG_TYPE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("tag code", TAG_CODE)).thenReturn((Object)TAG_CODE);
        this.tagHelper.validateTagKey(tagKey);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("tag type code", TAG_TYPE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("tag code", TAG_CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.jsonHelper});
        Assert.assertEquals((Object)new TagKey(TAG_TYPE, TAG_CODE), (Object)tagKey);
    }

    @Test
    public void testValidateTagKeyTagKeyIsNull() {
        try {
            this.tagHelper.validateTagKey(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A tag key must be specified.", (Object)e.getMessage());
        }
    }
}

