/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.util.Arrays;
import java.util.List;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.BusinessObjectDataRestoreDto;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.BusinessObjectDataFinalizeRestoreHelperService;
import org.finra.herd.service.NotificationEventService;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.finra.herd.service.impl.BusinessObjectDataFinalizeRestoreServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BusinessObjectDataFinalizeRestoreServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataFinalizeRestoreHelperService businessObjectDataFinalizeRestoreHelperService;
    @InjectMocks
    private BusinessObjectDataFinalizeRestoreServiceImpl businessObjectDataFinalizeRestoreServiceImpl;
    @Mock
    private NotificationEventService notificationEventService;
    @Mock
    private StorageUnitDao storageUnitDao;
    @Mock
    private StorageUnitHelper storageUnitHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testFinalizeRestore() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey storageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, Arrays.asList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT)), NO_EXCEPTION);
        Mockito.when((Object)this.businessObjectDataFinalizeRestoreHelperService.prepareToFinalizeRestore(storageUnitKey)).thenReturn((Object)businessObjectDataRestoreDto);
        ((BusinessObjectDataFinalizeRestoreHelperService)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                BusinessObjectDataRestoreDto businessObjectDataRestoreDto = (BusinessObjectDataRestoreDto)invocation.getArguments()[0];
                businessObjectDataRestoreDto.setNewStorageUnitStatus("RESTORED");
                businessObjectDataRestoreDto.setOldStorageUnitStatus("RESTORING");
                return null;
            }
        }).when((Object)this.businessObjectDataFinalizeRestoreHelperService)).completeFinalizeRestore(businessObjectDataRestoreDto);
        this.businessObjectDataFinalizeRestoreServiceImpl.finalizeRestore(storageUnitKey);
        ((BusinessObjectDataFinalizeRestoreHelperService)Mockito.verify((Object)this.businessObjectDataFinalizeRestoreHelperService)).prepareToFinalizeRestore(storageUnitKey);
        ((BusinessObjectDataFinalizeRestoreHelperService)Mockito.verify((Object)this.businessObjectDataFinalizeRestoreHelperService)).executeS3SpecificSteps(businessObjectDataRestoreDto);
        ((BusinessObjectDataFinalizeRestoreHelperService)Mockito.verify((Object)this.businessObjectDataFinalizeRestoreHelperService)).completeFinalizeRestore(businessObjectDataRestoreDto);
        ((NotificationEventService)Mockito.verify((Object)this.notificationEventService)).processStorageUnitNotificationEventAsync(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG, businessObjectDataKey, STORAGE_NAME, "RESTORED", "RESTORING");
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetS3StorageUnitsToRestore() {
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        List<StorageUnitEntity> storageUnitEntities = Arrays.asList(storageUnitEntity);
        BusinessObjectDataStorageUnitKey storageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        Mockito.when((Object)this.storageUnitDao.getS3StorageUnitsToRestore(MAX_RESULT.intValue())).thenReturn(storageUnitEntities);
        Mockito.when((Object)this.storageUnitHelper.createStorageUnitKeyFromEntity(storageUnitEntity)).thenReturn((Object)storageUnitKey);
        List result = this.businessObjectDataFinalizeRestoreServiceImpl.getS3StorageUnitsToRestore(MAX_RESULT.intValue());
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getS3StorageUnitsToRestore(MAX_RESULT.intValue());
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).createStorageUnitKeyFromEntity(storageUnitEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals(Arrays.asList(storageUnitKey), (Object)result);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataFinalizeRestoreHelperService, this.notificationEventService, this.storageUnitDao, this.storageUnitHelper});
    }
}

