/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.Tag;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.core.helper.LogLevel;
import org.finra.herd.dao.BusinessObjectFormatDao;
import org.finra.herd.dao.HerdDao;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.dao.helper.HerdStringHelper;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.BusinessObjectDataDestroyDto;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDataStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.RetentionTypeEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StoragePlatformEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.BusinessObjectFormatHelper;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageFileDaoHelper;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.impl.BusinessObjectDataInitiateDestroyHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class BusinessObjectDataInitiateDestroyHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @InjectMocks
    private BusinessObjectDataInitiateDestroyHelperServiceImpl businessObjectDataInitiateDestroyHelperServiceImpl;
    @Mock
    private BusinessObjectFormatDao businessObjectFormatDao;
    @Mock
    private BusinessObjectFormatHelper businessObjectFormatHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private HerdDao herdDao;
    @Mock
    private HerdStringHelper herdStringHelper;
    @Mock
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Mock
    private S3Service s3Service;
    @Mock
    private StorageFileDaoHelper storageFileDaoHelper;
    @Mock
    private StorageFileHelper storageFileHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitDao storageUnitDao;
    @Mock
    private StorageUnitDaoHelper storageUnitDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testExecuteInitiateDestroyAfterStep() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("VALID");
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("DISABLING");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        BusinessObjectDataDestroyDto businessObjectDataDestroyDto = new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLING", "ENABLED", S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS);
        BusinessObjectData businessObjectData = new BusinessObjectData();
        businessObjectData.setId(ID.intValue());
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        ((StorageUnitDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                String storageUnitStatus = (String)invocation.getArguments()[1];
                StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
                storageUnitStatusEntity.setCode(storageUnitStatus);
                StorageUnitEntity storageUnitEntity = (StorageUnitEntity)invocation.getArguments()[0];
                storageUnitEntity.setStatus(storageUnitStatusEntity);
                return null;
            }
        }).when((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "DISABLED", "DISABLED");
        Mockito.when((Object)this.businessObjectDataHelper.createBusinessObjectDataFromEntity(businessObjectDataEntity)).thenReturn((Object)businessObjectData);
        BusinessObjectData result = this.businessObjectDataInitiateDestroyHelperServiceImpl.executeInitiateDestroyAfterStep(businessObjectDataDestroyDto);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "DISABLED", "DISABLED");
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).createBusinessObjectDataFromEntity(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)businessObjectData, (Object)result);
        Assert.assertEquals((Object)new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLED", "DISABLING", S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS), (Object)businessObjectDataDestroyDto);
    }

    @Test
    public void testExecuteInitiateDestroyAfterStepInvalidStorageUnitStatus() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("VALID");
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("ARCHIVING");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        BusinessObjectDataDestroyDto businessObjectDataDestroyDto = new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLING", "ENABLED", S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS);
        BusinessObjectData businessObjectData = new BusinessObjectData();
        businessObjectData.setId(ID.intValue());
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.executeInitiateDestroyAfterStep(businessObjectDataDestroyDto);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage unit status is \"%s\", but must be \"%s\". Storage: {%s}, business object data: {%s}", "ARCHIVING", "DISABLING", STORAGE_NAME, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataKeyToString(businessObjectDataKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLING", "ENABLED", S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS), (Object)businessObjectDataDestroyDto);
    }

    @Test
    public void testExecuteS3SpecificSteps() {
        this.runExecuteS3SpecificStepsTest();
    }

    @Test
    public void testExecuteS3SpecificStepsWithLoggerLevelSetToInfo() {
        String loggerName = BusinessObjectDataInitiateDestroyHelperServiceImpl.class.getName();
        LogLevel origLoggerLevel = this.getLogLevel(loggerName);
        this.setLogLevel(loggerName, LogLevel.INFO);
        try {
            this.runExecuteS3SpecificStepsTest();
        }
        finally {
            this.setLogLevel(loggerName, origLoggerLevel);
        }
    }

    @Test
    public void testGetAndValidateFinalDestroyInDaysNonPositiveValue() {
        Mockito.when((Object)this.herdStringHelper.getConfigurationValueAsInteger(ConfigurationValue.BDATA_FINAL_DESTROY_DELAY_IN_DAYS)).thenReturn((Object)0);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.getAndValidateFinalDestroyInDays();
            junit.framework.Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Configuration \"%s\" must be a positive integer.", ConfigurationValue.BDATA_FINAL_DESTROY_DELAY_IN_DAYS.getKey()), (Object)e.getMessage());
        }
        ((HerdStringHelper)Mockito.verify((Object)this.herdStringHelper)).getConfigurationValueAsInteger(ConfigurationValue.BDATA_FINAL_DESTROY_DELAY_IN_DAYS);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetAndValidateStorageUnitInvalidStorageUnitStatus() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setId(ID);
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(STORAGE_NAME);
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode(INVALID_VALUE);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(Arrays.asList(storageUnitEntity));
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.getAndValidateStorageUnit(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Storage unit status \"%s\" is not supported by the business object data destroy feature. Storage: {%s}, business object data: {%s}", INVALID_VALUE, STORAGE_NAME, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataKeyToString(businessObjectDataKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetAndValidateStorageUnitMultipleS3StorageUnits() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setId(ID);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(Arrays.asList(new StorageUnitEntity(), new StorageUnitEntity()));
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.getAndValidateStorageUnit(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has multiple (%s) %s storage units. Business object data: {%s}", 2, "S3", BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataKeyToString(businessObjectDataKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetAndValidateStorageUnitNoS3StorageUnit() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setId(ID);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(new ArrayList());
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.getAndValidateStorageUnit(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no S3 storage unit. Business object data: {%s}", BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataKeyToString(businessObjectDataKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testPrepareToInitiateDestroy() {
        BusinessObjectDataDestroyDto businessObjectDataDestroyDto = new BusinessObjectDataDestroyDto();
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("PARTITION_VALUE");
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setLatestVersion(Boolean.valueOf(true));
        businessObjectFormatEntity.setRetentionType(retentionTypeEntity);
        businessObjectFormatEntity.setRetentionPeriodInDays(RETENTION_PERIOD_DAYS);
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("VALID");
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setPartitionValue(PARTITION_VALUE);
        businessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        StoragePlatformEntity storagePlatformEntity = new StoragePlatformEntity();
        storagePlatformEntity.setName("S3");
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setStoragePlatform(storagePlatformEntity);
        storageEntity.setName(STORAGE_NAME);
        List<StorageFileEntity> storageFileEntities = Arrays.asList(new StorageFileEntity());
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("ENABLED");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStorageFiles(storageFileEntities);
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(S3_KEY, Long.valueOf(1024L), Long.valueOf(1000L)));
        Timestamp currentTimestamp = new Timestamp(new Date().getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -(RETENTION_PERIOD_DAYS + 1));
        Date primaryPartitionValueDate = calendar.getTime();
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_TAG_KEY)).thenReturn((Object)S3_OBJECT_TAG_KEY);
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_TAG_VALUE)).thenReturn((Object)S3_OBJECT_TAG_VALUE);
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_ROLE_ARN)).thenReturn((Object)S3_OBJECT_TAGGER_ROLE_ARN);
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_ROLE_SESSION_NAME)).thenReturn((Object)S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        Mockito.when((Object)this.herdStringHelper.getConfigurationValueAsInteger(ConfigurationValue.BDATA_FINAL_DESTROY_DELAY_IN_DAYS)).thenReturn((Object)BDATA_FINAL_DESTROY_DELAY_IN_DAYS);
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.businessObjectDataHelper.getDateFromString(PARTITION_VALUE)).thenReturn((Object)primaryPartitionValueDate);
        Mockito.when((Object)this.herdDao.getCurrentTimestamp()).thenReturn((Object)currentTimestamp);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(Arrays.asList(storageUnitEntity));
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX)).thenReturn((Object)S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX);
        Mockito.when((Object)this.storageHelper.getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX, storageEntity, false, true)).thenReturn((Object)true);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME)).thenReturn((Object)S3_ATTRIBUTE_NAME_BUCKET_NAME);
        Mockito.when((Object)this.storageHelper.getStorageAttributeValueByName(S3_ATTRIBUTE_NAME_BUCKET_NAME, storageEntity, true)).thenReturn((Object)S3_BUCKET_NAME);
        Mockito.when((Object)this.s3KeyPrefixHelper.buildS3KeyPrefix(storageEntity, businessObjectFormatEntity, businessObjectDataKey)).thenReturn((Object)TEST_S3_KEY_PREFIX);
        Mockito.when((Object)this.storageFileHelper.getAndValidateStorageFilesIfPresent(storageUnitEntity, TEST_S3_KEY_PREFIX, STORAGE_NAME, businessObjectDataKey)).thenReturn(storageFiles);
        ((StorageUnitDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                String storageUnitStatus = (String)invocation.getArguments()[1];
                StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
                storageUnitStatusEntity.setCode(storageUnitStatus);
                StorageUnitEntity storageUnitEntity = (StorageUnitEntity)invocation.getArguments()[0];
                storageUnitEntity.setStatus(storageUnitStatusEntity);
                return null;
            }
        }).when((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "DISABLING", "DISABLING");
        ((BusinessObjectDataDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                String businessObjectDataStatus = (String)invocation.getArguments()[1];
                BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
                businessObjectDataStatusEntity.setCode(businessObjectDataStatus);
                BusinessObjectDataEntity businessObjectDataEntity = (BusinessObjectDataEntity)invocation.getArguments()[0];
                businessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
                return null;
            }
        }).when((Object)this.businessObjectDataDaoHelper)).updateBusinessObjectDataStatus(businessObjectDataEntity, "DELETED");
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity)).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ENDPOINT)).thenReturn((Object)S3_ENDPOINT);
        this.businessObjectDataInitiateDestroyHelperServiceImpl.prepareToInitiateDestroy(businessObjectDataDestroyDto, businessObjectDataKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).validateBusinessObjectDataKey(businessObjectDataKey, true, true);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_TAG_KEY);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_TAG_VALUE);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_ROLE_ARN);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_OBJECT_DELETE_ROLE_SESSION_NAME);
        ((HerdStringHelper)Mockito.verify((Object)this.herdStringHelper)).getConfigurationValueAsInteger(ConfigurationValue.BDATA_FINAL_DESTROY_DELAY_IN_DAYS);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getDateFromString(PARTITION_VALUE);
        ((HerdDao)Mockito.verify((Object)this.herdDao)).getCurrentTimestamp();
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX, storageEntity, false, true);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageAttributeValueByName(S3_ATTRIBUTE_NAME_BUCKET_NAME, storageEntity, true);
        ((S3KeyPrefixHelper)Mockito.verify((Object)this.s3KeyPrefixHelper)).buildS3KeyPrefix(storageEntity, businessObjectFormatEntity, businessObjectDataKey);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getAndValidateStorageFilesIfPresent(storageUnitEntity, TEST_S3_KEY_PREFIX, STORAGE_NAME, businessObjectDataKey);
        ((StorageFileDaoHelper)Mockito.verify((Object)this.storageFileDaoHelper)).validateStorageFilesCount(STORAGE_NAME, businessObjectDataKey, TEST_S3_KEY_PREFIX, storageFileEntities.size());
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "DISABLING", "DISABLING");
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).updateBusinessObjectDataStatus(businessObjectDataEntity, "DELETED");
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(businessObjectDataEntity);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ENDPOINT);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLING", "ENABLED", S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS), (Object)businessObjectDataDestroyDto);
    }

    @Test
    public void testValidateBusinessObjectDataInvalidPrimaryPartitionValue() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("PARTITION_VALUE");
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setLatestVersion(Boolean.valueOf(true));
        businessObjectFormatEntity.setRetentionType(retentionTypeEntity);
        businessObjectFormatEntity.setRetentionPeriodInDays(RETENTION_PERIOD_DAYS);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setPartitionValue(PARTITION_VALUE);
        Mockito.when((Object)this.businessObjectDataHelper.getDateFromString(PARTITION_VALUE)).thenReturn(null);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.validateBusinessObjectData(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Primary partition value \"%s\" cannot get converted to a valid date. Business object data: {%s}", PARTITION_VALUE, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getDateFromString(PARTITION_VALUE);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataKeyToString(businessObjectDataKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateBusinessObjectDataInvalidRetentionType() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode(INVALID_VALUE);
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setLatestVersion(Boolean.valueOf(true));
        businessObjectFormatEntity.setRetentionType(retentionTypeEntity);
        businessObjectFormatEntity.setRetentionPeriodInDays(RETENTION_PERIOD_DAYS);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setPartitionValue(PARTITION_VALUE);
        Mockito.when((Object)this.businessObjectFormatHelper.businessObjectFormatKeyToString(businessObjectFormatKey)).thenReturn((Object)BUSINESS_OBJECT_FORMAT_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.validateBusinessObjectData(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Retention type \"%s\" is not supported by the business object data destroy feature. Business object format: {%s}", INVALID_VALUE, BUSINESS_OBJECT_FORMAT_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).businessObjectFormatKeyToString(businessObjectFormatKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateBusinessObjectDataNoRetentionInformation() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, INITIAL_FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode(PARTITION_VALUE);
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION);
        businessObjectFormatEntity.setLatestVersion(Boolean.valueOf(false));
        BusinessObjectFormatEntity latestVersionBusinessObjectFormatEntity = new BusinessObjectFormatEntity();
        latestVersionBusinessObjectFormatEntity.setBusinessObjectFormatVersion(INITIAL_FORMAT_VERSION);
        latestVersionBusinessObjectFormatEntity.setLatestVersion(Boolean.valueOf(true));
        latestVersionBusinessObjectFormatEntity.setRetentionType(null);
        latestVersionBusinessObjectFormatEntity.setRetentionPeriodInDays(RETENTION_PERIOD_DAYS);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setPartitionValue(PARTITION_VALUE);
        Mockito.when((Object)this.businessObjectFormatDao.getBusinessObjectFormatByAltKey(businessObjectFormatKey)).thenReturn((Object)latestVersionBusinessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatHelper.businessObjectFormatKeyToString(businessObjectFormatKey)).thenReturn((Object)BUSINESS_OBJECT_FORMAT_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.validateBusinessObjectData(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Retention information is not configured for the business object format. Business object format: {%s}", BUSINESS_OBJECT_FORMAT_KEY_AS_STRING), (Object)e.getMessage());
        }
        latestVersionBusinessObjectFormatEntity.setRetentionType(retentionTypeEntity);
        latestVersionBusinessObjectFormatEntity.setRetentionPeriodInDays(null);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.validateBusinessObjectData(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Retention information is not configured for the business object format. Business object format: {%s}", BUSINESS_OBJECT_FORMAT_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((BusinessObjectFormatDao)Mockito.verify((Object)this.businessObjectFormatDao, (VerificationMode)Mockito.times((int)2))).getBusinessObjectFormatByAltKey(businessObjectFormatKey);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper, (VerificationMode)Mockito.times((int)2))).businessObjectFormatKeyToString(businessObjectFormatKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateBusinessObjectDataRetentionThresholdCheckFails() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("PARTITION_VALUE");
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        businessObjectFormatEntity.setLatestVersion(Boolean.valueOf(true));
        businessObjectFormatEntity.setRetentionType(retentionTypeEntity);
        businessObjectFormatEntity.setRetentionPeriodInDays(RETENTION_PERIOD_DAYS);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setPartitionValue(PARTITION_VALUE);
        Timestamp currentTimestamp = new Timestamp(new Date().getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -(RETENTION_PERIOD_DAYS - 1));
        Date primaryPartitionValueDate = calendar.getTime();
        Mockito.when((Object)this.businessObjectDataHelper.getDateFromString(PARTITION_VALUE)).thenReturn((Object)primaryPartitionValueDate);
        Mockito.when((Object)this.herdDao.getCurrentTimestamp()).thenReturn((Object)currentTimestamp);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.validateBusinessObjectData(businessObjectDataEntity, businessObjectDataKey);
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data fails retention threshold check for retention type \"%s\" with retention period of %d days. Business object data: {%s}", "PARTITION_VALUE", RETENTION_PERIOD_DAYS, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getDateFromString(PARTITION_VALUE);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataKeyToString(businessObjectDataKey);
        ((HerdDao)Mockito.verify((Object)this.herdDao)).getCurrentTimestamp();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateStorageValidatePathPrefixNotEnabled() {
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(STORAGE_NAME);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX)).thenReturn((Object)S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX);
        Mockito.when((Object)this.storageHelper.getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX, storageEntity, false, true)).thenReturn((Object)false);
        try {
            this.businessObjectDataInitiateDestroyHelperServiceImpl.validateStorage(storageEntity);
            junit.framework.Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)String.format("Path prefix validation must be enabled on \"%s\" storage.", STORAGE_NAME), (Object)e.getMessage());
        }
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX, storageEntity, false, true);
        this.verifyNoMoreInteractionsHelper();
    }

    private void runExecuteS3SpecificStepsTest() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        String storageFilePath = TEST_S3_KEY_PREFIX + "/" + "foo.dat";
        BusinessObjectDataDestroyDto businessObjectDataDestroyDto = new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLING", "ENABLED", S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferRequestParamsDto s3ObjectTaggerParamsDto = new S3FileTransferRequestParamsDto();
        s3ObjectTaggerParamsDto.setAwsAccessKeyId(AWS_ASSUMED_ROLE_ACCESS_KEY);
        s3ObjectTaggerParamsDto.setAwsSecretKey(AWS_ASSUMED_ROLE_SECRET_KEY);
        s3ObjectTaggerParamsDto.setSessionToken(AWS_ASSUMED_ROLE_SESSION_TOKEN);
        List<S3ObjectSummary> actualS3Files = Arrays.asList(new S3ObjectSummary());
        List<StorageFile> storageFilesSelectedForTagging = Arrays.asList(new StorageFile());
        List<File> filesSelectedForTagging = Arrays.asList(new File(storageFilePath));
        S3FileTransferRequestParamsDto updatedS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        updatedS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        updatedS3FileTransferRequestParamsDto.setS3KeyPrefix(TEST_S3_KEY_PREFIX + "/");
        updatedS3FileTransferRequestParamsDto.setFiles(filesSelectedForTagging);
        S3FileTransferRequestParamsDto updatedS3ObjectTaggerParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3ObjectTaggerParamsDto.setAwsAccessKeyId(AWS_ASSUMED_ROLE_ACCESS_KEY);
        updatedS3ObjectTaggerParamsDto.setAwsSecretKey(AWS_ASSUMED_ROLE_SECRET_KEY);
        updatedS3ObjectTaggerParamsDto.setSessionToken(AWS_ASSUMED_ROLE_SESSION_TOKEN);
        updatedS3ObjectTaggerParamsDto.setS3Endpoint(S3_ENDPOINT);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDto()).thenReturn((Object)s3FileTransferRequestParamsDto);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDtoByRole(S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME)).thenReturn((Object)s3ObjectTaggerParamsDto);
        Mockito.when((Object)this.s3Service.listDirectory(s3FileTransferRequestParamsDto, false)).thenReturn(actualS3Files);
        Mockito.when((Object)this.storageFileHelper.createStorageFilesFromS3ObjectSummaries(actualS3Files)).thenReturn(storageFilesSelectedForTagging);
        Mockito.when((Object)this.storageFileHelper.getFiles(storageFilesSelectedForTagging)).thenReturn(filesSelectedForTagging);
        this.businessObjectDataInitiateDestroyHelperServiceImpl.executeS3SpecificSteps(businessObjectDataDestroyDto);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDto();
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDtoByRole(S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory(s3FileTransferRequestParamsDto, false);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).createStorageFilesFromS3ObjectSummaries(actualS3Files);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getFiles(storageFilesSelectedForTagging);
        ((S3Service)Mockito.verify((Object)this.s3Service)).tagObjects(updatedS3FileTransferRequestParamsDto, updatedS3ObjectTaggerParamsDto, new Tag(S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataDestroyDto(businessObjectDataKey, STORAGE_NAME, "DELETED", "VALID", "DISABLING", "ENABLED", S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME, BDATA_FINAL_DESTROY_DELAY_IN_DAYS), (Object)businessObjectDataDestroyDto);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.businessObjectFormatDao, this.businessObjectFormatHelper, this.configurationHelper, this.herdDao, this.herdStringHelper, this.s3KeyPrefixHelper, this.s3Service, this.storageFileDaoHelper, this.storageFileHelper, this.storageHelper, this.storageUnitDao, this.storageUnitDaoHelper});
    }
}

