/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.dao.helper.HerdStringHelper;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.dto.BusinessObjectDataRestoreDto;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageFileDaoHelper;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.helper.StorageUnitStatusDaoHelper;
import org.finra.herd.service.impl.BusinessObjectDataInitiateRestoreHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectDataInitiateRestoreHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @InjectMocks
    private BusinessObjectDataInitiateRestoreHelperServiceImpl businessObjectDataInitiateRestoreHelperServiceImpl;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private HerdStringHelper herdStringHelper;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Mock
    private S3Service s3Service;
    @Mock
    private StorageFileDaoHelper storageFileDaoHelper;
    @Mock
    private StorageFileHelper storageFileHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitDao storageUnitDao;
    @Mock
    private StorageUnitDaoHelper storageUnitDaoHelper;
    @Mock
    private StorageUnitStatusDaoHelper storageUnitStatusDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testExecuteS3SpecificSteps() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<StorageFile> storageFiles = Collections.singletonList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT));
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, storageFiles, NO_EXCEPTION);
        S3FileTransferRequestParamsDto initialS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferRequestParamsDto updatedS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        updatedS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        updatedS3FileTransferRequestParamsDto.setS3KeyPrefix(S3_KEY_PREFIX + "/");
        S3ObjectSummary glacierS3ObjectSummary = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        Mockito.when((Object)glacierS3ObjectSummary.getStorageClass()).thenReturn((Object)StorageClass.Glacier.toString());
        List<S3ObjectSummary> actualS3Files = Collections.singletonList(glacierS3ObjectSummary);
        List<StorageFile> storageFilesCreatedFromActualS3Files = Collections.singletonList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT));
        List<File> filesToBeRestored = Collections.singletonList(new File(S3_KEY));
        S3FileTransferRequestParamsDto finalS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        finalS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        finalS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        finalS3FileTransferRequestParamsDto.setS3KeyPrefix(S3_KEY_PREFIX + "/");
        finalS3FileTransferRequestParamsDto.setFiles(filesToBeRestored);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDto()).thenReturn((Object)initialS3FileTransferRequestParamsDto);
        Mockito.when((Object)this.s3Service.listDirectory(updatedS3FileTransferRequestParamsDto, true)).thenReturn(actualS3Files);
        Mockito.when((Object)this.storageFileHelper.createStorageFilesFromS3ObjectSummaries(actualS3Files)).thenReturn(storageFilesCreatedFromActualS3Files);
        Mockito.when((Object)this.storageFileHelper.getFiles(storageFilesCreatedFromActualS3Files)).thenReturn(filesToBeRestored);
        this.businessObjectDataInitiateRestoreHelperServiceImpl.executeS3SpecificSteps(businessObjectDataRestoreDto);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDto();
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class), Matchers.eq((boolean)true));
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).validateRegisteredS3Files(storageFiles, actualS3Files, STORAGE_NAME, businessObjectDataKey);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).createStorageFilesFromS3ObjectSummaries(actualS3Files);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getFiles(storageFilesCreatedFromActualS3Files);
        ((S3Service)Mockito.verify((Object)this.s3Service)).restoreObjects(finalS3FileTransferRequestParamsDto, 36135);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, storageFiles, NO_EXCEPTION), (Object)businessObjectDataRestoreDto);
    }

    @Test
    public void testExecuteS3SpecificStepsNonGlacierObjectFound() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        List<StorageFile> storageFiles = Collections.singletonList(new StorageFile(S3_KEY, FILE_SIZE, ROW_COUNT));
        BusinessObjectDataRestoreDto businessObjectDataRestoreDto = new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, storageFiles, NO_EXCEPTION);
        S3FileTransferRequestParamsDto initialS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferRequestParamsDto updatedS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        updatedS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        updatedS3FileTransferRequestParamsDto.setS3KeyPrefix(S3_KEY_PREFIX + "/");
        S3ObjectSummary standardS3ObjectSummary = (S3ObjectSummary)Mockito.mock(S3ObjectSummary.class);
        Mockito.when((Object)standardS3ObjectSummary.getKey()).thenReturn((Object)S3_KEY);
        Mockito.when((Object)standardS3ObjectSummary.getStorageClass()).thenReturn((Object)StorageClass.Standard.toString());
        List<S3ObjectSummary> actualS3Files = Collections.singletonList(standardS3ObjectSummary);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDto()).thenReturn((Object)initialS3FileTransferRequestParamsDto);
        Mockito.when((Object)this.s3Service.listDirectory(updatedS3FileTransferRequestParamsDto, true)).thenReturn(actualS3Files);
        this.businessObjectDataInitiateRestoreHelperServiceImpl.executeS3SpecificSteps(businessObjectDataRestoreDto);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDto();
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class), Matchers.eq((boolean)true));
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).validateRegisteredS3Files(storageFiles, actualS3Files, STORAGE_NAME, businessObjectDataKey);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)businessObjectDataKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertNotNull((Object)businessObjectDataRestoreDto.getException());
        Assert.assertEquals(IllegalArgumentException.class, businessObjectDataRestoreDto.getException().getClass());
        Assert.assertEquals((Object)String.format("S3 file \"%s\" is not archived (found %s storage class when expecting %s). S3 Bucket Name: \"%s\"", S3_KEY, StorageClass.Standard.toString(), StorageClass.Glacier.toString(), S3_BUCKET_NAME), (Object)businessObjectDataRestoreDto.getException().getMessage());
        businessObjectDataRestoreDto.setException(NO_EXCEPTION);
        Assert.assertEquals((Object)new BusinessObjectDataRestoreDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, NO_STORAGE_UNIT_STATUS, NO_STORAGE_UNIT_STATUS, storageFiles, NO_EXCEPTION), (Object)businessObjectDataRestoreDto);
    }

    @Test
    public void testGetStorageUnit() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("ARCHIVED");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(Collections.singletonList(storageUnitEntity));
        StorageUnitEntity result = this.businessObjectDataInitiateRestoreHelperServiceImpl.getStorageUnit(businessObjectDataEntity);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)result, (Object)storageUnitEntity);
    }

    @Test
    public void testGetStorageUnitMultipleStorageUnitsExist() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        List<StorageUnitEntity> storageUnitEntities = Arrays.asList(new StorageUnitEntity(), new StorageUnitEntity());
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(storageUnitEntities);
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.getStorageUnit(businessObjectDataEntity);
            TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has multiple (%d) S3 storage units. Business object data: {%s}", storageUnitEntities.size(), BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitStorageUnitAlreadyEnabled() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("ENABLED");
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(Collections.singletonList(storageUnitEntity));
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.getStorageUnit(businessObjectDataEntity);
            TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is already available in \"%s\" S3 storage. Business object data: {%s}", STORAGE_NAME, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitStorageUnitAlreadyRestoring() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("RESTORING");
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(Collections.singletonList(storageUnitEntity));
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.getStorageUnit(businessObjectDataEntity);
            TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is already being restored in \"%s\" S3 storage. Business object data: {%s}", STORAGE_NAME, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitStorageUnitNoExists() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(new ArrayList());
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.getStorageUnit(businessObjectDataEntity);
            TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data has no S3 storage unit. Business object data: {%s}", BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetStorageUnitStorageUnitNotArchived() {
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode(STORAGE_UNIT_STATUS);
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        Mockito.when((Object)this.storageUnitDao.getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity)).thenReturn(Collections.singletonList(storageUnitEntity));
        Mockito.when((Object)this.businessObjectDataHelper.businessObjectDataEntityAltKeyToString(businessObjectDataEntity)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        try {
            this.businessObjectDataInitiateRestoreHelperServiceImpl.getStorageUnit(businessObjectDataEntity);
            TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("Business object data is not archived. S3 storage unit in \"%s\" storage must have \"%s\" status, but it actually has \"%s\" status. Business object data: {%s}", STORAGE_NAME, "ARCHIVED", STORAGE_UNIT_STATUS, BUSINESS_OBJECT_DATA_KEY_AS_STRING), (Object)e.getMessage());
        }
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).getStorageUnitsByStoragePlatformAndBusinessObjectData("S3", businessObjectDataEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).businessObjectDataEntityAltKeyToString(businessObjectDataEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.configurationHelper, this.herdStringHelper, this.jsonHelper, this.s3KeyPrefixHelper, this.s3Service, this.storageFileDaoHelper, this.storageFileHelper, this.storageHelper, this.storageUnitDao, this.storageUnitDaoHelper, this.storageUnitStatusDaoHelper});
    }
}

