/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitCreateResponse;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.StorageDirectory;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.StorageDaoHelper;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.finra.herd.service.impl.BusinessObjectDataStorageUnitServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectDataStorageUnitServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @InjectMocks
    private BusinessObjectDataStorageUnitServiceImpl businessObjectDataStorageUnitServiceImpl;
    @Mock
    private StorageDaoHelper storageDaoHelper;
    @Mock
    private StorageFileHelper storageFileHelper;
    @Mock
    private StorageUnitDao storageUnitDao;
    @Mock
    private StorageUnitHelper storageUnitHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCreateBusinessObjectDataStorageUnit() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        StorageDirectory storageDirectory = new StorageDirectory(STORAGE_DIRECTORY_PATH);
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(FILE_NAME, FILE_SIZE, ROW_COUNT), new StorageFile(FILE_NAME_2, FILE_SIZE_2, ROW_COUNT_2));
        BusinessObjectDataStorageUnitCreateRequest request = new BusinessObjectDataStorageUnitCreateRequest(businessObjectDataStorageUnitKey, storageDirectory, storageFiles, NO_DISCOVER_STORAGE_FILES);
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setId(ID);
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setName(STORAGE_NAME);
        List<StorageFileEntity> storageFileEntities = Arrays.asList(new StorageFileEntity(), new StorageFileEntity());
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setDirectoryPath(STORAGE_DIRECTORY_PATH);
        storageUnitEntity.setStorageFiles(storageFileEntities);
        BusinessObjectDataStorageUnitCreateResponse expectedResponse = new BusinessObjectDataStorageUnitCreateResponse(businessObjectDataStorageUnitKey, storageDirectory, storageFiles);
        Mockito.when((Object)this.storageUnitHelper.getBusinessObjectDataKey(businessObjectDataStorageUnitKey)).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storageDaoHelper.getStorageEntity(STORAGE_NAME)).thenReturn((Object)storageEntity);
        Mockito.when((Object)this.businessObjectDataDaoHelper.createStorageUnitEntity(businessObjectDataEntity, storageEntity, storageDirectory, storageFiles, NO_DISCOVER_STORAGE_FILES)).thenReturn((Object)storageUnitEntity);
        Mockito.when((Object)this.businessObjectDataHelper.createBusinessObjectDataKeyFromEntity(businessObjectDataEntity)).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.storageUnitHelper.createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME)).thenReturn((Object)businessObjectDataStorageUnitKey);
        Mockito.when((Object)this.storageFileHelper.createStorageFilesFromEntities(storageFileEntities)).thenReturn(storageFiles);
        BusinessObjectDataStorageUnitCreateResponse result = this.businessObjectDataStorageUnitServiceImpl.createBusinessObjectDataStorageUnit(request);
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).validateBusinessObjectDataStorageUnitKey(businessObjectDataStorageUnitKey);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).validateCreateRequestStorageFiles(storageFiles);
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).getBusinessObjectDataKey(businessObjectDataStorageUnitKey);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((StorageDaoHelper)Mockito.verify((Object)this.storageDaoHelper)).getStorageEntity(STORAGE_NAME);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).createStorageUnitEntity(businessObjectDataEntity, storageEntity, storageDirectory, storageFiles, NO_DISCOVER_STORAGE_FILES);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).createBusinessObjectDataKeyFromEntity(businessObjectDataEntity);
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).createStorageFilesFromEntities(storageFileEntities);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).saveAndRefresh((Object)storageUnitEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)expectedResponse, (Object)result);
    }

    @Test
    public void testCreateBusinessObjectDataStorageUnitCreateResponseDirectoryOnlyRegistration() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(businessObjectDataStorageUnitKey, STORAGE_UNIT_STATUS);
        storageUnitEntity.setDirectoryPath(STORAGE_DIRECTORY_PATH);
        BusinessObjectDataStorageUnitCreateResponse expectedResponse = new BusinessObjectDataStorageUnitCreateResponse(businessObjectDataStorageUnitKey, new StorageDirectory(STORAGE_DIRECTORY_PATH), null);
        Mockito.when((Object)this.businessObjectDataHelper.createBusinessObjectDataKeyFromEntity(storageUnitEntity.getBusinessObjectData())).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.storageUnitHelper.createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME)).thenReturn((Object)businessObjectDataStorageUnitKey);
        BusinessObjectDataStorageUnitCreateResponse result = this.businessObjectDataStorageUnitServiceImpl.createBusinessObjectDataStorageUnitCreateResponse(storageUnitEntity);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).createBusinessObjectDataKeyFromEntity(storageUnitEntity.getBusinessObjectData());
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)expectedResponse, (Object)result);
    }

    @Test
    public void testValidateBusinessObjectDataStorageUnitCreateRequestDirectoryOnlyRegistration() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        this.businessObjectDataStorageUnitServiceImpl.validateBusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitCreateRequest(businessObjectDataStorageUnitKey, new StorageDirectory(STORAGE_DIRECTORY_PATH), NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).validateBusinessObjectDataStorageUnitKey(businessObjectDataStorageUnitKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateBusinessObjectDataStorageUnitCreateRequestInvalidParameters() {
        try {
            this.businessObjectDataStorageUnitServiceImpl.validateBusinessObjectDataStorageUnitCreateRequest(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data storage unit create request must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageUnitServiceImpl.validateBusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), NO_STORAGE_DIRECTORY, NO_STORAGE_FILES, DISCOVER_STORAGE_FILES));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage directory must be specified when discovery of storage files is enabled.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageUnitServiceImpl.validateBusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), new StorageDirectory(STORAGE_DIRECTORY_PATH), Collections.singletonList(new StorageFile(FILE_NAME, FILE_SIZE, ROW_COUNT)), DISCOVER_STORAGE_FILES));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Storage files cannot be specified when discovery of storage files is enabled.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageUnitServiceImpl.validateBusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), NO_STORAGE_DIRECTORY, NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage directory or at least one storage file must be specified when discovery of storage files is not enabled.", (Object)e.getMessage());
        }
        try {
            this.businessObjectDataStorageUnitServiceImpl.validateBusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitCreateRequest(new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME), new StorageDirectory("      \t\t "), NO_STORAGE_FILES, NO_DISCOVER_STORAGE_FILES));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A storage directory path must be specified.", (Object)e.getMessage());
        }
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.storageDaoHelper, this.storageFileHelper, this.storageUnitDao, this.storageUnitHelper});
    }
}

