/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitStatusUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitStatusUpdateResponse;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.finra.herd.service.helper.StorageUnitStatusDaoHelper;
import org.finra.herd.service.impl.BusinessObjectDataStorageUnitStatusServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BusinessObjectDataStorageUnitStatusServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @InjectMocks
    private BusinessObjectDataStorageUnitStatusServiceImpl businessObjectDataStorageUnitStatusServiceImpl;
    @Mock
    private StorageUnitDaoHelper storageUnitDaoHelper;
    @Mock
    private StorageUnitHelper storageUnitHelper;
    @Mock
    private StorageUnitStatusDaoHelper storageUnitStatusDaoHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testUpdateBusinessObjectDataStorageUnitStatus() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        StorageUnitEntity storageUnitEntity = this.storageUnitDaoTestHelper.createStorageUnitEntity(businessObjectDataStorageUnitKey, STORAGE_UNIT_STATUS);
        StorageUnitStatusEntity storageUnitStatusEntity = this.storageUnitStatusDaoTestHelper.createStorageUnitStatusEntity(STORAGE_UNIT_STATUS_2);
        BusinessObjectDataStorageUnitStatusUpdateRequest request = new BusinessObjectDataStorageUnitStatusUpdateRequest(STORAGE_UNIT_STATUS_2);
        BusinessObjectDataStorageUnitStatusUpdateResponse expectedResponse = new BusinessObjectDataStorageUnitStatusUpdateResponse(businessObjectDataStorageUnitKey, STORAGE_UNIT_STATUS_2, STORAGE_UNIT_STATUS);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntityByKey(businessObjectDataStorageUnitKey)).thenReturn((Object)storageUnitEntity);
        Mockito.when((Object)this.storageUnitStatusDaoHelper.getStorageUnitStatusEntity(STORAGE_UNIT_STATUS_2)).thenReturn((Object)storageUnitStatusEntity);
        ((StorageUnitDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                StorageUnitEntity storageUnitEntity = (StorageUnitEntity)invocation.getArguments()[0];
                StorageUnitStatusEntity storageUnitStatusEntity = (StorageUnitStatusEntity)invocation.getArguments()[1];
                storageUnitEntity.setStatus(storageUnitStatusEntity);
                return null;
            }
        }).when((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, storageUnitStatusEntity, STORAGE_UNIT_STATUS_2);
        Mockito.when((Object)this.businessObjectDataHelper.createBusinessObjectDataKeyFromEntity(storageUnitEntity.getBusinessObjectData())).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.storageUnitHelper.createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME)).thenReturn((Object)businessObjectDataStorageUnitKey);
        BusinessObjectDataStorageUnitStatusUpdateResponse result = this.businessObjectDataStorageUnitStatusServiceImpl.updateBusinessObjectDataStorageUnitStatus(businessObjectDataStorageUnitKey, request);
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).validateBusinessObjectDataStorageUnitKey(businessObjectDataStorageUnitKey);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntityByKey(businessObjectDataStorageUnitKey);
        ((StorageUnitStatusDaoHelper)Mockito.verify((Object)this.storageUnitStatusDaoHelper)).getStorageUnitStatusEntity(STORAGE_UNIT_STATUS_2);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, storageUnitStatusEntity, STORAGE_UNIT_STATUS_2);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).createBusinessObjectDataKeyFromEntity(storageUnitEntity.getBusinessObjectData());
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)expectedResponse, (Object)result);
    }

    @Test
    public void testUpdateBusinessObjectDataStorageUnitStatusImplMissingStorageUnitStatus() {
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        try {
            this.businessObjectDataStorageUnitStatusServiceImpl.updateBusinessObjectDataStorageUnitStatusImpl(businessObjectDataStorageUnitKey, new BusinessObjectDataStorageUnitStatusUpdateRequest("      \t\t "));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object data storage unit status must be specified.", (Object)e.getMessage());
        }
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).validateBusinessObjectDataStorageUnitKey(businessObjectDataStorageUnitKey);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataHelper, this.storageUnitDaoHelper, this.storageUnitHelper, this.storageUnitStatusDaoHelper});
    }
}

