/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.BusinessObjectDefinitionDao;
import org.finra.herd.dao.BusinessObjectFormatDao;
import org.finra.herd.model.api.xml.BusinessObjectFormat;
import org.finra.herd.model.api.xml.BusinessObjectFormatKey;
import org.finra.herd.model.api.xml.BusinessObjectFormatRetentionInformationUpdateRequest;
import org.finra.herd.model.api.xml.BusinessObjectFormatSchemaBackwardsCompatibilityUpdateRequest;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.RetentionTypeEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.MessageNotificationEventService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.AttributeHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDefinitionHelper;
import org.finra.herd.service.helper.BusinessObjectFormatDaoHelper;
import org.finra.herd.service.helper.BusinessObjectFormatHelper;
import org.finra.herd.service.helper.CustomDdlDaoHelper;
import org.finra.herd.service.helper.DdlGeneratorFactory;
import org.finra.herd.service.helper.FileTypeDaoHelper;
import org.finra.herd.service.helper.PartitionKeyGroupDaoHelper;
import org.finra.herd.service.helper.SearchIndexUpdateHelper;
import org.finra.herd.service.impl.BusinessObjectFormatServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class BusinessObjectFormatServiceImplTest
extends AbstractServiceTest {
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private AttributeHelper attributeHelper;
    @Mock
    private BusinessObjectDataDao businessObjectDataDao;
    @Mock
    private BusinessObjectDefinitionDao businessObjectDefinitionDao;
    @Mock
    private BusinessObjectDefinitionDaoHelper businessObjectDefinitionDaoHelper;
    @Mock
    private BusinessObjectDefinitionHelper businessObjectDefinitionHelper;
    @Mock
    private BusinessObjectFormatDao businessObjectFormatDao;
    @Mock
    private BusinessObjectFormatDaoHelper businessObjectFormatDaoHelper;
    @Mock
    private BusinessObjectFormatHelper businessObjectFormatHelper;
    @InjectMocks
    private BusinessObjectFormatServiceImpl businessObjectFormatServiceImpl;
    @Mock
    private CustomDdlDaoHelper customDdlDaoHelper;
    @Mock
    private DdlGeneratorFactory ddlGeneratorFactory;
    @Mock
    private FileTypeDaoHelper fileTypeDaoHelper;
    @Mock
    private MessageNotificationEventService messageNotificationEventService;
    @Mock
    private PartitionKeyGroupDaoHelper partitionKeyGroupDaoHelper;
    @Mock
    private SearchIndexUpdateHelper searchIndexUpdateHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationMissingRequiredParameters() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format retention information update request must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, new BusinessObjectFormatRetentionInformationUpdateRequest(null, RETENTION_PERIOD_DAYS, "PARTITION_VALUE"));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A record flag in business object format retention information update request must be specified.", (Object)e.getMessage());
        }
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationNoRetentionType() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectFormatRetentionInformationUpdateRequest businessObjectFormatRetentionInformationUpdateRequest = new BusinessObjectFormatRetentionInformationUpdateRequest(RECORD_FLAG_SET, NO_RETENTION_PERIOD_IN_DAYS, NO_RETENTION_TYPE);
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        BusinessObjectFormat businessObjectFormat = new BusinessObjectFormat();
        businessObjectFormat.setId(ID.intValue());
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getBusinessObjectFormatEntity(businessObjectFormatKey)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatHelper.createBusinessObjectFormatFromEntity(businessObjectFormatEntity)).thenReturn((Object)businessObjectFormat);
        BusinessObjectFormat result = this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, businessObjectFormatRetentionInformationUpdateRequest);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getBusinessObjectFormatEntity(businessObjectFormatKey);
        ((BusinessObjectFormatDao)Mockito.verify((Object)this.businessObjectFormatDao)).saveAndRefresh((Object)businessObjectFormatEntity);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).createBusinessObjectFormatFromEntity(businessObjectFormatEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)businessObjectFormat, (Object)result);
        Assert.assertEquals((Object)businessObjectFormatEntity.isRecordFlag(), (Object)RECORD_FLAG_SET);
        Assert.assertEquals((Object)businessObjectFormatEntity.getRetentionPeriodInDays(), (Object)NO_RETENTION_PERIOD_IN_DAYS);
        Assert.assertNull((Object)businessObjectFormatEntity.getRetentionType());
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationNoRetentionTypeWithRetentionPeriodInDays() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, new BusinessObjectFormatRetentionInformationUpdateRequest(RECORD_FLAG_SET, RETENTION_PERIOD_DAYS, NO_RETENTION_TYPE));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A retention period in days cannot be specified without retention type.", (Object)e.getMessage());
        }
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationPartitionValueRetentionType() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectFormatRetentionInformationUpdateRequest businessObjectFormatRetentionInformationUpdateRequest = new BusinessObjectFormatRetentionInformationUpdateRequest(RECORD_FLAG_SET, RETENTION_PERIOD_DAYS, "PARTITION_VALUE");
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("PARTITION_VALUE");
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        BusinessObjectFormat businessObjectFormat = new BusinessObjectFormat();
        businessObjectFormat.setId(ID.intValue());
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getRecordRetentionTypeEntity("PARTITION_VALUE")).thenReturn((Object)retentionTypeEntity);
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getBusinessObjectFormatEntity(businessObjectFormatKey)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatHelper.createBusinessObjectFormatFromEntity(businessObjectFormatEntity)).thenReturn((Object)businessObjectFormat);
        BusinessObjectFormat result = this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, businessObjectFormatRetentionInformationUpdateRequest);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getRecordRetentionTypeEntity("PARTITION_VALUE");
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getBusinessObjectFormatEntity(businessObjectFormatKey);
        ((BusinessObjectFormatDao)Mockito.verify((Object)this.businessObjectFormatDao)).saveAndRefresh((Object)businessObjectFormatEntity);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).createBusinessObjectFormatFromEntity(businessObjectFormatEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)businessObjectFormat, (Object)result);
        Assert.assertEquals((Object)businessObjectFormatEntity.isRecordFlag(), (Object)RECORD_FLAG_SET);
        Assert.assertEquals((Object)businessObjectFormatEntity.getRetentionPeriodInDays(), (Object)RETENTION_PERIOD_DAYS);
        Assert.assertEquals((Object)businessObjectFormatEntity.getRetentionType(), (Object)retentionTypeEntity);
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationPartitionValueRetentionTypeMissingRetentionPeriodInDays() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("PARTITION_VALUE");
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getRecordRetentionTypeEntity("PARTITION_VALUE")).thenReturn((Object)retentionTypeEntity);
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, new BusinessObjectFormatRetentionInformationUpdateRequest(RECORD_FLAG_SET, NO_RETENTION_PERIOD_IN_DAYS, "PARTITION_VALUE"));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A retention period in days must be specified for %s retention type.", "PARTITION_VALUE"), (Object)e.getMessage());
        }
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getRecordRetentionTypeEntity("PARTITION_VALUE");
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationPartitionValueRetentionTypeNonPositiveRetentionPeriodInDays() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("PARTITION_VALUE");
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getRecordRetentionTypeEntity("PARTITION_VALUE")).thenReturn((Object)retentionTypeEntity);
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, new BusinessObjectFormatRetentionInformationUpdateRequest(RECORD_FLAG_SET, Integer.valueOf(0), "PARTITION_VALUE"));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A positive retention period in days must be specified for %s retention type.", "PARTITION_VALUE"), (Object)e.getMessage());
        }
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getRecordRetentionTypeEntity("PARTITION_VALUE");
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationRetentionDateRetentionType() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectFormatRetentionInformationUpdateRequest businessObjectFormatRetentionInformationUpdateRequest = new BusinessObjectFormatRetentionInformationUpdateRequest(RECORD_FLAG_SET, NO_RETENTION_PERIOD_IN_DAYS, "BDATA_RETENTION_DATE");
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("BDATA_RETENTION_DATE");
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        BusinessObjectFormat businessObjectFormat = new BusinessObjectFormat();
        businessObjectFormat.setId(ID.intValue());
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getRecordRetentionTypeEntity("BDATA_RETENTION_DATE")).thenReturn((Object)retentionTypeEntity);
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getBusinessObjectFormatEntity(businessObjectFormatKey)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatHelper.createBusinessObjectFormatFromEntity(businessObjectFormatEntity)).thenReturn((Object)businessObjectFormat);
        BusinessObjectFormat result = this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, businessObjectFormatRetentionInformationUpdateRequest);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getRecordRetentionTypeEntity("BDATA_RETENTION_DATE");
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getBusinessObjectFormatEntity(businessObjectFormatKey);
        ((BusinessObjectFormatDao)Mockito.verify((Object)this.businessObjectFormatDao)).saveAndRefresh((Object)businessObjectFormatEntity);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).createBusinessObjectFormatFromEntity(businessObjectFormatEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)businessObjectFormat, (Object)result);
        Assert.assertEquals((Object)businessObjectFormatEntity.isRecordFlag(), (Object)RECORD_FLAG_SET);
        Assert.assertEquals((Object)businessObjectFormatEntity.getRetentionPeriodInDays(), (Object)NO_RETENTION_PERIOD_IN_DAYS);
        Assert.assertEquals((Object)businessObjectFormatEntity.getRetentionType(), (Object)retentionTypeEntity);
    }

    @Test
    public void testUpdateBusinessObjectFormatRetentionInformationRetentionDateRetentionTypeWithRetentionPeriodInDays() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        RetentionTypeEntity retentionTypeEntity = new RetentionTypeEntity();
        retentionTypeEntity.setCode("BDATA_RETENTION_DATE");
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getRecordRetentionTypeEntity("BDATA_RETENTION_DATE")).thenReturn((Object)retentionTypeEntity);
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatRetentionInformation(businessObjectFormatKey, new BusinessObjectFormatRetentionInformationUpdateRequest(RECORD_FLAG_SET, RETENTION_PERIOD_DAYS, "BDATA_RETENTION_DATE"));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("A retention period in days cannot be specified for %s retention type.", "BDATA_RETENTION_DATE"), (Object)e.getMessage());
        }
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getRecordRetentionTypeEntity("BDATA_RETENTION_DATE");
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateBusinessObjectFormatSchemaBackwardsCompatibilityChanges() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        BusinessObjectFormatSchemaBackwardsCompatibilityUpdateRequest businessObjectFormatSchemaBackwardsCompatibilityUpdateRequest = new BusinessObjectFormatSchemaBackwardsCompatibilityUpdateRequest(ALLOW_NON_BACKWARDS_COMPATIBLE_CHANGES_SET);
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        BusinessObjectFormat businessObjectFormat = new BusinessObjectFormat();
        businessObjectFormat.setId(ID.intValue());
        Mockito.when((Object)this.businessObjectFormatDaoHelper.getBusinessObjectFormatEntity(businessObjectFormatKey)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatDao.saveAndRefresh((Object)businessObjectFormatEntity)).thenReturn((Object)businessObjectFormatEntity);
        Mockito.when((Object)this.businessObjectFormatHelper.createBusinessObjectFormatFromEntity(businessObjectFormatEntity)).thenReturn((Object)businessObjectFormat);
        BusinessObjectFormat result = this.businessObjectFormatServiceImpl.updateBusinessObjectFormatSchemaBackwardsCompatibilityChanges(businessObjectFormatKey, businessObjectFormatSchemaBackwardsCompatibilityUpdateRequest);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).validateBusinessObjectFormatKey(businessObjectFormatKey, Boolean.valueOf(false));
        ((BusinessObjectFormatDaoHelper)Mockito.verify((Object)this.businessObjectFormatDaoHelper)).getBusinessObjectFormatEntity(businessObjectFormatKey);
        ((BusinessObjectFormatDao)Mockito.verify((Object)this.businessObjectFormatDao)).saveAndRefresh((Object)businessObjectFormatEntity);
        ((BusinessObjectFormatHelper)Mockito.verify((Object)this.businessObjectFormatHelper)).createBusinessObjectFormatFromEntity(businessObjectFormatEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)businessObjectFormat, (Object)result);
        Assert.assertEquals((Object)businessObjectFormatEntity.isAllowNonBackwardsCompatibleChanges(), (Object)ALLOW_NON_BACKWARDS_COMPATIBLE_CHANGES_SET);
    }

    @Test
    public void testUpdateBusinessObjectFormatSchemaBackwardsCompatibilityChangesMissingRequiredParameters() {
        BusinessObjectFormatKey businessObjectFormatKey = new BusinessObjectFormatKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, NO_FORMAT_VERSION);
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatSchemaBackwardsCompatibilityChanges(businessObjectFormatKey, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A business object format schema backwards compatibility changes update request must be specified.", (Object)e.getMessage());
        }
        try {
            this.businessObjectFormatServiceImpl.updateBusinessObjectFormatSchemaBackwardsCompatibilityChanges(businessObjectFormatKey, new BusinessObjectFormatSchemaBackwardsCompatibilityUpdateRequest(null));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"allowNonBackwardsCompatibleChanges flag in business object format schema backwards compatibility changes update request must be specified.", (Object)e.getMessage());
        }
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.attributeHelper, this.businessObjectDataDao, this.businessObjectDefinitionDao, this.businessObjectDefinitionDaoHelper, this.businessObjectDefinitionHelper, this.businessObjectFormatDao, this.businessObjectFormatDaoHelper, this.businessObjectFormatHelper, this.customDdlDaoHelper, this.ddlGeneratorFactory, this.fileTypeDaoHelper, this.messageNotificationEventService, this.partitionKeyGroupDaoHelper, this.searchIndexUpdateHelper});
    }
}

