/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StoragePlatformEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.NotificationEventService;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.finra.herd.service.impl.CleanupDestroyedBusinessObjectDataServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CleanupDestroyedBusinessObjectDataServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDao mockBusinessObjectDataDao;
    @Mock
    private BusinessObjectDataDaoHelper mockBusinessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper mockBusinessObjectDataHelper;
    @InjectMocks
    private CleanupDestroyedBusinessObjectDataServiceImpl cleanupDestroyedBusinessObjectDataService;
    @Mock
    private NotificationEventService mockNotificationEventService;
    @Mock
    private StorageUnitDao mockStorageUnitDao;
    @Mock
    private StorageUnitHelper mockStorageUnitHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCleanupS3StorageUnit() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = (BusinessObjectDataEntity)Mockito.mock(BusinessObjectDataEntity.class);
        Mockito.when((Object)this.mockBusinessObjectDataHelper.createBusinessObjectDataKeyFromStorageUnitKey(businessObjectDataStorageUnitKey)).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.mockBusinessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.mockBusinessObjectDataHelper.getBusinessObjectDataKey(businessObjectDataEntity)).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)businessObjectDataEntity.getLatestVersion()).thenReturn((Object)true);
        Mockito.when((Object)this.mockBusinessObjectDataDao.getBusinessObjectDataMaxVersion(businessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_MAX_VERSION);
        Mockito.when((Object)this.mockBusinessObjectDataDao.getBusinessObjectDataByAltKey(new BusinessObjectDataKey(businessObjectDataKey.getNamespace(), businessObjectDataKey.getBusinessObjectDefinitionName(), businessObjectDataKey.getBusinessObjectFormatUsage(), businessObjectDataKey.getBusinessObjectFormatFileType(), businessObjectDataKey.getBusinessObjectFormatVersion(), businessObjectDataKey.getPartitionValue(), businessObjectDataKey.getSubPartitionValues(), BUSINESS_OBJECT_DATA_MAX_VERSION))).thenReturn((Object)businessObjectDataEntity);
        this.cleanupDestroyedBusinessObjectDataService.cleanupS3StorageUnit(businessObjectDataStorageUnitKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.mockBusinessObjectDataHelper)).createBusinessObjectDataKeyFromStorageUnitKey(businessObjectDataStorageUnitKey);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.mockBusinessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((BusinessObjectDataEntity)Mockito.verify((Object)businessObjectDataEntity)).getStorageUnits();
        ((BusinessObjectDataDao)Mockito.verify((Object)this.mockBusinessObjectDataDao)).delete((Object)businessObjectDataEntity);
        ((NotificationEventService)Mockito.verify((Object)this.mockNotificationEventService)).processStorageUnitNotificationEventAsync(NotificationEventTypeEntity.EventTypesStorageUnit.STRGE_UNIT_STTS_CHG, businessObjectDataKey, STORAGE_NAME, null, "DISABLED");
        ((NotificationEventService)Mockito.verify((Object)this.mockNotificationEventService)).processBusinessObjectDataNotificationEventAsync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG, businessObjectDataKey, null, "DELETED");
        ((BusinessObjectDataEntity)Mockito.verify((Object)businessObjectDataEntity)).getBusinessObjectDataChildren();
        ((BusinessObjectDataEntity)Mockito.verify((Object)businessObjectDataEntity)).getBusinessObjectDataParents();
        ((BusinessObjectDataEntity)Mockito.verify((Object)businessObjectDataEntity)).getLatestVersion();
        ((BusinessObjectDataDao)Mockito.verify((Object)this.mockBusinessObjectDataDao)).getBusinessObjectDataMaxVersion(businessObjectDataKey);
        ((BusinessObjectDataDao)Mockito.verify((Object)this.mockBusinessObjectDataDao)).getBusinessObjectDataByAltKey(new BusinessObjectDataKey(businessObjectDataKey.getNamespace(), businessObjectDataKey.getBusinessObjectDefinitionName(), businessObjectDataKey.getBusinessObjectFormatUsage(), businessObjectDataKey.getBusinessObjectFormatFileType(), businessObjectDataKey.getBusinessObjectFormatVersion(), businessObjectDataKey.getPartitionValue(), businessObjectDataKey.getSubPartitionValues(), BUSINESS_OBJECT_DATA_MAX_VERSION));
        ((BusinessObjectDataEntity)Mockito.verify((Object)businessObjectDataEntity)).setLatestVersion(Boolean.valueOf(true));
        ((BusinessObjectDataDao)Mockito.verify((Object)this.mockBusinessObjectDataDao)).saveAndRefresh((Object)businessObjectDataEntity);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{businessObjectDataEntity});
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCleanupS3StorageUnitWithIllegalArgumentException() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        BusinessObjectDataEntity businessObjectDataEntity = (BusinessObjectDataEntity)Mockito.mock(BusinessObjectDataEntity.class);
        StoragePlatformEntity storagePlatformEntity = new StoragePlatformEntity();
        storagePlatformEntity.setName("S3");
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setStoragePlatform(storagePlatformEntity);
        StorageUnitEntity storageUnitEntity1 = new StorageUnitEntity();
        storageUnitEntity1.setStorage(storageEntity);
        StorageUnitEntity storageUnitEntity2 = new StorageUnitEntity();
        storageUnitEntity2.setStorage(storageEntity);
        ArrayList storageUnitEntities = Lists.newArrayList();
        storageUnitEntities.add(storageUnitEntity1);
        storageUnitEntities.add(storageUnitEntity2);
        Mockito.when((Object)this.mockBusinessObjectDataHelper.createBusinessObjectDataKeyFromStorageUnitKey(businessObjectDataStorageUnitKey)).thenReturn((Object)businessObjectDataKey);
        Mockito.when((Object)this.mockBusinessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)businessObjectDataEntity.getStorageUnits()).thenReturn((Object)storageUnitEntities);
        Mockito.when((Object)this.mockBusinessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey)).thenReturn((Object)this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey));
        try {
            this.cleanupDestroyedBusinessObjectDataService.cleanupS3StorageUnit(businessObjectDataStorageUnitKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MatcherAssert.assertThat((Object)illegalArgumentException.getMessage(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)("Business object data has multiple (2) S3 storage units. Business object data: {" + this.businessObjectDataHelper.businessObjectDataKeyToString(businessObjectDataKey) + "}"))));
        }
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.mockBusinessObjectDataHelper)).createBusinessObjectDataKeyFromStorageUnitKey(businessObjectDataStorageUnitKey);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.mockBusinessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((BusinessObjectDataEntity)Mockito.verify((Object)businessObjectDataEntity)).getStorageUnits();
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.mockBusinessObjectDataHelper)).businessObjectDataKeyToString(businessObjectDataKey);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{businessObjectDataEntity});
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetS3StorageUnitsToCleanup() {
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        List<StorageUnitEntity> storageUnitEntities = Collections.singletonList(storageUnitEntity);
        BusinessObjectDataStorageUnitKey storageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        Mockito.when((Object)this.mockStorageUnitDao.getS3StorageUnitsToCleanup(MAX_RESULT.intValue())).thenReturn(storageUnitEntities);
        Mockito.when((Object)this.mockStorageUnitHelper.createStorageUnitKeyFromEntity(storageUnitEntity)).thenReturn((Object)storageUnitKey);
        List result = this.cleanupDestroyedBusinessObjectDataService.getS3StorageUnitsToCleanup(MAX_RESULT.intValue());
        ((StorageUnitDao)Mockito.verify((Object)this.mockStorageUnitDao)).getS3StorageUnitsToCleanup(MAX_RESULT.intValue());
        ((StorageUnitHelper)Mockito.verify((Object)this.mockStorageUnitHelper)).createStorageUnitKeyFromEntity(storageUnitEntity);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals(Collections.singletonList(storageUnitKey), (Object)result);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBusinessObjectDataHelper, this.mockBusinessObjectDataDaoHelper, this.mockBusinessObjectDataDao, this.mockNotificationEventService, this.mockStorageUnitDao, this.mockStorageUnitHelper});
    }
}

