/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.dao.FileTypeDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.api.xml.FileType;
import org.finra.herd.model.api.xml.FileTypeCreateRequest;
import org.finra.herd.model.api.xml.FileTypeKey;
import org.finra.herd.model.api.xml.FileTypeKeys;
import org.finra.herd.model.jpa.FileTypeEntity;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.FileTypeDaoHelper;
import org.finra.herd.service.impl.FileTypeServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class FileTypeServiceImplTest {
    private static final String FILE_TYPE_CODE_WITH_EXTRA_SPACES = AbstractDaoTest.FORMAT_FILE_TYPE_CODE + "    ";
    private static final FileTypeCreateRequest FILE_TYPE_CREATE_REQUEST = new FileTypeCreateRequest(){
        {
            this.setFileTypeCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        }
    };
    private static final FileTypeCreateRequest FILE_TYPE_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME = new FileTypeCreateRequest(){
        {
            this.setFileTypeCode(FILE_TYPE_CODE_WITH_EXTRA_SPACES);
        }
    };
    private static final FileTypeKey FILE_TYPE_KEY = new FileTypeKey(){
        {
            this.setFileTypeCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        }
    };
    private static final FileTypeKey FILE_TYPE_KEY_WITH_EXTRA_SPACES_IN_NAME = new FileTypeKey(){
        {
            this.setFileTypeCode(FILE_TYPE_CODE_WITH_EXTRA_SPACES);
        }
    };
    private static final FileTypeEntity FILE_TYPE_ENTITY = new FileTypeEntity(){
        {
            this.setCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
            this.setCreatedBy(AbstractDaoTest.CREATED_BY);
            this.setUpdatedBy(AbstractDaoTest.CREATED_BY);
            this.setCreatedOn(new Timestamp(AbstractDaoTest.CREATED_ON.getMillisecond()));
        }
    };
    private static final List<FileTypeKey> ALL_FILE_TYPE_KEYS = Arrays.asList(new FileTypeKey(){
        {
            this.setFileTypeCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        }
    }, new FileTypeKey(){
        {
            this.setFileTypeCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE_2);
        }
    }, new FileTypeKey(){
        {
            this.setFileTypeCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE_3);
        }
    });
    @InjectMocks
    private FileTypeServiceImpl fileTypeMockService;
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private FileTypeDao fileTypeMockDao;
    @Mock
    private FileTypeDaoHelper fileTypeDaoHelper;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testCreateFileType() {
        Mockito.when((Object)this.fileTypeMockDao.getFileTypeByCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE)).thenReturn(null);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        Mockito.when((Object)this.fileTypeMockDao.saveAndRefresh(ArgumentMatchers.any(FileTypeEntity.class))).thenReturn((Object)FILE_TYPE_ENTITY);
        FileType fileType = this.fileTypeMockService.createFileType(FILE_TYPE_CREATE_REQUEST);
        Assert.assertEquals((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE, (Object)fileType.getFileTypeCode());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("file type code", AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        ((FileTypeDao)Mockito.verify((Object)this.fileTypeMockDao)).getFileTypeByCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        ((FileTypeDao)Mockito.verify((Object)this.fileTypeMockDao)).saveAndRefresh(ArgumentMatchers.any(FileTypeEntity.class));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateFileTypeAlreadyExists() {
        this.expectedException.expect(AlreadyExistsException.class);
        this.expectedException.expectMessage(String.format("Unable to create file type \"%s\" because it already exists.", AbstractDaoTest.FORMAT_FILE_TYPE_CODE));
        Mockito.when((Object)this.fileTypeMockDao.getFileTypeByCode(AbstractDaoTest.FORMAT_FILE_TYPE_CODE)).thenReturn((Object)FILE_TYPE_ENTITY);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        this.fileTypeMockService.createFileType(FILE_TYPE_CREATE_REQUEST);
    }

    @Test
    public void testGetFileType() {
        Mockito.when((Object)this.fileTypeDaoHelper.getFileTypeEntity(AbstractDaoTest.FORMAT_FILE_TYPE_CODE)).thenReturn((Object)FILE_TYPE_ENTITY);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        FileType fileType = this.fileTypeMockService.getFileType(FILE_TYPE_KEY);
        Assert.assertEquals((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE, (Object)fileType.getFileTypeCode());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("file type code", FILE_TYPE_KEY.getFileTypeCode());
        ((FileTypeDaoHelper)Mockito.verify((Object)this.fileTypeDaoHelper)).getFileTypeEntity(AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetFileTypeNullKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A file type key must be specified");
        this.fileTypeMockService.getFileType(null);
    }

    @Test
    public void testDeleteFileType() {
        Mockito.when((Object)this.fileTypeDaoHelper.getFileTypeEntity(AbstractDaoTest.FORMAT_FILE_TYPE_CODE)).thenReturn((Object)FILE_TYPE_ENTITY);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        FileType fileType = this.fileTypeMockService.deleteFileType(FILE_TYPE_KEY);
        Assert.assertEquals((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE, (Object)fileType.getFileTypeCode());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("file type code", AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        ((FileTypeDaoHelper)Mockito.verify((Object)this.fileTypeDaoHelper)).getFileTypeEntity(AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        ((FileTypeDao)Mockito.verify((Object)this.fileTypeMockDao)).delete((Object)FILE_TYPE_ENTITY);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteFileTypeNullKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A file type key must be specified");
        this.fileTypeMockService.deleteFileType(null);
    }

    @Test
    public void testGetFileTypes() {
        Mockito.when((Object)this.fileTypeMockDao.getFileTypes()).thenReturn(ALL_FILE_TYPE_KEYS);
        FileTypeKeys fileTypeKeys = this.fileTypeMockService.getFileTypes();
        Assert.assertNotNull((Object)fileTypeKeys);
        Assert.assertEquals(ALL_FILE_TYPE_KEYS, (Object)fileTypeKeys.getFileTypeKeys());
        ((FileTypeDao)Mockito.verify((Object)this.fileTypeMockDao)).getFileTypes();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetFileTypesEmptyList() {
        Mockito.when((Object)this.fileTypeMockDao.getFileTypes()).thenReturn(Collections.emptyList());
        FileTypeKeys fileTypeKeys = this.fileTypeMockService.getFileTypes();
        Assert.assertNotNull((Object)fileTypeKeys);
        Assert.assertEquals((long)0L, (long)fileTypeKeys.getFileTypeKeys().size());
        ((FileTypeDao)Mockito.verify((Object)this.fileTypeMockDao)).getFileTypes();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateFileTypeCreateRequestExtraSpaces() {
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        Assert.assertEquals((Object)FILE_TYPE_CODE_WITH_EXTRA_SPACES, (Object)FILE_TYPE_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME.getFileTypeCode());
        this.fileTypeMockService.validateFileTypeCreateRequest(FILE_TYPE_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME);
        Assert.assertEquals((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE, (Object)FILE_TYPE_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME.getFileTypeCode());
    }

    @Test
    public void testValidateAndTrimFileTypeKeyExtraSpaces() {
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE);
        Assert.assertEquals((Object)FILE_TYPE_CODE_WITH_EXTRA_SPACES, (Object)FILE_TYPE_KEY_WITH_EXTRA_SPACES_IN_NAME.getFileTypeCode());
        this.fileTypeMockService.validateAndTrimFileTypeKey(FILE_TYPE_KEY_WITH_EXTRA_SPACES_IN_NAME);
        Assert.assertEquals((Object)AbstractDaoTest.FORMAT_FILE_TYPE_CODE, (Object)FILE_TYPE_KEY_WITH_EXTRA_SPACES_IN_NAME.getFileTypeCode());
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fileTypeDaoHelper, this.alternateKeyHelper, this.fileTypeMockDao});
    }
}

