/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.dao.SecurityFunctionDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.api.xml.SecurityFunction;
import org.finra.herd.model.api.xml.SecurityFunctionCreateRequest;
import org.finra.herd.model.api.xml.SecurityFunctionKey;
import org.finra.herd.model.api.xml.SecurityFunctionKeys;
import org.finra.herd.model.jpa.SecurityFunctionEntity;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.SecurityFunctionDaoHelper;
import org.finra.herd.service.impl.SecurityFunctionServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SecurityFunctionServiceImplTest {
    private static final String SECURITY_FUNCTION_NAME_WITH_EXTRA_SPACES = AbstractDaoTest.SECURITY_FUNCTION + "    ";
    private static final SecurityFunctionCreateRequest SECURITY_FUNCTION_CREATE_REQUEST = new SecurityFunctionCreateRequest(){
        {
            this.setSecurityFunctionName(AbstractDaoTest.SECURITY_FUNCTION);
        }
    };
    private static final SecurityFunctionCreateRequest SECURITY_FUNCTION_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME = new SecurityFunctionCreateRequest(){
        {
            this.setSecurityFunctionName(SECURITY_FUNCTION_NAME_WITH_EXTRA_SPACES);
        }
    };
    private static final SecurityFunctionKey SECURITY_FUNCTION_KEY = new SecurityFunctionKey(){
        {
            this.setSecurityFunctionName(AbstractDaoTest.SECURITY_FUNCTION);
        }
    };
    private static final SecurityFunctionKey SECURITY_FUNCTION_KEY_WITH_EXTRA_SPACES_IN_NAME = new SecurityFunctionKey(){
        {
            this.setSecurityFunctionName(SECURITY_FUNCTION_NAME_WITH_EXTRA_SPACES);
        }
    };
    private static final SecurityFunctionEntity SECURITY_FUNCTION_ENTITY = new SecurityFunctionEntity(){
        {
            this.setCode(AbstractDaoTest.SECURITY_FUNCTION);
            this.setCreatedBy(AbstractDaoTest.CREATED_BY);
            this.setUpdatedBy(AbstractDaoTest.CREATED_BY);
            this.setCreatedOn(new Timestamp(AbstractDaoTest.CREATED_ON.getMillisecond()));
        }
    };
    private static final List<String> ALL_SECURITY_FUNCTION_NAMES = Arrays.asList(AbstractDaoTest.SECURITY_FUNCTION, AbstractDaoTest.SECURITY_FUNCTION_2, AbstractDaoTest.SECURITY_FUNCTION_3);
    @InjectMocks
    private SecurityFunctionServiceImpl securityFunctionService;
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private SecurityFunctionDao securityFunctionDao;
    @Mock
    private SecurityFunctionDaoHelper securityFunctionDaoHelper;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testCreateSecurityFunction() {
        Mockito.when((Object)this.securityFunctionDao.getSecurityFunctionByName(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn(null);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.when((Object)this.securityFunctionDao.saveAndRefresh(ArgumentMatchers.any(SecurityFunctionEntity.class))).thenReturn((Object)SECURITY_FUNCTION_ENTITY);
        SecurityFunction securityFunction = this.securityFunctionService.createSecurityFunction(SECURITY_FUNCTION_CREATE_REQUEST);
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION, (Object)securityFunction.getSecurityFunctionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION);
        ((SecurityFunctionDao)Mockito.verify((Object)this.securityFunctionDao)).getSecurityFunctionByName(AbstractDaoTest.SECURITY_FUNCTION);
        ((SecurityFunctionDao)Mockito.verify((Object)this.securityFunctionDao)).saveAndRefresh(ArgumentMatchers.any(SecurityFunctionEntity.class));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateSecurityFunctionAlreadyExists() {
        this.expectedException.expect(AlreadyExistsException.class);
        this.expectedException.expectMessage(String.format("Unable to create security function \"%s\" because it already exists.", AbstractDaoTest.SECURITY_FUNCTION));
        Mockito.when((Object)this.securityFunctionDao.getSecurityFunctionByName(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)SECURITY_FUNCTION_ENTITY);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION);
        this.securityFunctionService.createSecurityFunction(SECURITY_FUNCTION_CREATE_REQUEST);
    }

    @Test
    public void testGetSecurityFunction() {
        Mockito.when((Object)this.securityFunctionDaoHelper.getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)SECURITY_FUNCTION_ENTITY);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION);
        SecurityFunction securityFunction = this.securityFunctionService.getSecurityFunction(SECURITY_FUNCTION_KEY);
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION, (Object)securityFunction.getSecurityFunctionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security function name", SECURITY_FUNCTION_KEY.getSecurityFunctionName());
        ((SecurityFunctionDaoHelper)Mockito.verify((Object)this.securityFunctionDaoHelper)).getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityFunctionNullKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A security function key must be specified");
        this.securityFunctionService.getSecurityFunction(null);
    }

    @Test
    public void testDeleteSecurityFunction() {
        Mockito.when((Object)this.securityFunctionDaoHelper.getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)SECURITY_FUNCTION_ENTITY);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION);
        SecurityFunction securityFunction = this.securityFunctionService.deleteSecurityFunction(SECURITY_FUNCTION_KEY);
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION, (Object)securityFunction.getSecurityFunctionName());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("security function name", AbstractDaoTest.SECURITY_FUNCTION);
        ((SecurityFunctionDaoHelper)Mockito.verify((Object)this.securityFunctionDaoHelper)).getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION);
        ((SecurityFunctionDao)Mockito.verify((Object)this.securityFunctionDao)).delete((Object)SECURITY_FUNCTION_ENTITY);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteSecurityFunctionNullKey() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("A security function key must be specified");
        this.securityFunctionService.deleteSecurityFunction(null);
    }

    @Test
    public void testGetSecurityFunctions() {
        Mockito.when((Object)this.securityFunctionDao.getSecurityFunctions()).thenReturn(ALL_SECURITY_FUNCTION_NAMES);
        SecurityFunctionKeys securityFunctionKeys = this.securityFunctionService.getSecurityFunctions();
        Assert.assertNotNull((Object)securityFunctionKeys);
        List securityFunctionKeyList = securityFunctionKeys.getSecurityFunctionKeys();
        Assert.assertEquals((long)ALL_SECURITY_FUNCTION_NAMES.size(), (long)securityFunctionKeyList.size());
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION, (Object)((SecurityFunctionKey)securityFunctionKeyList.get(0)).getSecurityFunctionName());
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION_2, (Object)((SecurityFunctionKey)securityFunctionKeyList.get(1)).getSecurityFunctionName());
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION_3, (Object)((SecurityFunctionKey)securityFunctionKeyList.get(2)).getSecurityFunctionName());
        ((SecurityFunctionDao)Mockito.verify((Object)this.securityFunctionDao)).getSecurityFunctions();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityFunctionsEmptyList() {
        Mockito.when((Object)this.securityFunctionDao.getSecurityFunctions()).thenReturn(Collections.emptyList());
        SecurityFunctionKeys securityFunctionKeys = this.securityFunctionService.getSecurityFunctions();
        Assert.assertNotNull((Object)securityFunctionKeys);
        Assert.assertEquals((long)0L, (long)securityFunctionKeys.getSecurityFunctionKeys().size());
        ((SecurityFunctionDao)Mockito.verify((Object)this.securityFunctionDao)).getSecurityFunctions();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testValidateSecurityFunctionCreateRequestExtraSpaces() {
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION);
        Assert.assertEquals((Object)SECURITY_FUNCTION_NAME_WITH_EXTRA_SPACES, (Object)SECURITY_FUNCTION_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME.getSecurityFunctionName());
        this.securityFunctionService.validateSecurityFunctionCreateRequest(SECURITY_FUNCTION_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME);
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION, (Object)SECURITY_FUNCTION_CREATE_REQUEST_WITH_EXTRA_SPACES_IN_NAME.getSecurityFunctionName());
    }

    @Test
    public void testValidateAndTrimSecurityFunctionKeyExtraSpaces() {
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)AbstractDaoTest.SECURITY_FUNCTION);
        Assert.assertEquals((Object)SECURITY_FUNCTION_NAME_WITH_EXTRA_SPACES, (Object)SECURITY_FUNCTION_KEY_WITH_EXTRA_SPACES_IN_NAME.getSecurityFunctionName());
        this.securityFunctionService.validateAndTrimSecurityFunctionKey(SECURITY_FUNCTION_KEY_WITH_EXTRA_SPACES_IN_NAME);
        Assert.assertEquals((Object)AbstractDaoTest.SECURITY_FUNCTION, (Object)SECURITY_FUNCTION_KEY_WITH_EXTRA_SPACES_IN_NAME.getSecurityFunctionName());
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityFunctionDaoHelper, this.alternateKeyHelper, this.securityFunctionDao});
    }
}

