/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.util.Collections;
import java.util.List;
import org.finra.herd.dao.AbstractDaoTest;
import org.finra.herd.dao.SecurityRoleFunctionDao;
import org.finra.herd.model.AlreadyExistsException;
import org.finra.herd.model.api.xml.SecurityFunctionKey;
import org.finra.herd.model.api.xml.SecurityRoleFunction;
import org.finra.herd.model.api.xml.SecurityRoleFunctionCreateRequest;
import org.finra.herd.model.api.xml.SecurityRoleFunctionKey;
import org.finra.herd.model.api.xml.SecurityRoleFunctionKeys;
import org.finra.herd.model.api.xml.SecurityRoleKey;
import org.finra.herd.model.jpa.SecurityFunctionEntity;
import org.finra.herd.model.jpa.SecurityRoleEntity;
import org.finra.herd.model.jpa.SecurityRoleFunctionEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.helper.SecurityFunctionDaoHelper;
import org.finra.herd.service.helper.SecurityFunctionHelper;
import org.finra.herd.service.helper.SecurityRoleDaoHelper;
import org.finra.herd.service.helper.SecurityRoleFunctionDaoHelper;
import org.finra.herd.service.helper.SecurityRoleFunctionHelper;
import org.finra.herd.service.helper.SecurityRoleHelper;
import org.finra.herd.service.impl.SecurityRoleFunctionServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SecurityRoleFunctionServiceImplTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private SecurityFunctionDaoHelper securityFunctionDaoHelper;
    @Mock
    private SecurityFunctionHelper securityFunctionHelper;
    @Mock
    private SecurityRoleDaoHelper securityRoleDaoHelper;
    @Mock
    private SecurityRoleFunctionDao securityRoleFunctionDao;
    @Mock
    private SecurityRoleFunctionDaoHelper securityRoleFunctionDaoHelper;
    @Mock
    private SecurityRoleFunctionHelper securityRoleFunctionHelper;
    @InjectMocks
    private SecurityRoleFunctionServiceImpl securityRoleFunctionService;
    @Mock
    private SecurityRoleHelper securityRoleHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testCreateSecurityRoleFunction() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleFunctionCreateRequest securityRoleFunctionCreateRequest = new SecurityRoleFunctionCreateRequest(securityRoleFunctionKey);
        SecurityRoleEntity securityRoleEntity = new SecurityRoleEntity();
        securityRoleEntity.setCode(AbstractDaoTest.SECURITY_ROLE);
        SecurityFunctionEntity securityFunctionEntity = new SecurityFunctionEntity();
        securityFunctionEntity.setCode(AbstractDaoTest.SECURITY_FUNCTION);
        Mockito.when((Object)this.securityRoleFunctionDao.getSecurityRoleFunctionByKey(securityRoleFunctionKey)).thenReturn(null);
        Mockito.when((Object)this.securityRoleDaoHelper.getSecurityRoleEntity(AbstractDaoTest.SECURITY_ROLE)).thenReturn((Object)securityRoleEntity);
        Mockito.when((Object)this.securityFunctionDaoHelper.getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn((Object)securityFunctionEntity);
        ((SecurityRoleFunctionDao)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                SecurityRoleFunctionEntity securityRoleFunctionEntity = (SecurityRoleFunctionEntity)invocation.getArguments()[0];
                securityRoleFunctionEntity.setId(AbstractServiceTest.ID);
                return null;
            }
        }).when((Object)this.securityRoleFunctionDao)).saveAndRefresh(ArgumentMatchers.any(SecurityRoleFunctionEntity.class));
        SecurityRoleFunction result = this.securityRoleFunctionService.createSecurityRoleFunction(securityRoleFunctionCreateRequest);
        Assert.assertEquals((Object)new SecurityRoleFunction(result.getId(), securityRoleFunctionKey), (Object)result);
        ((SecurityRoleFunctionHelper)Mockito.verify((Object)this.securityRoleFunctionHelper)).validateAndTrimSecurityRoleFunctionCreateRequest(securityRoleFunctionCreateRequest);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).getSecurityRoleFunctionByKey(securityRoleFunctionKey);
        ((SecurityRoleDaoHelper)Mockito.verify((Object)this.securityRoleDaoHelper)).getSecurityRoleEntity(AbstractDaoTest.SECURITY_ROLE);
        ((SecurityFunctionDaoHelper)Mockito.verify((Object)this.securityFunctionDaoHelper)).getSecurityFunctionEntity(AbstractDaoTest.SECURITY_FUNCTION);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).saveAndRefresh(ArgumentMatchers.any(SecurityRoleFunctionEntity.class));
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testCreateSecurityRoleFunctionSecurityRoleFunctionAlreadyExists() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleFunctionCreateRequest securityRoleFunctionCreateRequest = new SecurityRoleFunctionCreateRequest(securityRoleFunctionKey);
        SecurityRoleFunctionEntity securityRoleFunctionEntity = new SecurityRoleFunctionEntity();
        Mockito.when((Object)this.securityRoleFunctionDao.getSecurityRoleFunctionByKey(securityRoleFunctionKey)).thenReturn((Object)securityRoleFunctionEntity);
        this.expectedException.expect(AlreadyExistsException.class);
        this.expectedException.expectMessage(String.format("Unable to create security role to function mapping for \"%s\" security role name and \"%s\" security function name because it already exists.", AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION));
        this.securityRoleFunctionService.createSecurityRoleFunction(securityRoleFunctionCreateRequest);
        ((SecurityRoleFunctionHelper)Mockito.verify((Object)this.securityRoleFunctionHelper)).validateAndTrimSecurityRoleFunctionCreateRequest(securityRoleFunctionCreateRequest);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).getSecurityRoleFunctionByKey(securityRoleFunctionKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteSecurityRoleFunction() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleEntity securityRoleEntity = new SecurityRoleEntity();
        securityRoleEntity.setCode(AbstractDaoTest.SECURITY_ROLE);
        SecurityFunctionEntity securityFunctionEntity = new SecurityFunctionEntity();
        securityFunctionEntity.setCode(AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleFunctionEntity securityRoleFunctionEntity = new SecurityRoleFunctionEntity();
        securityRoleFunctionEntity.setId(AbstractServiceTest.ID);
        securityRoleFunctionEntity.setSecurityRole(securityRoleEntity);
        securityRoleFunctionEntity.setSecurityFunction(securityFunctionEntity);
        Mockito.when((Object)this.securityRoleFunctionDaoHelper.getSecurityRoleFunctionEntity(securityRoleFunctionKey)).thenReturn((Object)securityRoleFunctionEntity);
        SecurityRoleFunction result = this.securityRoleFunctionService.deleteSecurityRoleFunction(securityRoleFunctionKey);
        Assert.assertEquals((Object)new SecurityRoleFunction(AbstractServiceTest.ID.intValue(), securityRoleFunctionKey), (Object)result);
        ((SecurityRoleFunctionHelper)Mockito.verify((Object)this.securityRoleFunctionHelper)).validateAndTrimSecurityRoleFunctionKey(securityRoleFunctionKey);
        ((SecurityRoleFunctionDaoHelper)Mockito.verify((Object)this.securityRoleFunctionDaoHelper)).getSecurityRoleFunctionEntity(securityRoleFunctionKey);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).delete((Object)securityRoleFunctionEntity);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityRoleFunction() {
        SecurityRoleFunctionKey securityRoleFunctionKey = new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleEntity securityRoleEntity = new SecurityRoleEntity();
        securityRoleEntity.setCode(AbstractDaoTest.SECURITY_ROLE);
        SecurityFunctionEntity securityFunctionEntity = new SecurityFunctionEntity();
        securityFunctionEntity.setCode(AbstractDaoTest.SECURITY_FUNCTION);
        SecurityRoleFunctionEntity securityRoleFunctionEntity = new SecurityRoleFunctionEntity();
        securityRoleFunctionEntity.setId(AbstractServiceTest.ID);
        securityRoleFunctionEntity.setSecurityRole(securityRoleEntity);
        securityRoleFunctionEntity.setSecurityFunction(securityFunctionEntity);
        Mockito.when((Object)this.securityRoleFunctionDaoHelper.getSecurityRoleFunctionEntity(securityRoleFunctionKey)).thenReturn((Object)securityRoleFunctionEntity);
        SecurityRoleFunction result = this.securityRoleFunctionService.getSecurityRoleFunction(securityRoleFunctionKey);
        Assert.assertEquals((Object)new SecurityRoleFunction(AbstractServiceTest.ID.intValue(), securityRoleFunctionKey), (Object)result);
        ((SecurityRoleFunctionHelper)Mockito.verify((Object)this.securityRoleFunctionHelper)).validateAndTrimSecurityRoleFunctionKey(securityRoleFunctionKey);
        ((SecurityRoleFunctionDaoHelper)Mockito.verify((Object)this.securityRoleFunctionDaoHelper)).getSecurityRoleFunctionEntity(securityRoleFunctionKey);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityRoleFunctions() {
        List<SecurityRoleFunctionKey> securityRoleFunctionKeys = Collections.singletonList(new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION));
        Mockito.when((Object)this.securityRoleFunctionDao.getSecurityRoleFunctionKeys()).thenReturn(securityRoleFunctionKeys);
        SecurityRoleFunctionKeys result = this.securityRoleFunctionService.getSecurityRoleFunctions();
        Assert.assertEquals((Object)new SecurityRoleFunctionKeys(securityRoleFunctionKeys), (Object)result);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).getSecurityRoleFunctionKeys();
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityRoleFunctionsBySecurityFunction() {
        SecurityFunctionKey securityFunctionKey = new SecurityFunctionKey(AbstractDaoTest.SECURITY_FUNCTION);
        List<SecurityRoleFunctionKey> securityRoleFunctionKeys = Collections.singletonList(new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION));
        Mockito.when((Object)this.securityRoleFunctionDao.getSecurityRoleFunctionKeysBySecurityFunction(AbstractDaoTest.SECURITY_FUNCTION)).thenReturn(securityRoleFunctionKeys);
        SecurityRoleFunctionKeys result = this.securityRoleFunctionService.getSecurityRoleFunctionsBySecurityFunction(securityFunctionKey);
        Assert.assertEquals((Object)new SecurityRoleFunctionKeys(securityRoleFunctionKeys), (Object)result);
        ((SecurityFunctionHelper)Mockito.verify((Object)this.securityFunctionHelper)).validateAndTrimSecurityFunctionKey(securityFunctionKey);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).getSecurityRoleFunctionKeysBySecurityFunction(AbstractDaoTest.SECURITY_FUNCTION);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testGetSecurityRoleFunctionsBySecurityRole() {
        SecurityRoleKey securityRoleKey = new SecurityRoleKey(AbstractDaoTest.SECURITY_ROLE);
        List<SecurityRoleFunctionKey> securityRoleFunctionKeys = Collections.singletonList(new SecurityRoleFunctionKey(AbstractDaoTest.SECURITY_ROLE, AbstractDaoTest.SECURITY_FUNCTION));
        Mockito.when((Object)this.securityRoleFunctionDao.getSecurityRoleFunctionKeysBySecurityRole(AbstractDaoTest.SECURITY_ROLE)).thenReturn(securityRoleFunctionKeys);
        SecurityRoleFunctionKeys result = this.securityRoleFunctionService.getSecurityRoleFunctionsBySecurityRole(securityRoleKey);
        Assert.assertEquals((Object)new SecurityRoleFunctionKeys(securityRoleFunctionKeys), (Object)result);
        ((SecurityRoleHelper)Mockito.verify((Object)this.securityRoleHelper)).validateAndTrimSecurityRoleKey(securityRoleKey);
        ((SecurityRoleFunctionDao)Mockito.verify((Object)this.securityRoleFunctionDao)).getSecurityRoleFunctionKeysBySecurityRole(AbstractDaoTest.SECURITY_ROLE);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityFunctionDaoHelper, this.securityFunctionHelper, this.securityRoleDaoHelper, this.securityRoleFunctionDao, this.securityRoleFunctionDaoHelper, this.securityRoleFunctionHelper, this.securityRoleHelper});
    }
}

