/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.Tag;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.finra.herd.core.helper.ConfigurationHelper;
import org.finra.herd.dao.StorageUnitDao;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.api.xml.BusinessObjectDataStorageUnitKey;
import org.finra.herd.model.api.xml.StorageFile;
import org.finra.herd.model.api.xml.StoragePolicyKey;
import org.finra.herd.model.dto.ConfigurationValue;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.dto.StoragePolicySelection;
import org.finra.herd.model.dto.StoragePolicyTransitionParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDataStatusEntity;
import org.finra.herd.model.jpa.BusinessObjectFormatEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StoragePlatformEntity;
import org.finra.herd.model.jpa.StoragePolicyEntity;
import org.finra.herd.model.jpa.StoragePolicyTransitionTypeEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.model.jpa.StorageUnitStatusEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.S3Service;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.S3KeyPrefixHelper;
import org.finra.herd.service.helper.StorageFileDaoHelper;
import org.finra.herd.service.helper.StorageFileHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StoragePolicyDaoHelper;
import org.finra.herd.service.helper.StoragePolicyHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.helper.StorageUnitHelper;
import org.finra.herd.service.impl.StoragePolicyProcessorHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class StoragePolicyProcessorHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private ConfigurationHelper configurationHelper;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private S3KeyPrefixHelper s3KeyPrefixHelper;
    @Mock
    private S3Service s3Service;
    @Mock
    private StorageFileDaoHelper storageFileDaoHelper;
    @Mock
    private StorageFileHelper storageFileHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StoragePolicyDaoHelper storagePolicyDaoHelper;
    @Mock
    private StoragePolicyHelper storagePolicyHelper;
    @InjectMocks
    private StoragePolicyProcessorHelperServiceImpl storagePolicyProcessorHelperServiceImpl;
    @Mock
    private StorageUnitDao storageUnitDao;
    @Mock
    private StorageUnitDaoHelper storageUnitDaoHelper;
    @Mock
    private StorageUnitHelper storageUnitHelper;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testCompleteStoragePolicyTransitionImpl() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("VALID");
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("ARCHIVING");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(TEST_S3_KEY_PREFIX + "/" + "foo.dat", Long.valueOf(1024L), Long.valueOf(1000L)));
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, "ARCHIVING", "ARCHIVING", storageFiles, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        ((StorageUnitDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                String storageUnitStatus = (String)invocation.getArguments()[1];
                StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
                storageUnitStatusEntity.setCode(storageUnitStatus);
                StorageUnitEntity storageUnitEntity = (StorageUnitEntity)invocation.getArguments()[0];
                storageUnitEntity.setStatus(storageUnitStatusEntity);
                return null;
            }
        }).when((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "ARCHIVED", "ARCHIVED");
        this.storagePolicyProcessorHelperServiceImpl.completeStoragePolicyTransitionImpl(storagePolicyTransitionParamsDto);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper, (VerificationMode)Mockito.times((int)2))).businessObjectDataKeyToString(businessObjectDataKey);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "ARCHIVED", "ARCHIVED");
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, "ARCHIVED", "ARCHIVING", storageFiles, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME), (Object)storagePolicyTransitionParamsDto);
    }

    @Test
    public void testExecuteStoragePolicyTransitionImpl() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        String storageFilePath = TEST_S3_KEY_PREFIX + "/" + "foo.dat";
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(storageFilePath, Long.valueOf(1024L), Long.valueOf(1000L)));
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, "ARCHIVING", "ENABLED", storageFiles, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        S3FileTransferRequestParamsDto s3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        S3FileTransferRequestParamsDto s3ObjectTaggerParamsDto = new S3FileTransferRequestParamsDto();
        s3ObjectTaggerParamsDto.setAwsAccessKeyId(AWS_ASSUMED_ROLE_ACCESS_KEY);
        s3ObjectTaggerParamsDto.setAwsSecretKey(AWS_ASSUMED_ROLE_SECRET_KEY);
        s3ObjectTaggerParamsDto.setSessionToken(AWS_ASSUMED_ROLE_SESSION_TOKEN);
        List<S3ObjectSummary> actualS3FilesWithoutZeroByteDirectoryMarkers = Arrays.asList(new S3ObjectSummary());
        List<S3ObjectSummary> actualS3Files = Arrays.asList(new S3ObjectSummary());
        List<StorageFile> storageFilesSelectedForTagging = Arrays.asList(new StorageFile());
        List<File> filesSelectedForTagging = Arrays.asList(new File(storageFilePath));
        S3FileTransferRequestParamsDto updatedS3FileTransferRequestParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3FileTransferRequestParamsDto.setS3Endpoint(S3_ENDPOINT);
        updatedS3FileTransferRequestParamsDto.setS3BucketName(S3_BUCKET_NAME);
        updatedS3FileTransferRequestParamsDto.setS3KeyPrefix(TEST_S3_KEY_PREFIX + "/");
        updatedS3FileTransferRequestParamsDto.setFiles(filesSelectedForTagging);
        S3FileTransferRequestParamsDto updatedS3ObjectTaggerParamsDto = new S3FileTransferRequestParamsDto();
        updatedS3ObjectTaggerParamsDto.setAwsAccessKeyId(AWS_ASSUMED_ROLE_ACCESS_KEY);
        updatedS3ObjectTaggerParamsDto.setAwsSecretKey(AWS_ASSUMED_ROLE_SECRET_KEY);
        updatedS3ObjectTaggerParamsDto.setSessionToken(AWS_ASSUMED_ROLE_SESSION_TOKEN);
        updatedS3ObjectTaggerParamsDto.setS3Endpoint(S3_ENDPOINT);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDto()).thenReturn((Object)s3FileTransferRequestParamsDto);
        Mockito.when((Object)this.storageHelper.getS3FileTransferRequestParamsDtoByRole(S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME)).thenReturn((Object)s3ObjectTaggerParamsDto);
        Mockito.when((Object)this.s3Service.listDirectory(s3FileTransferRequestParamsDto, true)).thenReturn(actualS3FilesWithoutZeroByteDirectoryMarkers);
        Mockito.when((Object)this.s3Service.listDirectory(s3FileTransferRequestParamsDto, false)).thenReturn(actualS3Files);
        Mockito.when((Object)this.storageFileHelper.createStorageFilesFromS3ObjectSummaries(actualS3Files)).thenReturn(storageFilesSelectedForTagging);
        Mockito.when((Object)this.storageFileHelper.getFiles(storageFilesSelectedForTagging)).thenReturn(filesSelectedForTagging);
        this.storagePolicyProcessorHelperServiceImpl.executeStoragePolicyTransitionImpl(storagePolicyTransitionParamsDto);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDto();
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getS3FileTransferRequestParamsDtoByRole(S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory(s3FileTransferRequestParamsDto, true);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).validateRegisteredS3Files(storageFiles, actualS3FilesWithoutZeroByteDirectoryMarkers, STORAGE_NAME, businessObjectDataKey);
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory(s3FileTransferRequestParamsDto, true);
        ((S3Service)Mockito.verify((Object)this.s3Service)).listDirectory(s3FileTransferRequestParamsDto, false);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).createStorageFilesFromS3ObjectSummaries(actualS3Files);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getFiles(storageFilesSelectedForTagging);
        ((S3Service)Mockito.verify((Object)this.s3Service)).tagObjects(updatedS3FileTransferRequestParamsDto, updatedS3ObjectTaggerParamsDto, new Tag(S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE));
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, TEST_S3_KEY_PREFIX, "ARCHIVING", "ENABLED", storageFiles, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME), (Object)storagePolicyTransitionParamsDto);
    }

    @Test
    public void testInitiateStoragePolicyTransitionImpl() {
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto();
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, NO_SUBPARTITION_VALUES, DATA_VERSION);
        BusinessObjectFormatEntity businessObjectFormatEntity = new BusinessObjectFormatEntity();
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("VALID");
        BusinessObjectDataEntity businessObjectDataEntity = new BusinessObjectDataEntity();
        businessObjectDataEntity.setBusinessObjectFormat(businessObjectFormatEntity);
        businessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        StoragePolicyKey storagePolicyKey = new StoragePolicyKey(STORAGE_POLICY_NAMESPACE_CD, STORAGE_POLICY_NAME);
        StoragePlatformEntity storagePlatformEntity = new StoragePlatformEntity();
        storagePlatformEntity.setName("S3");
        StorageEntity storageEntity = new StorageEntity();
        storageEntity.setStoragePlatform(storagePlatformEntity);
        storageEntity.setName(STORAGE_NAME);
        StoragePolicyTransitionTypeEntity storagePolicyTransitionTypeEntity = new StoragePolicyTransitionTypeEntity();
        storagePolicyTransitionTypeEntity.setCode("GLACIER");
        StoragePolicyEntity storagePolicyEntity = new StoragePolicyEntity();
        storagePolicyEntity.setStorage(storageEntity);
        storagePolicyEntity.setStoragePolicyTransitionType(storagePolicyTransitionTypeEntity);
        List<StorageFileEntity> storageFileEntities = Arrays.asList(new StorageFileEntity());
        StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
        storageUnitStatusEntity.setCode("ENABLED");
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStorage(storageEntity);
        storageUnitEntity.setBusinessObjectData(businessObjectDataEntity);
        storageUnitEntity.setStorageFiles(storageFileEntities);
        storageUnitEntity.setStatus(storageUnitStatusEntity);
        List<StorageFile> storageFiles = Arrays.asList(new StorageFile(S3_KEY, Long.valueOf(1024L), Long.valueOf(1000L)));
        Mockito.when((Object)this.businessObjectDataDaoHelper.getBusinessObjectDataEntity(businessObjectDataKey)).thenReturn((Object)businessObjectDataEntity);
        Mockito.when((Object)this.storagePolicyDaoHelper.getStoragePolicyEntityByKeyAndVersion(storagePolicyKey, STORAGE_POLICY_VERSION)).thenReturn((Object)storagePolicyEntity);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX)).thenReturn((Object)S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX);
        Mockito.when((Object)this.storageHelper.getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX, storageEntity, false, true)).thenReturn((Object)true);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE)).thenReturn((Object)S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE);
        Mockito.when((Object)this.storageHelper.getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE, storageEntity, false, true)).thenReturn((Object)true);
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME)).thenReturn((Object)S3_ATTRIBUTE_NAME_BUCKET_NAME);
        Mockito.when((Object)this.storageHelper.getStorageAttributeValueByName(S3_ATTRIBUTE_NAME_BUCKET_NAME, storageEntity, true)).thenReturn((Object)S3_BUCKET_NAME);
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_TAG_KEY)).thenReturn((Object)S3_OBJECT_TAG_KEY);
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_TAG_VALUE)).thenReturn((Object)S3_OBJECT_TAG_VALUE);
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_ARN)).thenReturn((Object)S3_OBJECT_TAGGER_ROLE_ARN);
        Mockito.when((Object)this.configurationHelper.getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_SESSION_NAME)).thenReturn((Object)S3_OBJECT_TAGGER_ROLE_SESSION_NAME);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity)).thenReturn((Object)storageUnitEntity);
        Mockito.when((Object)this.s3KeyPrefixHelper.buildS3KeyPrefix(storageEntity, businessObjectFormatEntity, businessObjectDataKey)).thenReturn((Object)S3_KEY_PREFIX);
        Mockito.when((Object)this.storageFileHelper.getAndValidateStorageFiles(storageUnitEntity, S3_KEY_PREFIX, STORAGE_NAME, businessObjectDataKey)).thenReturn(storageFiles);
        ((StorageUnitDaoHelper)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                String storageUnitStatus = (String)invocation.getArguments()[1];
                StorageUnitStatusEntity storageUnitStatusEntity = new StorageUnitStatusEntity();
                storageUnitStatusEntity.setCode(storageUnitStatus);
                StorageUnitEntity storageUnitEntity = (StorageUnitEntity)invocation.getArguments()[0];
                storageUnitEntity.setStatus(storageUnitStatusEntity);
                return null;
            }
        }).when((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "ARCHIVING", "ARCHIVING");
        Mockito.when((Object)this.configurationHelper.getProperty(ConfigurationValue.S3_ENDPOINT)).thenReturn((Object)S3_ENDPOINT);
        this.storagePolicyProcessorHelperServiceImpl.initiateStoragePolicyTransitionImpl(storagePolicyTransitionParamsDto, new StoragePolicySelection(businessObjectDataKey, storagePolicyKey, STORAGE_POLICY_VERSION));
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).validateBusinessObjectDataKey(businessObjectDataKey, true, true);
        ((StoragePolicyHelper)Mockito.verify((Object)this.storagePolicyHelper)).validateStoragePolicyKey(storagePolicyKey);
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).getBusinessObjectDataEntity(businessObjectDataKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper, (VerificationMode)Mockito.times((int)2))).businessObjectDataKeyToString(businessObjectDataKey);
        ((StoragePolicyDaoHelper)Mockito.verify((Object)this.storagePolicyDaoHelper)).getStoragePolicyEntityByKeyAndVersion(storagePolicyKey, STORAGE_POLICY_VERSION);
        ((StoragePolicyHelper)Mockito.verify((Object)this.storagePolicyHelper, (VerificationMode)Mockito.times((int)2))).storagePolicyKeyAndVersionToString(storagePolicyKey, STORAGE_POLICY_VERSION);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_PATH_PREFIX, storageEntity, false, true);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getBooleanStorageAttributeValueByName(S3_ATTRIBUTE_NAME_VALIDATE_FILE_EXISTENCE, storageEntity, false, true);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ATTRIBUTE_NAME_BUCKET_NAME);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageAttributeValueByName(S3_ATTRIBUTE_NAME_BUCKET_NAME, storageEntity, true);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_TAG_KEY);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_TAG_VALUE);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_ARN);
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getRequiredProperty(ConfigurationValue.S3_ARCHIVE_TO_GLACIER_ROLE_SESSION_NAME);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity(STORAGE_NAME, businessObjectDataEntity);
        ((S3KeyPrefixHelper)Mockito.verify((Object)this.s3KeyPrefixHelper)).buildS3KeyPrefix(storageEntity, businessObjectFormatEntity, businessObjectDataKey);
        ((StorageFileHelper)Mockito.verify((Object)this.storageFileHelper)).getAndValidateStorageFiles(storageUnitEntity, S3_KEY_PREFIX, STORAGE_NAME, businessObjectDataKey);
        ((StorageFileDaoHelper)Mockito.verify((Object)this.storageFileDaoHelper)).validateStorageFilesCount(STORAGE_NAME, businessObjectDataKey, S3_KEY_PREFIX, storageFileEntities.size());
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).updateStorageUnitStatus(storageUnitEntity, "ARCHIVING", "ARCHIVING");
        ((ConfigurationHelper)Mockito.verify((Object)this.configurationHelper)).getProperty(ConfigurationValue.S3_ENDPOINT);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new StoragePolicyTransitionParamsDto(businessObjectDataKey, STORAGE_NAME, S3_ENDPOINT, S3_BUCKET_NAME, S3_KEY_PREFIX, "ARCHIVING", "ENABLED", storageFiles, S3_OBJECT_TAG_KEY, S3_OBJECT_TAG_VALUE, S3_OBJECT_TAGGER_ROLE_ARN, S3_OBJECT_TAGGER_ROLE_SESSION_NAME), (Object)storagePolicyTransitionParamsDto);
    }

    @Test
    public void testUpdateStoragePolicyTransitionFailedAttemptsIgnoreExceptionImplFirstFailure() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto();
        storagePolicyTransitionParamsDto.setBusinessObjectDataKey(businessObjectDataKey);
        storagePolicyTransitionParamsDto.setStorageName(STORAGE_NAME);
        Mockito.when((Object)this.storageUnitHelper.createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME)).thenReturn((Object)businessObjectDataStorageUnitKey);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntityByKey(businessObjectDataStorageUnitKey)).thenReturn((Object)storageUnitEntity);
        this.storagePolicyProcessorHelperServiceImpl.updateStoragePolicyTransitionFailedAttemptsIgnoreException(storagePolicyTransitionParamsDto);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)storagePolicyTransitionParamsDto);
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntityByKey(businessObjectDataStorageUnitKey);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).saveAndRefresh((Object)storageUnitEntity);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)businessObjectDataStorageUnitKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)1, (Object)storageUnitEntity.getStoragePolicyTransitionFailedAttempts());
    }

    @Test
    public void testUpdateStoragePolicyTransitionFailedAttemptsIgnoreExceptionImplNoBusinessObjectDataKey() {
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto();
        storagePolicyTransitionParamsDto.setStorageName(STORAGE_NAME);
        this.storagePolicyProcessorHelperServiceImpl.updateStoragePolicyTransitionFailedAttemptsIgnoreException(storagePolicyTransitionParamsDto);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)storagePolicyTransitionParamsDto);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateStoragePolicyTransitionFailedAttemptsIgnoreExceptionImplNoStorageName() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto();
        storagePolicyTransitionParamsDto.setBusinessObjectDataKey(businessObjectDataKey);
        this.storagePolicyProcessorHelperServiceImpl.updateStoragePolicyTransitionFailedAttemptsIgnoreException(storagePolicyTransitionParamsDto);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)storagePolicyTransitionParamsDto);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateStoragePolicyTransitionFailedAttemptsIgnoreExceptionImplSecondFailure() {
        BusinessObjectDataKey businessObjectDataKey = new BusinessObjectDataKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION);
        StorageUnitEntity storageUnitEntity = new StorageUnitEntity();
        storageUnitEntity.setStoragePolicyTransitionFailedAttempts(Integer.valueOf(1));
        BusinessObjectDataStorageUnitKey businessObjectDataStorageUnitKey = new BusinessObjectDataStorageUnitKey(BDEF_NAMESPACE, BDEF_NAME, FORMAT_USAGE_CODE, FORMAT_FILE_TYPE_CODE, FORMAT_VERSION, PARTITION_VALUE, SUBPARTITION_VALUES, DATA_VERSION, STORAGE_NAME);
        StoragePolicyTransitionParamsDto storagePolicyTransitionParamsDto = new StoragePolicyTransitionParamsDto();
        storagePolicyTransitionParamsDto.setBusinessObjectDataKey(businessObjectDataKey);
        storagePolicyTransitionParamsDto.setStorageName(STORAGE_NAME);
        Mockito.when((Object)this.storageUnitHelper.createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME)).thenReturn((Object)businessObjectDataStorageUnitKey);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntityByKey(businessObjectDataStorageUnitKey)).thenReturn((Object)storageUnitEntity);
        this.storagePolicyProcessorHelperServiceImpl.updateStoragePolicyTransitionFailedAttemptsIgnoreException(storagePolicyTransitionParamsDto);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)storagePolicyTransitionParamsDto);
        ((StorageUnitHelper)Mockito.verify((Object)this.storageUnitHelper)).createBusinessObjectDataStorageUnitKey(businessObjectDataKey, STORAGE_NAME);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntityByKey(businessObjectDataStorageUnitKey);
        ((StorageUnitDao)Mockito.verify((Object)this.storageUnitDao)).saveAndRefresh((Object)storageUnitEntity);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)businessObjectDataStorageUnitKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)2, (Object)storageUnitEntity.getStoragePolicyTransitionFailedAttempts());
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.configurationHelper, this.jsonHelper, this.s3KeyPrefixHelper, this.s3Service, this.storageFileDaoHelper, this.storageFileHelper, this.storageHelper, this.storagePolicyDaoHelper, this.storagePolicyHelper, this.storageUnitDao, this.storageUnitDaoHelper, this.storageUnitHelper});
    }
}

