/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import org.finra.herd.model.annotation.PublishNotificationMessages;
import org.finra.herd.model.api.xml.BusinessObjectData;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailability;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityCollectionResponse;
import org.finra.herd.model.api.xml.BusinessObjectDataAvailabilityRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataCreateRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataDdl;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlCollectionRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlCollectionResponse;
import org.finra.herd.model.api.xml.BusinessObjectDataDdlRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredRequest;
import org.finra.herd.model.api.xml.BusinessObjectDataInvalidateUnregisteredResponse;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.impl.BusinessObjectDataServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="herdTransactionManager")
@Primary
public class TestBusinessObjectDataServiceImpl
extends BusinessObjectDataServiceImpl {
    @Autowired
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;

    public BusinessObjectDataAvailability checkBusinessObjectDataAvailability(BusinessObjectDataAvailabilityRequest request) {
        return this.checkBusinessObjectDataAvailabilityImpl(request);
    }

    public BusinessObjectDataAvailabilityCollectionResponse checkBusinessObjectDataAvailabilityCollection(BusinessObjectDataAvailabilityCollectionRequest request) {
        return this.checkBusinessObjectDataAvailabilityCollectionImpl(request);
    }

    @PublishNotificationMessages
    public BusinessObjectData createBusinessObjectData(BusinessObjectDataCreateRequest request) {
        return this.businessObjectDataDaoHelper.createBusinessObjectData(request);
    }

    public BusinessObjectData destroyBusinessObjectData(BusinessObjectDataKey businessObjectDataKey) {
        return this.destroyBusinessObjectDataImpl(businessObjectDataKey);
    }

    public BusinessObjectDataDdl generateBusinessObjectDataDdl(BusinessObjectDataDdlRequest request) {
        return this.generateBusinessObjectDataDdlImpl(request, false);
    }

    public BusinessObjectDataDdlCollectionResponse generateBusinessObjectDataDdlCollection(BusinessObjectDataDdlCollectionRequest request) {
        return this.generateBusinessObjectDataDdlCollectionImpl(request);
    }

    public BusinessObjectData getBusinessObjectData(BusinessObjectDataKey businessObjectDataKey, String businessObjectFormatPartitionKey, String businessObjectDataStatus, Boolean includeBusinessObjectDataStatusHistory, Boolean includeStorageUnitStatusHistory) {
        return this.getBusinessObjectDataImpl(businessObjectDataKey, businessObjectFormatPartitionKey, businessObjectDataStatus, includeBusinessObjectDataStatusHistory, includeStorageUnitStatusHistory);
    }

    @PublishNotificationMessages
    public BusinessObjectDataInvalidateUnregisteredResponse invalidateUnregisteredBusinessObjectData(BusinessObjectDataInvalidateUnregisteredRequest businessObjectDataInvalidateUnregisteredRequest) {
        return this.invalidateUnregisteredBusinessObjectDataImpl(businessObjectDataInvalidateUnregisteredRequest);
    }

    public BusinessObjectData restoreBusinessObjectData(BusinessObjectDataKey businessObjectDataKey, Integer expirationInDays) {
        return this.restoreBusinessObjectDataImpl(businessObjectDataKey, expirationInDays);
    }
}

