/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.persistence.OptimisticLockException;
import org.finra.herd.dao.BusinessObjectDataDao;
import org.finra.herd.dao.S3Dao;
import org.finra.herd.dao.helper.AwsHelper;
import org.finra.herd.dao.helper.JsonHelper;
import org.finra.herd.model.api.xml.BusinessObjectDataKey;
import org.finra.herd.model.dto.AwsParamsDto;
import org.finra.herd.model.dto.CompleteUploadSingleParamsDto;
import org.finra.herd.model.dto.S3FileTransferRequestParamsDto;
import org.finra.herd.model.jpa.BusinessObjectDataEntity;
import org.finra.herd.model.jpa.BusinessObjectDataStatusEntity;
import org.finra.herd.model.jpa.NotificationEventTypeEntity;
import org.finra.herd.model.jpa.StorageEntity;
import org.finra.herd.model.jpa.StorageFileEntity;
import org.finra.herd.model.jpa.StorageUnitEntity;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.NotificationEventService;
import org.finra.herd.service.helper.BusinessObjectDataDaoHelper;
import org.finra.herd.service.helper.BusinessObjectDataHelper;
import org.finra.herd.service.helper.StorageDaoHelper;
import org.finra.herd.service.helper.StorageFileDaoHelper;
import org.finra.herd.service.helper.StorageHelper;
import org.finra.herd.service.helper.StorageUnitDaoHelper;
import org.finra.herd.service.impl.UploadDownloadHelperServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class UploadDownloadHelperServiceImplTest
extends AbstractServiceTest {
    @Mock
    private AwsHelper awsHelper;
    @Mock
    private BusinessObjectDataDao businessObjectDataDao;
    @Mock
    private BusinessObjectDataDaoHelper businessObjectDataDaoHelper;
    @Mock
    private BusinessObjectDataHelper businessObjectDataHelper;
    @Mock
    private JsonHelper jsonHelper;
    @Mock
    private NotificationEventService notificationEventService;
    @Mock
    private S3Dao s3Dao;
    @Mock
    private StorageDaoHelper storageDaoHelper;
    @Mock
    private StorageFileDaoHelper storageFileDaoHelper;
    @Mock
    private StorageHelper storageHelper;
    @Mock
    private StorageUnitDaoHelper storageUnitDaoHelper;
    @InjectMocks
    private UploadDownloadHelperServiceImpl uploadDownloadHelperService;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test
    public void testPrepareForFileMove() {
        String objectKey = UUID_VALUE;
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("UPLOADING");
        StorageEntity sourceStorageEntity = new StorageEntity();
        BusinessObjectDataKey sourceBusinessObjectDataKey = new BusinessObjectDataKey();
        sourceBusinessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = new BusinessObjectDataEntity();
        sourceBusinessObjectDataEntity.setId(ID);
        sourceBusinessObjectDataEntity.setPartitionValue(objectKey);
        sourceBusinessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        ArrayList<StorageFileEntity> sourceStorageFileEntities = new ArrayList<StorageFileEntity>();
        StorageUnitEntity sourceStorageUnitEntity = new StorageUnitEntity();
        sourceStorageUnitEntity.setBusinessObjectData(sourceBusinessObjectDataEntity);
        sourceStorageUnitEntity.setStorage(sourceStorageEntity);
        sourceStorageUnitEntity.setStorageFiles(sourceStorageFileEntities);
        StorageFileEntity sourceStorageFileEntity = new StorageFileEntity();
        sourceStorageFileEntities.add(sourceStorageFileEntity);
        sourceStorageFileEntity.setStorageUnit(sourceStorageUnitEntity);
        sourceStorageFileEntity.setPath(S3_KEY);
        sourceStorageFileEntity.setFileSizeBytes(FILE_SIZE);
        StorageEntity targetStorageEntity = new StorageEntity();
        BusinessObjectDataKey targetBusinessObjectDataKey = new BusinessObjectDataKey();
        targetBusinessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE_2);
        ArrayList<StorageFileEntity> targetStorageFileEntities = new ArrayList<StorageFileEntity>();
        StorageUnitEntity targetStorageUnitEntity = new StorageUnitEntity();
        targetStorageUnitEntity.setStorage(targetStorageEntity);
        targetStorageUnitEntity.setStorageFiles(targetStorageFileEntities);
        StorageFileEntity targetStorageFileEntity = new StorageFileEntity();
        targetStorageFileEntities.add(targetStorageFileEntity);
        targetStorageFileEntity.setPath(S3_KEY_2);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = new BusinessObjectDataEntity();
        targetBusinessObjectDataEntity.setId(ID_2);
        targetBusinessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        targetBusinessObjectDataEntity.setStorageUnits(Collections.singletonList(targetStorageUnitEntity));
        AwsParamsDto awsParamsDto = new AwsParamsDto(NO_AWS_ACCESS_KEY, NO_AWS_SECRET_KEY, NO_SESSION_TOKEN, HTTP_PROXY_HOST, HTTP_PROXY_PORT, "us-east-1");
        Mockito.when((Object)this.storageFileDaoHelper.getStorageFileEntity("S3_MANAGED_LOADING_DOCK", objectKey)).thenReturn((Object)sourceStorageFileEntity);
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity)).thenReturn((Object)sourceBusinessObjectDataKey);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataEntitiesByPartitionValue(objectKey)).thenReturn(Arrays.asList(sourceBusinessObjectDataEntity, targetBusinessObjectDataEntity));
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity)).thenReturn((Object)targetBusinessObjectDataKey);
        Mockito.when((Object)this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK")).thenReturn((Object)sourceStorageEntity);
        Mockito.when((Object)this.storageHelper.getStorageBucketName(sourceStorageEntity)).thenReturn((Object)S3_BUCKET_NAME);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity("S3_MANAGED_LOADING_DOCK", sourceBusinessObjectDataEntity)).thenReturn((Object)sourceStorageUnitEntity);
        Mockito.when((Object)this.awsHelper.getAwsParamsDto()).thenReturn((Object)awsParamsDto);
        Mockito.when((Object)this.storageHelper.getStorageBucketName(targetStorageEntity)).thenReturn((Object)S3_BUCKET_NAME_2);
        Mockito.when((Object)this.storageHelper.getStorageKmsKeyId(targetStorageEntity)).thenReturn((Object)AWS_KMS_KEY_ID);
        this.uploadDownloadHelperService.prepareForFileMoveImpl(objectKey, completeUploadSingleParamsDto);
        ((StorageFileDaoHelper)Mockito.verify((Object)this.storageFileDaoHelper)).getStorageFileEntity("S3_MANAGED_LOADING_DOCK", objectKey);
        ((StorageFileDaoHelper)Mockito.verify((Object)this.storageFileDaoHelper)).getStorageFileEntity("S3_MANAGED_LOADING_DOCK", objectKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(sourceBusinessObjectDataEntity);
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataEntitiesByPartitionValue(objectKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(targetBusinessObjectDataEntity);
        ((StorageDaoHelper)Mockito.verify((Object)this.storageDaoHelper)).getStorageEntity("S3_MANAGED_LOADING_DOCK");
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageBucketName(sourceStorageEntity);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity("S3_MANAGED_LOADING_DOCK", sourceBusinessObjectDataEntity);
        ((AwsHelper)Mockito.verify((Object)this.awsHelper, (VerificationMode)Mockito.times((int)2))).getAwsParamsDto();
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).validateS3File((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class), (Long)Matchers.eq((Object)FILE_SIZE));
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageBucketName(targetStorageEntity);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageKmsKeyId(targetStorageEntity);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).s3FileExists((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class));
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).updateBusinessObjectDataStatus(sourceBusinessObjectDataEntity, "RE-ENCRYPTING");
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).updateBusinessObjectDataStatus(targetBusinessObjectDataEntity, "RE-ENCRYPTING");
        ((NotificationEventService)Mockito.verify((Object)this.notificationEventService)).processBusinessObjectDataNotificationEventAsync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG, sourceBusinessObjectDataKey, "RE-ENCRYPTING", "UPLOADING");
        ((NotificationEventService)Mockito.verify((Object)this.notificationEventService)).processBusinessObjectDataNotificationEventAsync(NotificationEventTypeEntity.EventTypesBdata.BUS_OBJCT_DATA_STTS_CHG, targetBusinessObjectDataKey, "RE-ENCRYPTING", "UPLOADING");
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new CompleteUploadSingleParamsDto(sourceBusinessObjectDataKey, S3_BUCKET_NAME, S3_KEY, "UPLOADING", "RE-ENCRYPTING", targetBusinessObjectDataKey, S3_BUCKET_NAME_2, S3_KEY_2, "UPLOADING", "RE-ENCRYPTING", AWS_KMS_KEY_ID, awsParamsDto), (Object)completeUploadSingleParamsDto);
    }

    @Test
    public void testPrepareForFileMoveImplOptimisticLockException() {
        String objectKey = UUID_VALUE;
        CompleteUploadSingleParamsDto completeUploadSingleParamsDto = new CompleteUploadSingleParamsDto();
        BusinessObjectDataStatusEntity businessObjectDataStatusEntity = new BusinessObjectDataStatusEntity();
        businessObjectDataStatusEntity.setCode("UPLOADING");
        StorageEntity sourceStorageEntity = new StorageEntity();
        BusinessObjectDataKey sourceBusinessObjectDataKey = new BusinessObjectDataKey();
        sourceBusinessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE);
        BusinessObjectDataEntity sourceBusinessObjectDataEntity = new BusinessObjectDataEntity();
        sourceBusinessObjectDataEntity.setId(ID);
        sourceBusinessObjectDataEntity.setPartitionValue(objectKey);
        sourceBusinessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        ArrayList<StorageFileEntity> sourceStorageFileEntities = new ArrayList<StorageFileEntity>();
        StorageUnitEntity sourceStorageUnitEntity = new StorageUnitEntity();
        sourceStorageUnitEntity.setBusinessObjectData(sourceBusinessObjectDataEntity);
        sourceStorageUnitEntity.setStorage(sourceStorageEntity);
        sourceStorageUnitEntity.setStorageFiles(sourceStorageFileEntities);
        StorageFileEntity sourceStorageFileEntity = new StorageFileEntity();
        sourceStorageFileEntities.add(sourceStorageFileEntity);
        sourceStorageFileEntity.setStorageUnit(sourceStorageUnitEntity);
        sourceStorageFileEntity.setPath(S3_KEY);
        sourceStorageFileEntity.setFileSizeBytes(FILE_SIZE);
        StorageEntity targetStorageEntity = new StorageEntity();
        BusinessObjectDataKey targetBusinessObjectDataKey = new BusinessObjectDataKey();
        targetBusinessObjectDataKey.setBusinessObjectFormatUsage(FORMAT_USAGE_CODE_2);
        ArrayList<StorageFileEntity> targetStorageFileEntities = new ArrayList<StorageFileEntity>();
        StorageUnitEntity targetStorageUnitEntity = new StorageUnitEntity();
        targetStorageUnitEntity.setStorage(targetStorageEntity);
        targetStorageUnitEntity.setStorageFiles(targetStorageFileEntities);
        StorageFileEntity targetStorageFileEntity = new StorageFileEntity();
        targetStorageFileEntities.add(targetStorageFileEntity);
        targetStorageFileEntity.setPath(S3_KEY_2);
        BusinessObjectDataEntity targetBusinessObjectDataEntity = new BusinessObjectDataEntity();
        targetBusinessObjectDataEntity.setId(ID_2);
        targetBusinessObjectDataEntity.setStatus(businessObjectDataStatusEntity);
        targetBusinessObjectDataEntity.setStorageUnits(Collections.singletonList(targetStorageUnitEntity));
        AwsParamsDto awsParamsDto = new AwsParamsDto(NO_AWS_ACCESS_KEY, NO_AWS_SECRET_KEY, NO_SESSION_TOKEN, HTTP_PROXY_HOST, HTTP_PROXY_PORT, "us-east-1");
        Mockito.when((Object)this.storageFileDaoHelper.getStorageFileEntity("S3_MANAGED_LOADING_DOCK", objectKey)).thenReturn((Object)sourceStorageFileEntity);
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(sourceBusinessObjectDataEntity)).thenReturn((Object)sourceBusinessObjectDataKey);
        Mockito.when((Object)this.businessObjectDataDao.getBusinessObjectDataEntitiesByPartitionValue(objectKey)).thenReturn(Arrays.asList(sourceBusinessObjectDataEntity, targetBusinessObjectDataEntity));
        Mockito.when((Object)this.businessObjectDataHelper.getBusinessObjectDataKey(targetBusinessObjectDataEntity)).thenReturn((Object)targetBusinessObjectDataKey);
        Mockito.when((Object)this.storageDaoHelper.getStorageEntity("S3_MANAGED_LOADING_DOCK")).thenReturn((Object)sourceStorageEntity);
        Mockito.when((Object)this.storageHelper.getStorageBucketName(sourceStorageEntity)).thenReturn((Object)S3_BUCKET_NAME);
        Mockito.when((Object)this.storageUnitDaoHelper.getStorageUnitEntity("S3_MANAGED_LOADING_DOCK", sourceBusinessObjectDataEntity)).thenReturn((Object)sourceStorageUnitEntity);
        Mockito.when((Object)this.awsHelper.getAwsParamsDto()).thenReturn((Object)awsParamsDto);
        Mockito.when((Object)this.storageHelper.getStorageBucketName(targetStorageEntity)).thenReturn((Object)S3_BUCKET_NAME_2);
        Mockito.when((Object)this.storageHelper.getStorageKmsKeyId(targetStorageEntity)).thenReturn((Object)AWS_KMS_KEY_ID);
        ((BusinessObjectDataDaoHelper)Mockito.doThrow((Throwable[])new Throwable[]{new OptimisticLockException(ERROR_MESSAGE)}).when((Object)this.businessObjectDataDaoHelper)).updateBusinessObjectDataStatus(sourceBusinessObjectDataEntity, "RE-ENCRYPTING");
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)sourceBusinessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING);
        Mockito.when((Object)this.jsonHelper.objectToJson((Object)targetBusinessObjectDataKey)).thenReturn((Object)BUSINESS_OBJECT_DATA_KEY_AS_STRING_2);
        try {
            this.uploadDownloadHelperService.prepareForFileMoveImpl(objectKey, completeUploadSingleParamsDto);
        }
        catch (OptimisticLockException e) {
            Assert.assertEquals((Object)String.format("Ignoring S3 notification due to an optimistic lock exception caused by duplicate S3 event notifications. sourceBusinessObjectDataKey=%s targetBusinessObjectDataKey=%s", BUSINESS_OBJECT_DATA_KEY_AS_STRING, BUSINESS_OBJECT_DATA_KEY_AS_STRING_2), (Object)e.getMessage());
        }
        ((StorageFileDaoHelper)Mockito.verify((Object)this.storageFileDaoHelper)).getStorageFileEntity("S3_MANAGED_LOADING_DOCK", objectKey);
        ((StorageFileDaoHelper)Mockito.verify((Object)this.storageFileDaoHelper)).getStorageFileEntity("S3_MANAGED_LOADING_DOCK", objectKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(sourceBusinessObjectDataEntity);
        ((BusinessObjectDataDao)Mockito.verify((Object)this.businessObjectDataDao)).getBusinessObjectDataEntitiesByPartitionValue(objectKey);
        ((BusinessObjectDataHelper)Mockito.verify((Object)this.businessObjectDataHelper)).getBusinessObjectDataKey(targetBusinessObjectDataEntity);
        ((StorageDaoHelper)Mockito.verify((Object)this.storageDaoHelper)).getStorageEntity("S3_MANAGED_LOADING_DOCK");
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageBucketName(sourceStorageEntity);
        ((StorageUnitDaoHelper)Mockito.verify((Object)this.storageUnitDaoHelper)).getStorageUnitEntity("S3_MANAGED_LOADING_DOCK", sourceBusinessObjectDataEntity);
        ((AwsHelper)Mockito.verify((Object)this.awsHelper, (VerificationMode)Mockito.times((int)2))).getAwsParamsDto();
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).validateS3File((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class), (Long)Matchers.eq((Object)FILE_SIZE));
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageBucketName(targetStorageEntity);
        ((StorageHelper)Mockito.verify((Object)this.storageHelper)).getStorageKmsKeyId(targetStorageEntity);
        ((S3Dao)Mockito.verify((Object)this.s3Dao)).s3FileExists((S3FileTransferRequestParamsDto)Matchers.any(S3FileTransferRequestParamsDto.class));
        ((BusinessObjectDataDaoHelper)Mockito.verify((Object)this.businessObjectDataDaoHelper)).updateBusinessObjectDataStatus(sourceBusinessObjectDataEntity, "RE-ENCRYPTING");
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)sourceBusinessObjectDataKey);
        ((JsonHelper)Mockito.verify((Object)this.jsonHelper)).objectToJson((Object)targetBusinessObjectDataKey);
        this.verifyNoMoreInteractionsHelper();
        Assert.assertEquals((Object)new CompleteUploadSingleParamsDto(sourceBusinessObjectDataKey, S3_BUCKET_NAME, S3_KEY, "UPLOADING", NO_BDATA_STATUS, targetBusinessObjectDataKey, S3_BUCKET_NAME_2, S3_KEY_2, "UPLOADING", NO_BDATA_STATUS, AWS_KMS_KEY_ID, awsParamsDto), (Object)completeUploadSingleParamsDto);
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.awsHelper, this.businessObjectDataDao, this.businessObjectDataDaoHelper, this.businessObjectDataHelper, this.jsonHelper, this.notificationEventService, this.s3Dao, this.storageDaoHelper, this.storageFileDaoHelper, this.storageHelper, this.storageUnitDaoHelper});
    }
}

