/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.finra.herd.dao.UserNamespaceAuthorizationDao;
import org.finra.herd.model.api.xml.NamespacePermissionEnum;
import org.finra.herd.model.api.xml.UserAuthorizations;
import org.finra.herd.model.api.xml.UserNamespaceAuthorization;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationCreateRequest;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationKey;
import org.finra.herd.model.api.xml.UserNamespaceAuthorizationUpdateRequest;
import org.finra.herd.model.jpa.NamespaceEntity;
import org.finra.herd.model.jpa.UserNamespaceAuthorizationEntity;
import org.finra.herd.service.CurrentUserService;
import org.finra.herd.service.MessageNotificationEventService;
import org.finra.herd.service.UserNamespaceAuthorizationService;
import org.finra.herd.service.helper.AlternateKeyHelper;
import org.finra.herd.service.helper.NamespaceDaoHelper;
import org.finra.herd.service.helper.UserNamespaceAuthorizationHelper;
import org.finra.herd.service.impl.UserNamespaceAuthorizationServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class UserNamespaceAuthorizationServiceImplTest {
    private static final String USER_ID_VALUE = "testUserId";
    private static final String NAMESPACE_VALUE = "testNamespace";
    private static final int USER_NAMESPACE_AUTHORIZATION_ID = 10;
    private static final List<NamespacePermissionEnum> NAMESPACE_PERMISSIONS = ImmutableList.of((Object)NamespacePermissionEnum.READ);
    private static final UserNamespaceAuthorizationKey USER_NAMESPACE_AUTHORIZATION_KEY = new UserNamespaceAuthorizationKey("testUserId", "testNamespace");
    private static final UserNamespaceAuthorizationCreateRequest USER_NAMESPACE_AUTHORIZATION_CREATE_REQUEST = new UserNamespaceAuthorizationCreateRequest(USER_NAMESPACE_AUTHORIZATION_KEY, NAMESPACE_PERMISSIONS);
    private static final UserNamespaceAuthorizationUpdateRequest USER_NAMESPACE_AUTHORIZATION_UPDATE_REQUEST = new UserNamespaceAuthorizationUpdateRequest(NAMESPACE_PERMISSIONS);
    private static final NamespaceEntity NAMESPACE_ENTITY = new NamespaceEntity(){
        {
            this.setCode(UserNamespaceAuthorizationServiceImplTest.NAMESPACE_VALUE);
        }
    };
    private static final UserNamespaceAuthorizationEntity USER_NAMESPACE_AUTHORIZATION_ENTITY = new UserNamespaceAuthorizationEntity(){
        {
            this.setId(10);
            this.setUserId(UserNamespaceAuthorizationServiceImplTest.USER_ID_VALUE);
            this.setNamespace(NAMESPACE_ENTITY);
            this.setReadPermission(true);
        }
    };
    private static final UserAuthorizations USER_AUTHORIZATIONS = new UserAuthorizations(){
        {
            this.setUserId("currentUser");
        }
    };
    @InjectMocks
    private UserNamespaceAuthorizationService userNamespaceAuthorizationService = new UserNamespaceAuthorizationServiceImpl();
    @Mock
    private AlternateKeyHelper alternateKeyHelper;
    @Mock
    private CurrentUserService currentUserService;
    @Mock
    private NamespaceDaoHelper namespaceDaoHelper;
    @Mock
    private UserNamespaceAuthorizationDao userNamespaceAuthorizationDao;
    @Mock
    private UserNamespaceAuthorizationHelper userNamespaceAuthorizationHelper;
    @Mock
    private MessageNotificationEventService messageNotificationEventService;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testCreateUserNamespaceAuthorizationHappyPath() {
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", NAMESPACE_VALUE)).thenReturn((Object)NAMESPACE_VALUE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", USER_ID_VALUE)).thenReturn((Object)USER_ID_VALUE);
        Mockito.when((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(USER_NAMESPACE_AUTHORIZATION_KEY)).thenReturn(null);
        Mockito.when((Object)this.namespaceDaoHelper.getNamespaceEntity(NAMESPACE_VALUE)).thenReturn((Object)NAMESPACE_ENTITY);
        Mockito.when((Object)this.userNamespaceAuthorizationDao.saveAndRefresh(ArgumentMatchers.any())).thenReturn((Object)USER_NAMESPACE_AUTHORIZATION_ENTITY);
        Mockito.when((Object)this.userNamespaceAuthorizationHelper.getNamespacePermissions(USER_NAMESPACE_AUTHORIZATION_ENTITY)).thenReturn(NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorization userNamespaceAuthorization = this.userNamespaceAuthorizationService.createUserNamespaceAuthorization(USER_NAMESPACE_AUTHORIZATION_CREATE_REQUEST);
        Assert.assertEquals((long)10L, (long)userNamespaceAuthorization.getId());
        Assert.assertEquals((Object)USER_NAMESPACE_AUTHORIZATION_KEY, (Object)userNamespaceAuthorization.getUserNamespaceAuthorizationKey());
        Assert.assertEquals(NAMESPACE_PERMISSIONS, (Object)userNamespaceAuthorization.getNamespacePermissions());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", NAMESPACE_VALUE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", USER_ID_VALUE);
        ((NamespaceDaoHelper)Mockito.verify((Object)this.namespaceDaoHelper)).getNamespaceEntity(NAMESPACE_VALUE);
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationByKey(USER_NAMESPACE_AUTHORIZATION_KEY);
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).saveAndRefresh(ArgumentMatchers.any(UserNamespaceAuthorizationEntity.class));
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processUserNamespaceAuthorizationChangeNotificationEvent(USER_NAMESPACE_AUTHORIZATION_KEY);
        ((UserNamespaceAuthorizationHelper)Mockito.verify((Object)this.userNamespaceAuthorizationHelper)).getNamespacePermissions(USER_NAMESPACE_AUTHORIZATION_ENTITY);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testUpdateUserNamespaceAuthorizationHappyPath() {
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", NAMESPACE_VALUE)).thenReturn((Object)NAMESPACE_VALUE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", USER_ID_VALUE)).thenReturn((Object)USER_ID_VALUE);
        Mockito.when((Object)this.currentUserService.getCurrentUser()).thenReturn((Object)USER_AUTHORIZATIONS);
        Mockito.when((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(USER_NAMESPACE_AUTHORIZATION_KEY)).thenReturn((Object)USER_NAMESPACE_AUTHORIZATION_ENTITY);
        Mockito.when((Object)this.userNamespaceAuthorizationHelper.getNamespacePermissions(USER_NAMESPACE_AUTHORIZATION_ENTITY)).thenReturn(NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorization userNamespaceAuthorization = this.userNamespaceAuthorizationService.updateUserNamespaceAuthorization(USER_NAMESPACE_AUTHORIZATION_KEY, USER_NAMESPACE_AUTHORIZATION_UPDATE_REQUEST);
        Assert.assertEquals((long)10L, (long)userNamespaceAuthorization.getId());
        Assert.assertEquals((Object)USER_NAMESPACE_AUTHORIZATION_KEY, (Object)userNamespaceAuthorization.getUserNamespaceAuthorizationKey());
        Assert.assertEquals(NAMESPACE_PERMISSIONS, (Object)userNamespaceAuthorization.getNamespacePermissions());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", NAMESPACE_VALUE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", USER_ID_VALUE);
        ((CurrentUserService)Mockito.verify((Object)this.currentUserService)).getCurrentUser();
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationByKey(USER_NAMESPACE_AUTHORIZATION_KEY);
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).saveAndRefresh(ArgumentMatchers.any(UserNamespaceAuthorizationEntity.class));
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processUserNamespaceAuthorizationChangeNotificationEvent(USER_NAMESPACE_AUTHORIZATION_KEY);
        ((UserNamespaceAuthorizationHelper)Mockito.verify((Object)this.userNamespaceAuthorizationHelper)).getNamespacePermissions(USER_NAMESPACE_AUTHORIZATION_ENTITY);
        this.verifyNoMoreInteractionsHelper();
    }

    @Test
    public void testDeleteUserNamespaceAuthorizationHappyPath() {
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("namespace", NAMESPACE_VALUE)).thenReturn((Object)NAMESPACE_VALUE);
        Mockito.when((Object)this.alternateKeyHelper.validateStringParameter("user id", USER_ID_VALUE)).thenReturn((Object)USER_ID_VALUE);
        Mockito.when((Object)this.userNamespaceAuthorizationDao.getUserNamespaceAuthorizationByKey(USER_NAMESPACE_AUTHORIZATION_KEY)).thenReturn((Object)USER_NAMESPACE_AUTHORIZATION_ENTITY);
        Mockito.when((Object)this.userNamespaceAuthorizationHelper.getNamespacePermissions(USER_NAMESPACE_AUTHORIZATION_ENTITY)).thenReturn(NAMESPACE_PERMISSIONS);
        UserNamespaceAuthorization userNamespaceAuthorization = this.userNamespaceAuthorizationService.deleteUserNamespaceAuthorization(USER_NAMESPACE_AUTHORIZATION_KEY);
        Assert.assertEquals((long)10L, (long)userNamespaceAuthorization.getId());
        Assert.assertEquals((Object)USER_NAMESPACE_AUTHORIZATION_KEY, (Object)userNamespaceAuthorization.getUserNamespaceAuthorizationKey());
        Assert.assertEquals(NAMESPACE_PERMISSIONS, (Object)userNamespaceAuthorization.getNamespacePermissions());
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("namespace", NAMESPACE_VALUE);
        ((AlternateKeyHelper)Mockito.verify((Object)this.alternateKeyHelper)).validateStringParameter("user id", USER_ID_VALUE);
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).getUserNamespaceAuthorizationByKey(USER_NAMESPACE_AUTHORIZATION_KEY);
        ((UserNamespaceAuthorizationDao)Mockito.verify((Object)this.userNamespaceAuthorizationDao)).delete(ArgumentMatchers.any(UserNamespaceAuthorizationEntity.class));
        ((MessageNotificationEventService)Mockito.verify((Object)this.messageNotificationEventService)).processUserNamespaceAuthorizationChangeNotificationEvent(USER_NAMESPACE_AUTHORIZATION_KEY);
        ((UserNamespaceAuthorizationHelper)Mockito.verify((Object)this.userNamespaceAuthorizationHelper)).getNamespacePermissions(USER_NAMESPACE_AUTHORIZATION_ENTITY);
        this.verifyNoMoreInteractionsHelper();
    }

    private void verifyNoMoreInteractionsHelper() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.alternateKeyHelper, this.currentUserService, this.namespaceDaoHelper, this.userNamespaceAuthorizationDao, this.userNamespaceAuthorizationHelper, this.messageNotificationEventService});
    }
}

