/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.service.systemjobs;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.finra.herd.service.AbstractServiceTest;
import org.finra.herd.service.systemjobs.AbstractSystemJob;
import org.junit.Assert;
import org.junit.Test;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AbstractSystemJobTest
extends AbstractServiceTest {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractSystemJobTest.class);
    @Autowired
    private ApplicationContext applicationContext;

    @Test
    public void testGetCronExpression() throws ParseException {
        Map systemJobs = this.applicationContext.getBeansOfType(AbstractSystemJob.class);
        Assert.assertEquals((long)8L, (long)CollectionUtils.size((Object)systemJobs));
        for (Map.Entry entry : systemJobs.entrySet()) {
            String jobName = (String)entry.getKey();
            AbstractSystemJob systemJob = (AbstractSystemJob)entry.getValue();
            String cronExpressionAsText = systemJob.getCronExpression();
            LOGGER.info(String.format("Testing cron expression \"%s\" specified for \"%s\" system job...", cronExpressionAsText, jobName));
            if (CronExpression.isValidExpression((String)cronExpressionAsText)) {
                CronExpression cronExpression = new CronExpression(cronExpressionAsText);
                LOGGER.info(String.format("Next valid time for \"%s\" cron expression after now is \"%s\".", cronExpressionAsText, cronExpression.getNextValidTimeAfter(new Date())));
                continue;
            }
            Assert.fail((String)String.format("Cron expression \"%s\" specified for \"%s\" system job is not valid.", cronExpressionAsText, jobName));
        }
    }
}

