/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.herd;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.kms.AWSKMSClient;
import com.jessecoyle.CredStashBouncyCastleCrypto;
import com.jessecoyle.CredStashCrypto;
import com.jessecoyle.JCredStash;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusShim$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PruneHerdPartitions$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.herd.DefaultSource$;
import org.apache.spark.sql.herd.HerdApi;
import org.apache.spark.sql.herd.HerdFileIndex;
import org.apache.spark.sql.herd.HerdOptions;
import org.apache.spark.sql.herd.HerdOptions$;
import org.apache.spark.sql.herd.ObjectStatus$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.package$;
import org.apache.spark.sql.util.QueryExecutionListener;
import org.finra.herd.sdk.invoker.ApiException;
import org.finra.herd.sdk.model.Attribute;
import org.finra.herd.sdk.model.BusinessObjectFormat;
import org.finra.herd.sdk.model.BusinessObjectFormatKey;
import org.finra.herd.sdk.model.BusinessObjectFormatKeys;
import org.finra.herd.sdk.model.Schema;
import org.finra.herd.sdk.model.SchemaColumn;
import org.finra.herd.sdk.model.Storage;
import org.finra.herd.sdk.model.StorageFile;
import org.finra.herd.sdk.model.StorageUnit;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Unit$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u00015\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011AWM\u001d3\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001qACG\u000f!!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\bg>,(oY3t\u0013\tIbC\u0001\tSK2\fG/[8o!J|g/\u001b3feB\u0011QcG\u0005\u00039Y\u0011\u0011d\u0011:fCR\f'\r\\3SK2\fG/[8o!J|g/\u001b3feB\u0011QCH\u0005\u0003?Y\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0011\u0005J\u0007\u0002E)\u00111EB\u0001\tS:$XM\u001d8bY&\u0011QE\t\u0002\b\u0019><w-\u001b8h\u0011!9\u0003A!A!\u0002\u0013A\u0013\u0001E1qS\u000ec\u0017.\u001a8u\r\u0006\u001cGo\u001c:z!\u0019y\u0011f\u000b\u001a3k%\u0011!\u0006\u0005\u0002\n\rVt7\r^5p]N\u0002\"\u0001L\u0018\u000f\u0005=i\u0013B\u0001\u0018\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u0002\u0002cA\b4W%\u0011A\u0007\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Y:T\"\u0001\u0002\n\u0005a\u0012!a\u0002%fe\u0012\f\u0005/\u001b\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005qj\u0004C\u0001\u001c\u0001\u0011\u00159\u0013\b1\u0001)\u0011\u0015Q\u0004\u0001\"\u0001@)\u0005a\u0004\"B!\u0001\t\u0003\u0011\u0015\u0001D4fi\u0006\u0003\u0018nQ8oM&<GcA\"G\u0017B)q\u0002R\u00163e%\u0011Q\t\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u000b\u001d\u0003\u0005\u0019\u0001%\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003-\u0013.Z\u0013B\u0001&2\u0005\ri\u0015\r\u001d\u0005\u0006\u0019\u0002\u0003\r!T\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u001d>k\u0011\u0001B\u0005\u0003!\u0012\u0011Ab\u00159be.\u001cVm]:j_:DQA\u0015\u0001\u0005BM\u000b\u0011b\u001d5peRt\u0015-\\3\u0015\u0003-BQ!\u0016\u0001\u0005\nY\u000b!C]3hSN$XM]%g%\u0016\fX/\u001b:fIR\u0019qK\u0017/\u0011\u0005=A\u0016BA-\u0011\u0005\u0011)f.\u001b;\t\u000bm#\u0006\u0019A\u001b\u0002\u0007\u0005\u0004\u0018\u000eC\u0003^)\u0002\u0007a,\u0001\u0004qCJ\fWn\u001d\t\u0003m}K!\u0001\u0019\u0002\u0003\u0017!+'\u000fZ(qi&|gn\u001d\u0005\u0006E\u0002!IaY\u0001\u0012e\u0016<\u0017n\u001d;fe:+woU2iK6\fG\u0003\u00023iSF\u0004Ra\u0004#,W\u0015\u0004\"a\u00044\n\u0005\u001d\u0004\"aA%oi\")1,\u0019a\u0001k!)!.\u0019a\u0001W\u000611o\u00195f[\u0006\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u0003\u0002\u000bQL\b/Z:\n\u0005Al'AC*ueV\u001cG\u000fV=qK\")Q,\u0019a\u0001=\")1\u000f\u0001C\u0005i\u0006Ir-\u001a;G_Jl\u0017\r^+tC\u001e,\u0017I\u001c3GS2,G+\u001f9f)\u0015!WO^<z\u0011\u0015Y&\u000f1\u00016\u0011\u0015i&\u000f1\u0001_\u0011\u001dQ'\u000f%AA\u0002a\u00042aD\u001al\u0011\u001dQ(\u000f%AA\u0002m\fAC]3hSN$XM]%g\u001d>$\bK]3tK:$\bCA\b}\u0013\ti\bCA\u0004C_>dW-\u00198\t\r}\u0004A\u0011BA\u0001\u000359W\r\u001e)bi\"\u0004&/\u001a4jqR)1&a\u0001\u0002\u001e!9\u0011Q\u0001@A\u0002\u0005\u001d\u0011aB:u_J\fw-\u001a\t\u0005\u0003\u0013\tI\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0015iw\u000eZ3m\u0015\u0011\t\t\"a\u0005\u0002\u0007M$7NC\u0002\u0004\u0003+Q1!a\u0006\u000b\u0003\u00151\u0017N\u001c:b\u0013\u0011\tY\"a\u0003\u0003\u000fM#xN]1hK\"1\u0011q\u0004@A\u0002-\n\u0011c\u001d;pe\u0006<W\rU1uQB\u0013XMZ5y\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003K\tAbZ3u\r&dW\rU1uQN$B!a\n\u0002@A)\u0011\u0011FA\u001dW9!\u00111FA\u001b\u001d\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u0003o\u0001\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003w\tiDA\u0002TKFT1!a\u000e\u0011\u0011!\t\t%!\tA\u0002\u0005\r\u0013aC:u_J\fw-Z+oSR\u0004B!!\u0003\u0002F%!\u0011qIA\u0006\u0005-\u0019Fo\u001c:bO\u0016,f.\u001b;\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u0005q1M]3bi\u0016\u0014V\r\\1uS>tGCBA(\u0003+\ny\u0006E\u0002\u0016\u0003#J1!a\u0015\u0017\u00051\u0011\u0015m]3SK2\fG/[8o\u0011!\t9&!\u0013A\u0002\u0005e\u0013AC:rY\u000e{g\u000e^3yiB\u0019a*a\u0017\n\u0007\u0005uCA\u0001\u0006T#2\u001buN\u001c;fqRDaaRA%\u0001\u0004A\u0005bBA&\u0001\u0011\u0005\u00131\r\u000b\u000b\u0003\u001f\n)'a\u001a\u0002r\u0005M\u0004\u0002CA,\u0003C\u0002\r!!\u0017\t\u0011\u0005%\u0014\u0011\ra\u0001\u0003W\nA!\\8eKB\u0019a*!\u001c\n\u0007\u0005=DA\u0001\u0005TCZ,Wj\u001c3f\u0011\u00199\u0015\u0011\ra\u0001\u0011\"A\u0011QOA1\u0001\u0004\t9(\u0001\u0003eCR\f\u0007\u0003BA=\u0003\u001bsA!a\u001f\u0002\f:!\u0011QPAE\u001d\u0011\ty(a\"\u000f\t\u0005\u0005\u0015Q\u0011\b\u0005\u0003[\t\u0019)C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0004\u0003o!\u0011\u0002BAH\u0003#\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005]B\u0001C\u0004\u0002\u0016\u0002!I!a&\u00027Q|7\u000b]1sW\u0012\u000bG/Y*pkJ\u001cW-\u00118e\u001fB$\u0018n\u001c8t)!\tI*a(\u0002$\u0006-\u0006#B\b\u0002\u001c.B\u0015bAAO!\t1A+\u001e9mKJBq!!)\u0002\u0014\u0002\u00071&\u0001\u0004g_Jl\u0017\r\u001e\u0005\bU\u0006M\u0005\u0019AAS!\u0011\tI!a*\n\t\u0005%\u00161\u0002\u0002\u0007'\u000eDW-\\1\t\u000f\u00055\u00161\u0013a\u0001\u0011\u00069q\u000e\u001d;j_:\u001c\bbBAY\u0001\u0011%\u00111W\u0001\u000f[\u0006\\W\rS3sIN\u001b\u0007.Z7b)\u0019\t)+!.\u00028\"1!.a,A\u0002-Da!XAX\u0001\u0004q\u0006bBA^\u0001\u0011%\u0011QX\u0001\u0010[\u0006\\Wm\u00159be.\u001c6\r[3nCR\u00191.a0\t\u0011\u0005\u0005\u0017\u0011\u0018a\u0001\u0003\u0007\fqaY8mk6t7\u000f\u0005\u0004\u0002*\u0005e\u0012Q\u0019\t\u0005\u0003\u0013\t9-\u0003\u0003\u0002J\u0006-!\u0001D*dQ\u0016l\u0017mQ8mk6t\u0007bBAg\u0001\u0011%\u0011qZ\u0001\u000bi>DUM\u001d3UsB,G\u0003BAc\u0003#D\u0001\"a5\u0002L\u0002\u0007\u0011Q[\u0001\u0007G>dW/\u001c8\u0011\u00071\f9.C\u0002\u0002Z6\u00141b\u0015;sk\u000e$h)[3mI\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0017!\u0005;p\u0007>l\u0007\u000f\\3y\u0011\u0016\u0014H\rV=qKR\u00191&!9\t\u0011\u0005M\u00171\u001ca\u0001\u0003+Dq!!:\u0001\t\u0013\t9/A\u0006u_N\u0003\u0018M]6UsB,G\u0003BAu\u0003_\u00042\u0001\\Av\u0013\r\ti/\u001c\u0002\t\t\u0006$\u0018\rV=qK\"A\u0011\u0011_Ar\u0001\u0004\t)-A\u0002d_2Dq!!>\u0001\t\u0003\t90\u0001\nu_\u000e{W\u000e\u001d7fqN\u0003\u0018M]6UsB,G\u0003BAu\u0003sD\u0001\"!=\u0002t\u0002\u0007\u0011Q\u0019\u0005\n\u0003{\u0004\u0011\u0013!C\u0005\u0003\u007f\f1eZ3u\r>\u0014X.\u0019;Vg\u0006<W-\u00118e\r&dW\rV=qK\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0002)\u001a\u0001Pa\u0001,\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005#i!A!\u0003\u000b\t\t-!QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0004\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0011IAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\u0006\u0001#\u0003%IA!\u0007\u0002G\u001d,GOR8s[\u0006$Xk]1hK\u0006sGMR5mKRK\b/\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0004\u0016\u0004w\n\rqa\u0002B\u0010\u0005!\u0005!\u0011E\u0001\u000e\t\u00164\u0017-\u001e7u'>,(oY3\u0011\u0007Y\u0012\u0019C\u0002\u0004\u0002\u0005!\u0005!QE\n\u0004\u0005Gq\u0001b\u0002\u001e\u0003$\u0011\u0005!\u0011\u0006\u000b\u0003\u0005CA\u0001B!\f\u0003$\u0011\u0005!qF\u0001\u0018I\u00164\u0017-\u001e7u\u0003BL7\t\\5f]R4\u0015m\u0019;pef$r!\u000eB\u0019\u0005k\u0011I\u0004C\u0004\u00034\t-\u0002\u0019A\u0016\u0002\u0007U\u0014H\u000eC\u0004\u00038\t-\u0002\u0019\u0001\u001a\u0002\u0011U\u001cXM\u001d8b[\u0016DqAa\u000f\u0003,\u0001\u0007!'\u0001\u0005qCN\u001cxo\u001c:e\u0001")
public class DefaultSource
implements RelationProvider,
CreatableRelationProvider,
DataSourceRegister,
Logging {
    private final Function3<String, Option<String>, Option<String>, HerdApi> apiClientFactory;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static HerdApi defaultApiClientFactory(String string, Option<String> option, Option<String> option2) {
        return DefaultSource$.MODULE$.defaultApiClientFactory(string, option, option2);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Tuple3<String, Option<String>, Option<String>> getApiConfig(scala.collection.immutable.Map<String, String> parameters, SparkSession sparkSession) {
        Tuple3 tuple3;
        String url = (String)parameters.get((Object)"url").orElse((Function0)new Serializable(this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;

            public final Option<String> apply() {
                return this.sparkSession$1.conf().getOption("spark.herd.url");
            }
            {
                this.sparkSession$1 = sparkSession$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error("Must specify either `url` option or `spark.herd.url` in config");
            }
        });
        Option user = parameters.get((Object)"username").orElse((Function0)new Serializable(this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;

            public final Option<String> apply() {
                return this.sparkSession$1.conf().getOption("spark.herd.username");
            }
            {
                this.sparkSession$1 = sparkSession$1;
            }
        });
        Option pwd = parameters.get((Object)"password").orElse((Function0)new Serializable(this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;

            public final Option<String> apply() {
                return this.sparkSession$1.conf().getOption("spark.herd.password");
            }
            {
                this.sparkSession$1 = sparkSession$1;
            }
        });
        if (user.isDefined() && pwd.isDefined()) {
            tuple3 = new Tuple3((Object)url, (Object)user, (Object)pwd);
        } else {
            Option credName = parameters.get((Object)"credName").orElse((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final SparkSession sparkSession$1;

                public final Option<String> apply() {
                    return this.sparkSession$1.conf().getOption("spark.herd.credential.name");
                }
                {
                    this.sparkSession$1 = sparkSession$1;
                }
            });
            String credAGS = (String)parameters.get((Object)"credAGS").orElse((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final SparkSession sparkSession$1;

                public final Option<String> apply() {
                    return this.sparkSession$1.conf().getOption("spark.herd.credential.ags");
                }
                {
                    this.sparkSession$1 = sparkSession$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "DATABRICKS";
                }
            });
            String credSDLC = (String)parameters.get((Object)"credSDLC").orElse((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final SparkSession sparkSession$1;

                public final Option<String> apply() {
                    return this.sparkSession$1.conf().getOption("spark.herd.credential.sdlc");
                }
                {
                    this.sparkSession$1 = sparkSession$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "prody";
                }
            });
            String credComponent = (String)parameters.get((Object)"credComponent").orElse((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final SparkSession sparkSession$1;

                public final Option<String> apply() {
                    return this.sparkSession$1.conf().getOption("spark.herd.credential.component");
                }
                {
                    this.sparkSession$1 = sparkSession$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            HashMap<String, String> context = new HashMap<String, String>(this, credAGS, credSDLC, credComponent){
                {
                    this.put("AGS", credAGS$1);
                    this.put("SDLC", credSDLC$1);
                    Object object = credComponent$1 == null ? BoxedUnit.UNIT : this.put("Component", credComponent$1);
                }
            };
            Option proxyHost = sparkSession.conf().getOption("spark.herd.proxy.host");
            Option proxyPort = sparkSession.conf().getOption("spark.herd.proxy.port");
            ClientConfiguration clientConf = new ClientConfiguration();
            if (proxyHost.isDefined() && proxyPort.isDefined()) {
                clientConf.setProxyHost((String)proxyHost.get());
                clientConf.setProxyPort(Integer.parseInt((String)proxyPort.get()));
            }
            String prefixedCredName = null;
            prefixedCredName = context.containsKey("Component") ? new StringBuilder().append((Object)((String)context.get("AGS"))).append((Object)".").append(context.get("Component")).append((Object)".").append(context.get("SDLC")).append((Object)".").append(credName.get()).toString() : new StringBuilder().append((Object)((String)context.get("AGS"))).append((Object)".").append(context.get("SDLC")).append((Object)".").append(credName.get()).toString();
            DefaultAWSCredentialsProviderChain provider = new DefaultAWSCredentialsProviderChain();
            AmazonDynamoDBClient ddb = (AmazonDynamoDBClient)new AmazonDynamoDBClient((AWSCredentialsProvider)provider, clientConf).withRegion(Regions.US_EAST_1);
            AWSKMSClient kms = (AWSKMSClient)new AWSKMSClient((AWSCredentialsProvider)provider, clientConf).withRegion(Regions.US_EAST_1);
            String credPwd = new JCredStash("credential-store", ddb, kms, (CredStashCrypto)new CredStashBouncyCastleCrypto()).getSecret(prefixedCredName, (java.util.Map)context);
            tuple3 = new Tuple3((Object)url, (Object)credName, (Object)Option$.MODULE$.apply((Object)credPwd));
        }
        return tuple3;
    }

    public String shortName() {
        return "herd";
    }

    private void registerIfRequired(HerdApi api, HerdOptions params) {
        Try try_;
        Failure failure;
        boolean bl;
        block6: {
            block5: {
                ApiException apiException;
                block4: {
                    bl = false;
                    failure = null;
                    try_ = Try$.MODULE$.apply((Function0)new $anonfun$14(this, api, params));
                    if (!(try_ instanceof Success)) break block4;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!(try_ instanceof Failure)) break block6;
                bl = true;
                failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (!(ex instanceof ApiException) || (apiException = (ApiException)ex).getCode() != 404) break block6;
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Business object not found, registering it"})).s((Seq)Nil$.MODULE$));
                api.registerBusinessObject(params.namespace(), params.businessObjectName(), params.dataProvider());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        if (bl) {
            Throwable ex = failure.exception();
            throw ex;
        }
        throw new MatchError((Object)try_);
    }

    public Tuple3<String, String, Object> org$apache$spark$sql$herd$DefaultSource$$registerNewSchema(HerdApi api, StructType schema, HerdOptions params) {
        Schema herdSchema = this.makeHerdSchema(schema, params);
        String fileType = (String)Predef$.MODULE$.refArrayOps((Object[])params.fileTypes()).head();
        if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bz", "gz", "txt", "csv"}))).contains((Object)fileType.toLowerCase())) {
            herdSchema.setDelimiter(params.delimiter());
            herdSchema.setEscapeCharacter(params.escapeCode());
            herdSchema.setNullValue(params.nullValue());
        } else {
            herdSchema.setDelimiter("");
            herdSchema.setEscapeCharacter("");
            herdSchema.setNullValue("");
        }
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering a new schema with ", " ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.formatUsage(), fileType, params.partitionKey(), herdSchema})));
        int newVersion = api.registerBusinessObjectFormat(params.namespace(), params.businessObjectName(), params.formatUsage(), fileType, params.partitionKey(), (Option<Schema>)new Some((Object)herdSchema));
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New schema version registered: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)newVersion)})));
        return new Tuple3((Object)params.formatUsage(), (Object)fileType, (Object)BoxesRunTime.boxToInteger((int)newVersion));
    }

    private Tuple3<String, String, Object> getFormatUsageAndFileType(HerdApi api, HerdOptions params, Option<StructType> schema, boolean registerIfNotPresent) {
        BusinessObjectFormatKeys formats = api.getBusinessObjectFormats(params.namespace(), params.businessObjectName(), api.getBusinessObjectFormats$default$3());
        scala.collection.immutable.Map preferredTypes = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])params.fileTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Tuple3 result = (Tuple3)((TraversableLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(formats.getBusinessObjectFormatKeys()).asScala()).filter((Function1)new Serializable(this, params, preferredTypes){
            public static final long serialVersionUID = 0L;
            private final HerdOptions params$2;
            private final scala.collection.immutable.Map preferredTypes$1;

            public final boolean apply(BusinessObjectFormatKey i) {
                return i.getBusinessObjectFormatUsage().equalsIgnoreCase(this.params$2.formatUsage()) && this.preferredTypes$1.contains((Object)i.getBusinessObjectFormatFileType().toLowerCase());
            }
            {
                this.params$2 = params$2;
                this.preferredTypes$1 = preferredTypes$1;
            }
        })).sortBy((Function1)new Serializable(this, preferredTypes){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map preferredTypes$1;

            public final int apply(BusinessObjectFormatKey f) {
                return BoxesRunTime.unboxToInt((Object)this.preferredTypes$1.apply((Object)f.getBusinessObjectFormatFileType().toLowerCase()));
            }
            {
                this.preferredTypes$1 = preferredTypes$1;
            }
        }, (Ordering)Ordering.Int$.MODULE$)).headOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, String, Object> apply(BusinessObjectFormatKey i) {
                return new Tuple3((Object)i.getBusinessObjectFormatUsage(), (Object)i.getBusinessObjectFormatFileType(), (Object)BoxesRunTime.boxToInteger((int)i.getBusinessObjectFormatVersion()));
            }
        }).getOrElse((Function0)new Serializable(this, api, params, schema, registerIfNotPresent){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;
            private final HerdApi api$2;
            private final HerdOptions params$2;
            private final Option schema$2;
            private final boolean registerIfNotPresent$1;

            public final Tuple3<String, String, Object> apply() {
                if (this.registerIfNotPresent$1 && this.schema$2.nonEmpty()) {
                    return this.$outer.org$apache$spark$sql$herd$DefaultSource$$registerNewSchema(this.api$2, (StructType)this.schema$2.get(), this.params$2);
                }
                throw scala.sys.package$.MODULE$.error("no suitable format usage and file type found");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.api$2 = api$2;
                this.params$2 = params$2;
                this.schema$2 = schema$2;
                this.registerIfNotPresent$1 = registerIfNotPresent$1;
            }
        });
        return result;
    }

    private Option<StructType> getFormatUsageAndFileType$default$3() {
        return None$.MODULE$;
    }

    private boolean getFormatUsageAndFileType$default$4() {
        return false;
    }

    private String getPathPrefix(Storage storage, String storagePathPrefix) {
        block4: {
            String string;
            block3: {
                String string2;
                block2: {
                    string2 = storage.getStoragePlatformName();
                    if (!"S3".equals(string2)) break block2;
                    String bucketName = (String)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(storage.getAttributes()).asScala()).find((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Attribute x$2) {
                            return x$2.getName().equalsIgnoreCase("bucket.name");
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Attribute x$3) {
                            return x$3.getValue();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Nothing$ apply() {
                            return scala.sys.package$.MODULE$.error("Storage must have a 'bucket.name' attribute");
                        }
                    });
                    string = new StringBuilder().append((Object)storagePathPrefix).append((Object)(storagePathPrefix.endsWith("/") ? "" : "/")).append((Object)bucketName).toString();
                    break block3;
                }
                if (!"FILE".equals(string2)) break block4;
                string = storagePathPrefix;
            }
            return string;
        }
        throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported storage platform ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{storage.getStoragePlatformName()})));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> org$apache$spark$sql$herd$DefaultSource$$getFilePaths(StorageUnit storageUnit) {
        void var2_2;
        Seq paths = (Seq)Option$.MODULE$.apply((Object)storageUnit.getStorageFiles()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<String> apply(List<StorageFile> i) {
                return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(i).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StorageFile x$4) {
                        return x$4.getFilePath();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
            }
        }).orElse((Function0)new Serializable(this, storageUnit){
            public static final long serialVersionUID = 0L;
            private final StorageUnit storageUnit$1;

            public final Some<Seq<String>> apply() {
                return new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.storageUnit$1.getStorageDirectory().getDirectoryPath()})));
            }
            {
                this.storageUnit$1 = storageUnit$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error("No storage paths could be found!");
            }
        });
        return var2_2;
    }

    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters) {
        Tuple3<String, Option<String>, Option<String>> tuple3;
        block4: {
            Tuple3<String, String, Object> tuple32;
            block5: {
                Tuple2<String, scala.collection.immutable.Map<String, String>> tuple2;
                block6: {
                    Try try_;
                    block9: {
                        Class clazz;
                        HerdFileIndex fileIndex;
                        StructType herdSchema;
                        Option partitionSchema;
                        scala.collection.immutable.Map options;
                        SparkSession sparkSession;
                        block8: {
                            String correctedDataSourceFormat;
                            block7: {
                                Tuple2 tuple22;
                                Tuple3 tuple33;
                                Option password;
                                Option username;
                                Option password2;
                                Option username2;
                                sparkSession = sqlContext.sparkSession();
                                Seq currentRules = sparkSession.sessionState().experimentalMethods().extraOptimizations();
                                if (currentRules.find((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Rule<LogicalPlan> x$5) {
                                        return x$5 instanceof PrunedFilteredScan;
                                    }
                                }).isEmpty()) {
                                    sparkSession.sessionState().experimentalMethods().extraOptimizations_$eq((Seq)currentRules.$colon$plus((Object)PruneHerdPartitions$.MODULE$, Seq$.MODULE$.canBuildFrom()));
                                }
                                HerdOptions params = HerdOptions$.MODULE$.apply(parameters, sparkSession);
                                tuple3 = this.getApiConfig(parameters, sparkSession);
                                if (tuple3 == null) break block4;
                                String url = (String)tuple3._1();
                                Tuple3 tuple34 = new Tuple3((Object)url, (Object)(username2 = (Option)tuple3._2()), (Object)(password2 = (Option)tuple3._3()));
                                Tuple3 tuple35 = tuple34;
                                String url2 = (String)tuple35._1();
                                HerdApi api = (HerdApi)this.apiClientFactory.apply((Object)url2, (Object)(username = (Option)tuple35._2()), (Object)(password = (Option)tuple35._3()));
                                tuple32 = this.getFormatUsageAndFileType(api, params, this.getFormatUsageAndFileType$default$3(), this.getFormatUsageAndFileType$default$4());
                                if (tuple32 == null) break block5;
                                String formatUsage = (String)tuple32._1();
                                String formatFileType = (String)tuple32._2();
                                int formatVersion = BoxesRunTime.unboxToInt((Object)tuple32._3());
                                Tuple3 tuple36 = tuple33 = new Tuple3((Object)formatUsage, (Object)formatFileType, (Object)BoxesRunTime.boxToInteger((int)formatVersion));
                                String formatUsage2 = (String)tuple36._1();
                                String formatFileType2 = (String)tuple36._2();
                                int formatVersion2 = BoxesRunTime.unboxToInt((Object)tuple36._3());
                                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Querying ", " ", " ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, BoxesRunTime.boxToInteger((int)formatVersion2)})));
                                BusinessObjectFormat fmt = api.getBusinessObjectFormat(params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, formatVersion2);
                                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using PartitionKey ", ", PartitionKeyGroup ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt.getPartitionKey(), fmt.getSchema().getPartitionKeyGroup()})));
                                Seq<Tuple4<Object, String, Seq<String>, Object>> allData = api.getBusinessObjectPartitions(params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, formatVersion2, params.partitionFilter());
                                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " results"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)allData.size())})));
                                tuple2 = this.toSparkDataSourceAndOptions(formatFileType2, fmt.getSchema(), parameters);
                                if (tuple2 == null) break block6;
                                String dataSourceFormat = (String)tuple2._1();
                                scala.collection.immutable.Map options2 = (scala.collection.immutable.Map)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataSourceFormat, (Object)options2);
                                String dataSourceFormat2 = (String)tuple23._1();
                                options = (scala.collection.immutable.Map)tuple23._2();
                                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using Spark DataSource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSourceFormat2})));
                                partitionSchema = Option$.MODULE$.apply((Object)fmt.getSchema().getPartitions()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ DefaultSource $outer;

                                    public final StructType apply(List<SchemaColumn> p) {
                                        return this.$outer.org$apache$spark$sql$herd$DefaultSource$$makeSparkSchema((Seq<SchemaColumn>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(p).asScala()).toSeq());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Object partition schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionSchema})));
                                herdSchema = this.org$apache$spark$sql$herd$DefaultSource$$makeSparkSchema((Seq<SchemaColumn>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(fmt.getSchema().getColumns()).asScala()));
                                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Object schema ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{herdSchema})));
                                Function3<String, Option<String>, Option<String>, HerdApi> localApiClientFactory = this.apiClientFactory;
                                fileIndex = new HerdFileIndex(sparkSession, (Function0<HerdApi>)new Serializable(this, url2, username, password, localApiClientFactory){
                                    public static final long serialVersionUID = 0L;
                                    private final String url$1;
                                    private final Option username$1;
                                    private final Option password$1;
                                    private final Function3 localApiClientFactory$1;

                                    public final HerdApi apply() {
                                        return (HerdApi)this.localApiClientFactory$1.apply((Object)this.url$1, (Object)this.username$1, (Object)this.password$1);
                                    }
                                    {
                                        this.url$1 = url$1;
                                        this.username$1 = username$1;
                                        this.password$1 = password$1;
                                        this.localApiClientFactory$1 = localApiClientFactory$1;
                                    }
                                }, allData, params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, fmt.getPartitionKey(), (StructType)partitionSchema.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final StructType apply() {
                                        return new StructType();
                                    }
                                }));
                                boolean useHerdOrcFormat = new StringOps(Predef$.MODULE$.augmentString(sparkSession.version())).$less((Object)"2.3.0");
                                String string = dataSourceFormat2;
                                String string2 = "orc".equals(string) && useHerdOrcFormat ? "org.apache.spark.sql.hive.orc.HerdOrcFileFormat" : dataSourceFormat2;
                                correctedDataSourceFormat = string2;
                                try_ = Try$.MODULE$.apply((Function0)new $anonfun$29(this));
                                if (!(try_ instanceof Success)) break block7;
                                Success success = (Success)try_;
                                Method method = (Method)success.value();
                                clazz = (Class)method.invoke(null, correctedDataSourceFormat);
                                break block8;
                            }
                            if (!(try_ instanceof Failure)) break block9;
                            clazz = (Class)DataSource.class.getMethod("lookupDataSource", String.class, SQLConf.class).invoke(null, correctedDataSourceFormat, sparkSession.sessionState().conf());
                        }
                        Class dataSourceClazz = clazz;
                        FileFormat fileFormat = (FileFormat)dataSourceClazz.newInstance();
                        HadoopFsRelation baseRelation = new HadoopFsRelation((FileIndex)fileIndex, (StructType)partitionSchema.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StructType apply() {
                                return new StructType();
                            }
                        }), herdSchema, (Option)None$.MODULE$, fileFormat, options, sparkSession);
                        return baseRelation;
                    }
                    throw new MatchError((Object)try_);
                }
                throw new MatchError(tuple2);
            }
            throw new MatchError(tuple32);
        }
        throw new MatchError(tuple3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> data) {
        Tuple2 tuple25;
        Tuple2 tuple22;
        Tuple3 tuple35;
        Tuple3 tuple32;
        SparkSession sparkSession = sqlContext.sparkSession();
        HerdOptions params = HerdOptions$.MODULE$.apply(parameters, sparkSession);
        Tuple3<String, Option<String>, Option<String>> tuple3 = this.getApiConfig(parameters, sparkSession);
        if (tuple3 == null) throw new MatchError(tuple3);
        String url = (String)tuple3._1();
        Option username = (Option)tuple3._2();
        Option password = (Option)tuple3._3();
        Tuple3 tuple33 = tuple32 = new Tuple3((Object)url, (Object)username, (Object)password);
        String url2 = (String)tuple33._1();
        Option username2 = (Option)tuple33._2();
        Option password2 = (Option)tuple33._3();
        HerdApi api = (HerdApi)this.apiClientFactory.apply((Object)url2, (Object)username2, (Object)password2);
        this.registerIfRequired(api, params);
        Tuple3<String, String, Object> tuple34 = this.getFormatUsageAndFileType(api, params, (Option<StructType>)new Some((Object)data.schema()), params.registerNewFormat());
        if (tuple34 == null) throw new MatchError(tuple34);
        String formatUsage = (String)tuple34._1();
        String formatFileType = (String)tuple34._2();
        int formatVersion = BoxesRunTime.unboxToInt((Object)tuple34._3());
        Tuple3 tuple36 = tuple35 = new Tuple3((Object)formatUsage, (Object)formatFileType, (Object)BoxesRunTime.boxToInteger((int)formatVersion));
        String formatUsage2 = (String)tuple36._1();
        String formatFileType2 = (String)tuple36._2();
        int formatVersion2 = BoxesRunTime.unboxToInt((Object)tuple36._3());
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing to ", " ", " ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, BoxesRunTime.boxToInteger((int)formatVersion2)})));
        BusinessObjectFormat fmt = api.getBusinessObjectFormat(params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, formatVersion2);
        Buffer partitionColumns = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fmt.getSchema().getPartitions()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SchemaColumn x$11) {
                return x$11.getName();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        this.log().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using PartitionKey ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt.getPartitionKey()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PartitionKeyGroup ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fmt.getSchema().getPartitionKeyGroup()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionColumns.mkString(",")}))).toString());
        StructType targetSchema = this.org$apache$spark$sql$herd$DefaultSource$$makeSparkSchema((Seq<SchemaColumn>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(fmt.getSchema().getColumns()).asScala()));
        Dataset rows = data.drop((Seq)partitionColumns).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])targetSchema.fieldNames()));
        Predef$.MODULE$.require(rows.schema().sql().equalsIgnoreCase(targetSchema.sql()), (Function0)new Serializable(this, targetSchema){
            public static final long serialVersionUID = 0L;
            private final StructType targetSchema$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataFrame schema and business object format schema don't match, expected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetSchema$1.sql()}));
            }
            {
                this.targetSchema$1 = targetSchema$1;
            }
        });
        Tuple2<String, scala.collection.immutable.Map<String, String>> tuple2 = this.toSparkDataSourceAndOptions(formatFileType2, fmt.getSchema(), parameters);
        if (tuple2 == null) throw new MatchError(tuple2);
        String dataSourceFormat = (String)tuple2._1();
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataSourceFormat, (Object)options);
        String dataSourceFormat2 = (String)tuple23._1();
        scala.collection.immutable.Map options2 = (scala.collection.immutable.Map)tuple23._2();
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " with options[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSourceFormat2, options2.mkString(",")})));
        String partitionValue = (String)params.partitionValue().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "none";
            }
        });
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preregistering partition ", " in order to get path prefix and data version"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionValue})));
        Tuple2<Object, Seq<StorageUnit>> tuple24 = api.registerBusinessObjectData(params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, formatVersion2, fmt.getPartitionKey(), partitionValue, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])params.subPartitions()), ObjectStatus$.MODULE$.UPLOADING(), params.storageName(), api.registerBusinessObjectData$default$11());
        if (tuple24 == null) throw new MatchError(tuple24);
        int dataVersion = tuple24._1$mcI$sp();
        Seq storageUnits = (Seq)tuple24._2();
        Tuple2 tuple26 = tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)dataVersion), (Object)storageUnits);
        int dataVersion2 = tuple26._1$mcI$sp();
        Seq storageUnits2 = (Seq)tuple26._2();
        String path = (String)((IterableLike)storageUnits2.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final Seq<String> apply(StorageUnit storageUnit) {
                return this.$outer.org$apache$spark$sql$herd$DefaultSource$$getFilePaths(storageUnit);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).head();
        Storage storage = ((StorageUnit)storageUnits2.head()).getStorage();
        String pathPrefix = this.getPathPrefix(storage, params.storagePathPrefix());
        String baseDir = (String)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(storage.getAttributes()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute x$14) {
                return x$14.getName().equalsIgnoreCase("spark.base.path");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$15) {
                return new StringBuilder().append((Object)x$15.getValue()).append((Object)"/").toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String basePath = new StringBuilder().append((Object)pathPrefix).append((Object)"/").append((Object)baseDir).append((Object)"/").append((Object)path).toString();
        LongRef numberOutputRows = LongRef.create((long)0L);
        QueryExecutionListener queryExecutionListener = new QueryExecutionListener(this, numberOutputRows){
            private final LongRef numberOutputRows$1;

            @DeveloperApi
            public void onSuccess(String funcName, QueryExecution qe, long durationNs) {
                this.numberOutputRows$1.elem = ((SQLMetric)qe.executedPlan().metrics().apply((Object)"numOutputRows")).value();
            }

            @DeveloperApi
            public void onFailure(String funcName, QueryExecution qe, Exception exception) {
            }
            {
                this.numberOutputRows$1 = numberOutputRows$1;
            }
        };
        try {
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
            String partitionKey = fmt.getPartitionKey();
            sparkSession.sessionState().listenerManager().register(queryExecutionListener);
            rows.write().format(dataSourceFormat2).options((Map)options2).save(basePath);
            URI basePathURI = new URI(new URI(pathPrefix).getPath());
            InMemoryFileIndex index = new InMemoryFileIndex(sparkSession, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(basePath)})), Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
            Seq storageFiles = (Seq)index.allFiles().map((Function1)new Serializable(this, basePathURI){
                public static final long serialVersionUID = 0L;
                private final URI basePathURI$1;

                public final Tuple2<String, Object> apply(Object status) {
                    Path path = FileStatusShim$.MODULE$.getPath(status);
                    long size = FileStatusShim$.MODULE$.getLen(status);
                    return new Tuple2((Object)this.basePathURI$1.relativize(new URI(path.toUri().getPath())).getPath(), (Object)BoxesRunTime.boxToLong((long)size));
                }
                {
                    this.basePathURI$1 = basePathURI$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.log().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionValue}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" with files ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)storageFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x$16) {
                    return (String)x$16._1();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(",")}))).toString());
            api.setStorageFiles(params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, formatVersion2, partitionKey, partitionValue, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])params.subPartitions()), dataVersion2, params.storageName(), (Seq<Tuple2<String, Object>>)storageFiles);
            api.updateBusinessObjectData(params.namespace(), params.businessObjectName(), formatUsage2, formatFileType2, formatVersion2, fmt.getPartitionKey(), partitionValue, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])params.subPartitions()), dataVersion2, ObjectStatus$.MODULE$.VALID());
            this.log().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OUTPUT\\t", "\\t", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.businessObjectName(), params.namespace()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formatUsage2, formatFileType2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)formatVersion2), BoxesRunTime.boxToInteger((int)dataVersion2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionValue, Predef$.MODULE$.refArrayOps((Object[])params.subPartitions()).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.storageName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numberOutputRows.elem)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)storageFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x$17) {
                    return (String)x$17._1();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(",")}))).append((Object)"AVAILABLE").toString());
        }
        catch (Throwable throwable) {
            try {
                Unit$ unit$;
                void var43_43;
                void var26_26;
                void var25_25;
                void var24_24;
                void var23_23;
                void var16_16;
                void var6_6;
                void var37_37;
                this.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job failed, setting partition ", " to INVALID"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var37_37})));
                Try try_ = Try$.MODULE$.apply((Function0)new $anonfun$1(this, (HerdOptions)var6_6, (HerdApi)var16_16, (String)var23_23, (String)var24_24, (int)var25_25, (BusinessObjectFormat)var26_26, (String)var37_37, (int)var43_43));
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    this.log().error("Error while setting object data to INVALID after job failure", ex);
                    unit$ = BoxedUnit.UNIT;
                    throw throwable;
                } else {
                    unit$ = Unit$.MODULE$;
                }
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var51_51;
                void var5_5;
                var5_5.sessionState().listenerManager().unregister((QueryExecutionListener)var51_51);
                throw throwable2;
            }
        }
        sparkSession.sessionState().listenerManager().unregister(queryExecutionListener);
        return new BaseRelation(this, data, sparkSession){
            private final Dataset data$1;
            private final SparkSession sparkSession$2;

            public SQLContext sqlContext() {
                return this.sparkSession$2.sqlContext();
            }

            public StructType schema() {
                return this.data$1.schema();
            }
            {
                this.data$1 = data$1;
                this.sparkSession$2 = sparkSession$2;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<String, scala.collection.immutable.Map<String, String>> toSparkDataSourceAndOptions(String format, Schema schema, scala.collection.immutable.Map<String, String> options) {
        String string = format.toLowerCase();
        scala.collection.immutable.Map map = "bz".equals(string) ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression"), (Object)"bzip2")})) : ("gz".equals(string) ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression"), (Object)"gzip")})) : Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Map compression = map;
        String string2 = format.toLowerCase();
        boolean bl = "bz".equals(string2) ? true : ("gz".equals(string2) ? true : ("txt".equals(string2) ? true : "csv".equals(string2)));
        if (bl) {
            String string3;
            String string4;
            String string5;
            String string6;
            Map$ map$ = Predef$.MODULE$.Map();
            Tuple2[] tuple2Array = new Tuple2[7];
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferSchema"), (Object)"false");
            tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)"false");
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"delimiter");
            if (schema.getDelimiter() == null) {
                string6 = null;
            } else {
                String string7;
                boolean bl2 = schema.getDelimiter().contains("\\");
                if (bl2) {
                    string7 = ((Object)BoxesRunTime.boxToCharacter((char)((char)new StringOps(Predef$.MODULE$.augmentString(schema.getDelimiter().replace("\\", ""))).toInt()))).toString();
                } else {
                    if (false != bl2) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
                    string7 = schema.getDelimiter();
                }
                string6 = string7;
            }
            tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, string6);
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"collectionItemsDelimiter");
            if (schema.getCollectionItemsDelimiter() == null) {
                string5 = null;
            } else {
                String string8;
                boolean bl3 = schema.getCollectionItemsDelimiter().contains("\\");
                if (bl3) {
                    string8 = ((Object)BoxesRunTime.boxToCharacter((char)((char)new StringOps(Predef$.MODULE$.augmentString(schema.getCollectionItemsDelimiter().replace("\\", ""))).toInt()))).toString();
                } else {
                    if (false != bl3) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl3));
                    string8 = schema.getCollectionItemsDelimiter();
                }
                string5 = string8;
            }
            tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, string5);
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"mapKeysDelimiter");
            if (schema.getMapKeysDelimiter() == null) {
                string4 = null;
            } else {
                String string9;
                boolean bl4 = schema.getMapKeysDelimiter().contains("\\");
                if (bl4) {
                    string9 = ((Object)BoxesRunTime.boxToCharacter((char)((char)new StringOps(Predef$.MODULE$.augmentString(schema.getMapKeysDelimiter().replace("\\", ""))).toInt()))).toString();
                } else {
                    if (false != bl4) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl4));
                    string9 = schema.getMapKeysDelimiter();
                }
                string4 = string9;
            }
            tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object3, string4);
            tuple2Array[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)schema.getNullValue());
            Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"escape");
            boolean bl5 = Try$.MODULE$.apply((Function0)new $anonfun$2(this, schema)).isSuccess();
            if (bl5) {
                string3 = ((Object)BoxesRunTime.boxToCharacter((char)((char)new StringOps(Predef$.MODULE$.augmentString(schema.getEscapeCharacter().replace("\\", ""))).toInt()))).toString();
            } else {
                if (false != bl5) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl5));
                string3 = schema.getEscapeCharacter().replace("\\", "");
            }
            tuple2Array[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object4, (Object)string3);
            return new Tuple2((Object)"csv", (Object)((MapLike)map$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).$plus$plus((GenTraversableOnce)compression).$plus$plus(options));
        }
        if (!"parquet".equals(string2)) return new Tuple2((Object)format.toLowerCase(), options);
        return new Tuple2((Object)"parquet", (Object)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mergeSchema"), (Object)"true")}))).$plus$plus(options));
    }

    private Schema makeHerdSchema(StructType schema, HerdOptions params) {
        Set partitionKeys = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{params.partitionKey()}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])params.subPartitionKeys())).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$18) {
                return x$18.equalsIgnoreCase("partition");
            }
        });
        Seq columns = (Seq)((TraversableLike)schema.filterNot((Function1)new Serializable(this, partitionKeys){
            public static final long serialVersionUID = 0L;
            private final Set partitionKeys$1;

            public final boolean apply(StructField f) {
                return this.partitionKeys$1.contains((Object)f.name());
            }
            {
                this.partitionKeys$1 = partitionKeys$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final SchemaColumn apply(StructField column) {
                return this.$outer.org$apache$spark$sql$herd$DefaultSource$$toHerdType(column);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Set partitionColumns = (Set)((SetLike)partitionKeys.map((Function1)new Serializable(this, schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final StructField apply(String x$19) {
                return this.schema$1.apply(x$19);
            }
            {
                this.schema$1 = schema$1;
            }
        }, Set$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final SchemaColumn apply(StructField column) {
                return this.$outer.org$apache$spark$sql$herd$DefaultSource$$toHerdType(column);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        Schema herdSchema = new Schema();
        herdSchema.setColumns((List)JavaConverters$.MODULE$.seqAsJavaListConverter(columns).asJava());
        herdSchema.setPartitions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitionColumns.toSeq()).asJava());
        params.partitionKeyGroup().foreach((Function1)new Serializable(this, herdSchema){
            public static final long serialVersionUID = 0L;
            private final Schema herdSchema$1;

            public final void apply(String x$1) {
                this.herdSchema$1.setPartitionKeyGroup(x$1);
            }
            {
                this.herdSchema$1 = herdSchema$1;
            }
        });
        return herdSchema;
    }

    public StructType org$apache$spark$sql$herd$DefaultSource$$makeSparkSchema(Seq<SchemaColumn> columns) {
        StructField[] fields = (StructField[])((TraversableOnce)columns.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final StructField apply(SchemaColumn x0$1) {
                SchemaColumn schemaColumn = x0$1;
                if (schemaColumn != null) {
                    SchemaColumn schemaColumn2 = schemaColumn;
                    boolean nullable = schemaColumn2.getRequired() == null ? true : !Predef$.MODULE$.Boolean2boolean(schemaColumn2.getRequired());
                    StructField structField = new StructField(schemaColumn2.getName(), this.$outer.org$apache$spark$sql$herd$DefaultSource$$toSparkType(schemaColumn2), nullable, StructField$.MODULE$.apply$default$4());
                    return structField;
                }
                throw new MatchError((Object)schemaColumn);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(fields);
    }

    /*
     * WARNING - void declaration
     */
    public SchemaColumn org$apache$spark$sql$herd$DefaultSource$$toHerdType(StructField column) {
        void var2_2;
        SchemaColumn col = new SchemaColumn();
        col.setName(column.name());
        col.setRequired(Predef$.MODULE$.boolean2Boolean(!column.nullable()));
        DataType dataType = column.dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            col.setType("STRING");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            col.setType("TINYINT");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            col.setType("SMALLINT");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            col.setType("INT");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LongType$.MODULE$.equals(dataType)) {
            col.setType("BIGINT");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            col.setType("FLOAT");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            col.setType("DOUBLE");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateType$.MODULE$.equals(dataType)) {
            col.setType("DATE");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            col.setType("DECIMAL");
            col.setSize(new StringBuilder().append(decimalType.precision()).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)decimalType.scale())).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            col.setType("TIMESTAMP");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            col.setType("BOOLEAN");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            col.setType(this.toComplexHerdType(column));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public String toComplexHerdType(StructField column) {
        String typeString = column.metadata().contains(package$.MODULE$.HIVE_TYPE_STRING()) ? column.metadata().getString(package$.MODULE$.HIVE_TYPE_STRING()) : column.dataType().catalogString();
        return typeString;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType org$apache$spark$sql$herd$DefaultSource$$toSparkType(SchemaColumn col) {
        void var4_16;
        String string = col.getType().toUpperCase();
        boolean bl = "STRING".equals(string) ? true : ("VARCHAR".equals(string) ? true : "CHAR".equals(string));
        if (bl) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var4_16;
        } else if ("TINYINT".equals(string)) {
            ByteType$ byteType$ = ByteType$.MODULE$;
            return var4_16;
        } else if ("SMALLINT".equals(string)) {
            ShortType$ shortType$ = ShortType$.MODULE$;
            return var4_16;
        } else if ("INT".equals(string)) {
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            return var4_16;
        } else if ("BIGINT".equals(string)) {
            LongType$ longType$ = LongType$.MODULE$;
            return var4_16;
        } else if ("FLOAT".equals(string)) {
            FloatType$ floatType$ = FloatType$.MODULE$;
            return var4_16;
        } else if ("DOUBLE".equals(string)) {
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            return var4_16;
        } else if ("DATE".equals(string)) {
            DateType$ dateType$ = DateType$.MODULE$;
            return var4_16;
        } else if ("DECIMAL".equals(string)) {
            Tuple2.mcII.sp sp2;
            String size = col.getSize();
            int[] nArray = (int[])Predef$.MODULE$.refArrayOps((Object[])(size.indexOf(",") == -1 ? new StringBuilder().append((Object)size).append((Object)",0").toString() : size).split(",")).map((Function1)new $anonfun$44(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Option option = Array$.MODULE$.unapplySeq((Object)nArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)nArray);
            int precision = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(0));
            int scale = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(1));
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(precision, scale);
            int precision2 = sp3._1$mcI$sp();
            int scale2 = sp3._2$mcI$sp();
            DecimalType decimalType = new DecimalType(precision2, scale2);
            return var4_16;
        } else if ("TIMESTAMP".equals(string)) {
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            return var4_16;
        } else if ("BOOLEAN".equals(string)) {
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            return var4_16;
        } else {
            DataType dataType = this.toComplexSparkType(col);
        }
        return var4_16;
    }

    public DataType toComplexSparkType(SchemaColumn col) {
        try {
            return CatalystSqlParser$.MODULE$.parseDataType(col.getType());
        }
        catch (ParseException parseException) {
            throw new SparkException(new StringBuilder().append((Object)"Cannot recognize hive type string: ").append((Object)col.getType()).toString(), (Throwable)parseException);
        }
    }

    public DefaultSource(Function3<String, Option<String>, Option<String>, HerdApi> apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
        Logging.class.$init$((Logging)this);
    }

    public DefaultSource() {
        this((Function3<String, Option<String>, Option<String>, HerdApi>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HerdApi apply(String url, Option<String> username, Option<String> password) {
                return DefaultSource$.MODULE$.defaultApiClientFactory(url, username, password);
            }
        });
    }
}

