/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.herd;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.herd.HerdApi;
import org.apache.spark.sql.herd.HerdFileIndexBase$;
import org.finra.herd.sdk.model.BusinessObjectDataDdl;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class HerdFileIndexBase$
implements Logging {
    public static final HerdFileIndexBase$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HerdFileIndexBase$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Map<String, Option<String>> parsePartitionPath(String path) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])path.split("/")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$5) {
                return x$5.split("=");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Option<String>> apply(String[] i) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.refArrayOps((Object[])i).head()), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])i).drop(1)).headOption());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<String, Seq<String>>> listS3KeyPrefixes(HerdApi api, Seq<String> paths) {
        Try try_;
        block6: {
            Seq seq;
            block5: {
                List partitionValues;
                block4: {
                    String partitionKey;
                    if (paths.isEmpty()) {
                        return (Seq)Seq$.MODULE$.empty();
                    }
                    Map<String, Option<String>> parts = this.parsePartitionPath((String)paths.apply(0));
                    try_ = Try$.MODULE$.apply((Function0)new anonfun.12(api, parts, partitionKey = (String)((Option)parts.apply((Object)"partitionKey")).get(), partitionValues = ((TraversableOnce)paths.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String path) {
                            return (String)((Option)HerdFileIndexBase$.MODULE$.parsePartitionPath(path).apply((Object)"partitionValue")).get();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toList()));
                    if (!(try_ instanceof Success)) break block4;
                    Success success = (Success)try_;
                    BusinessObjectDataDdl objectDataDdl = (BusinessObjectDataDdl)success.value();
                    seq = this.getS3KeyPrefixes(objectDataDdl.getDdl(), paths);
                    break block5;
                }
                if (!(try_ instanceof Failure)) break block6;
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                this.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not fetch object data DDL request for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionValues})), error);
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)try_);
    }

    private Seq<Tuple2<String, Seq<String>>> getS3KeyPrefixes(String businessDataDdl, Seq<String> paths) {
        String partitionKey = (String)((Option)this.parsePartitionPath((String)paths.apply(0)).apply((Object)"partitionKey")).get();
        List partitionValueTuples = ((TraversableOnce)paths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, String, ArrayBuffer<String>> apply(String path) {
                Map<String, Option<String>> parts = HerdFileIndexBase$.MODULE$.parsePartitionPath(path);
                String primaryPartition = (String)((Option)parts.apply((Object)"partitionValue")).get();
                String subPartitions = (String)((Option)parts.apply((Object)"subPartitionValues")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                return subPartitions.isEmpty() ? new Tuple3((Object)path, (Object)primaryPartition, (Object)new ArrayBuffer()) : new Tuple3((Object)path, (Object)new StringBuilder().append((Object)primaryPartition).append((Object)",").append((Object)subPartitions).toString(), (Object)new ArrayBuffer());
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        ObjectRef s3KeyPrefixes = ObjectRef.create((Object)new ArrayBuffer());
        if (partitionKey.equalsIgnoreCase("partition")) {
            Regex s3KeyPrefixPattern = new Regex("LOCATION '(s3.+?)';", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            s3KeyPrefixPattern.findAllIn((CharSequence)businessDataDdl).matchData().foreach((Function1)new Serializable(s3KeyPrefixes){
                public static final long serialVersionUID = 0L;
                private final ObjectRef s3KeyPrefixes$1;

                public final ArrayBuffer<String> apply(Regex.Match m) {
                    return ((ArrayBuffer)this.s3KeyPrefixes$1.elem).$plus$eq((Object)m.group(1).replaceAll("s3n://", "s3a://"));
                }
                {
                    this.s3KeyPrefixes$1 = s3KeyPrefixes$1;
                }
            });
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(paths.apply(0), (Object)((ArrayBuffer)s3KeyPrefixes.elem))}));
        }
        Regex s3KeyPrefixPattern = new Regex("PARTITION \\((.+?)\\) LOCATION '(s3.+?)';", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        s3KeyPrefixPattern.findAllIn((CharSequence)businessDataDdl).matchData().foreach((Function1)new Serializable(partitionValueTuples){
            public static final long serialVersionUID = 0L;
            private final List partitionValueTuples$1;

            public final void apply(Regex.Match m) {
                List partitionValues = Predef$.MODULE$.refArrayOps((Object[])m.group(1).replace("`", "").replace("'", "").replaceAll("\\s", "").split(",")).toList();
                ObjectRef partitionList = ObjectRef.create((Object)new ArrayBuffer());
                partitionValues.foreach((Function1)new Serializable(this, partitionList){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef partitionList$1;

                    public final ArrayBuffer<String> apply(String e) {
                        return ((ArrayBuffer)this.partitionList$1.elem).$plus$eq((Object)e.substring(e.indexOf("=") + 1));
                    }
                    {
                        this.partitionList$1 = partitionList$1;
                    }
                });
                String ddlPartitionValue = ((ArrayBuffer)partitionList.elem).mkString(",");
                boolean done = false;
                for (int index = 0; index < this.partitionValueTuples$1.length() && !done; ++index) {
                    Tuple3 partitionValueTuple = (Tuple3)this.partitionValueTuples$1.apply(index);
                    if (!ddlPartitionValue.startsWith((String)partitionValueTuple._2())) continue;
                    ((ArrayBuffer)partitionValueTuple._3()).$plus$eq((Object)m.group(2).replaceAll("s3n://", "s3a://"));
                    done = true;
                }
            }
            {
                this.partitionValueTuples$1 = partitionValueTuples$1;
            }
        });
        return (Seq)partitionValueTuples.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ArrayBuffer<String>> apply(Tuple3<String, String, ArrayBuffer<String>> p) {
                return new Tuple2(p._1(), p._3());
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public Seq<FileStatus> org$apache$spark$sql$herd$HerdFileIndexBase$$getAllFilesUnderS3KeyPrefixes(Configuration hadoopConf, Seq<String> s3KeyPrefixes, String formatFileType) {
        return (Seq)s3KeyPrefixes.flatMap((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final List<FileStatus> apply(String s3KeyPrefix) {
                Path s3Path = new Path(s3KeyPrefix);
                FileSystem fs = s3Path.getFileSystem(this.hadoopConf$1);
                RemoteIterator iterator = fs.listFiles(s3Path, true);
                ArrayBuffer fileStatusList = new ArrayBuffer();
                while (iterator.hasNext()) {
                    LocatedFileStatus file = (LocatedFileStatus)iterator.next();
                    Object object = file.getPath().getName().matches("^_committed_.*$") ? BoxedUnit.UNIT : fileStatusList.$plus$eq((Object)file);
                }
                return fileStatusList.toList();
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private HerdFileIndexBase$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

