/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.ui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.io.IOUtils;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.finra.herd.core.HerdStringUtils;
import org.finra.herd.dao.helper.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestLoggingFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLoggingFilter.class);
    public static final String DEFAULT_LOG_MESSAGE_PREFIX = "HTTP Request [";
    public static final String DEFAULT_LOG_MESSAGE_SUFFIX = "]";
    public static final String AFTER_REQUEST_LOG_MESSAGE_PREFIX = "HerdTimingLog timingSource=HTTP ";
    private static final Integer DEFAULT_MAX_PAYLOAD_LENGTH = null;
    public static final String HERD_SDK_VERSION_HEADER_NAME = "X-Herd-Sdk-Version";
    private boolean includeQueryString = true;
    private boolean includeClientInfo = true;
    private boolean includePayload = true;
    private Integer maxPayloadLength = DEFAULT_MAX_PAYLOAD_LENGTH;
    private String logMessagePrefix = "HTTP Request [";
    private String logMessageSuffix = "]";

    public void setIncludeQueryString(boolean includeQueryString) {
        this.includeQueryString = includeQueryString;
    }

    protected boolean isIncludeQueryString() {
        return this.includeQueryString;
    }

    public void setIncludeClientInfo(boolean includeClientInfo) {
        this.includeClientInfo = includeClientInfo;
    }

    protected boolean isIncludeClientInfo() {
        return this.includeClientInfo;
    }

    public void setIncludePayload(boolean includePayload) {
        this.includePayload = includePayload;
    }

    protected boolean isIncludePayload() {
        return this.includePayload;
    }

    public void setMaxPayloadLength(Integer maxPayloadLength) {
        this.maxPayloadLength = maxPayloadLength;
    }

    protected Integer getMaxPayloadLength() {
        return this.maxPayloadLength;
    }

    public void setLogMessagePrefix(String logMessagePrefix) {
        this.logMessagePrefix = logMessagePrefix;
    }

    public void setLogMessageSuffix(String logMessageSuffix) {
        this.logMessageSuffix = logMessageSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean isFirstRequest;
        Object requestLocal = request;
        boolean bl = isFirstRequest = !this.isAsyncDispatch((HttpServletRequest)requestLocal);
        if (isFirstRequest) {
            requestLocal = new RequestLoggingFilterWrapper((HttpServletRequest)requestLocal);
            ((RequestLoggingFilterWrapper)((Object)requestLocal)).logRequest(request);
        }
        try {
            filterChain.doFilter((ServletRequest)requestLocal, (ServletResponse)response);
        }
        finally {
            if (!this.isAsyncStarted((HttpServletRequest)requestLocal) && requestLocal instanceof RequestLoggingFilterWrapper) {
                ((RequestLoggingFilterWrapper)((Object)requestLocal)).logAfterRequest(request, response);
            }
        }
    }

    public class RequestLoggingFilterWrapper
    extends HttpServletRequestWrapper {
        private byte[] payload;
        private BufferedReader reader;
        private long requestBeginTimeMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RequestLoggingFilterWrapper(HttpServletRequest request) throws IOException {
            super(request);
            this.payload = null;
            this.requestBeginTimeMillis = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                ServletInputStream inputStream = null;
                try {
                    inputStream = request.getInputStream();
                    if (inputStream != null) {
                        this.payload = IOUtils.toByteArray((InputStream)request.getInputStream());
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iox) {
                            LOGGER.warn("Unable to close request input stream.", (Throwable)iox);
                        }
                    }
                }
            }
        }

        public void logRequest(HttpServletRequest request) {
            String payloadString;
            StringBuilder message;
            block15: {
                message = new StringBuilder();
                message.append(RequestLoggingFilter.this.logMessagePrefix);
                message.append("uri=").append(request.getRequestURI());
                if (RequestLoggingFilter.this.isIncludeQueryString() && StringUtils.hasText((String)request.getQueryString())) {
                    message.append('?').append(request.getQueryString());
                }
                message.append(";method=").append(request.getMethod());
                if (request.getHeader(RequestLoggingFilter.HERD_SDK_VERSION_HEADER_NAME) != null && HerdStringUtils.verifyHerdVersionConformingString((String)request.getHeader(RequestLoggingFilter.HERD_SDK_VERSION_HEADER_NAME))) {
                    message.append(";herdSdkVersion=").append(request.getHeader(RequestLoggingFilter.HERD_SDK_VERSION_HEADER_NAME));
                }
                if (RequestLoggingFilter.this.isIncludeClientInfo()) {
                    String user;
                    HttpSession session;
                    String client = request.getRemoteAddr();
                    if (StringUtils.hasLength((String)client)) {
                        message.append(";client=").append(client);
                    }
                    if ((session = request.getSession(false)) != null) {
                        message.append(";session=").append(session.getId());
                    }
                    if ((user = request.getRemoteUser()) != null) {
                        message.append(";user=").append(user);
                    }
                }
                payloadString = "";
                try {
                    if (this.payload == null || this.payload.length <= 0) break block15;
                    payloadString = new String(this.payload, 0, this.payload.length, this.getCharacterEncoding());
                    String contentTypeRaw = request.getContentType();
                    if (contentTypeRaw == null) break block15;
                    ContentType contentType = null;
                    try {
                        contentType = ContentType.parse((String)contentTypeRaw);
                    }
                    catch (ParseException e) {
                        LOGGER.warn("Unable to interpret request content type: contentTypeRaw={}", (Object)contentTypeRaw, (Object)e);
                    }
                    if (contentType != null && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)ContentType.APPLICATION_XML.getMimeType(), (CharSequence)contentType.getMimeType())) {
                        try {
                            payloadString = XmlHelper.createPrettyPrint((String)payloadString);
                        }
                        catch (TransformerFactoryConfigurationError e) {
                            LOGGER.warn("Unable to configure transformation service to reformat payload", (Throwable)e);
                        }
                        catch (TransformerException e) {
                            LOGGER.warn("Unable to reformat payload", (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    payloadString = "[Unknown]";
                }
            }
            if (RequestLoggingFilter.this.isIncludePayload() && StringUtils.hasLength((String)payloadString)) {
                String sanitizedPayloadString = HerdStringUtils.sanitizeLogText((String)payloadString);
                message.append(";payload=").append(sanitizedPayloadString);
            }
            message.append(RequestLoggingFilter.this.logMessageSuffix);
            LOGGER.debug(message.toString());
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.payload == null) {
                return super.getInputStream();
            }
            return new ServletInputStream(){
                final ByteArrayInputStream byteArrayInputStream;
                {
                    this.byteArrayInputStream = new ByteArrayInputStream(RequestLoggingFilterWrapper.this.payload);
                }

                public int read() throws IOException {
                    return this.byteArrayInputStream.read();
                }

                public boolean isFinished() {
                    return true;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }
            };
        }

        public int getContentLength() {
            if (this.payload == null) {
                return super.getContentLength();
            }
            return this.payload.length;
        }

        public String getCharacterEncoding() {
            String enc = super.getCharacterEncoding();
            return enc != null ? enc : "ISO-8859-1";
        }

        public BufferedReader getReader() throws IOException {
            if (this.payload == null) {
                return super.getReader();
            }
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.payload), this.getCharacterEncoding()));
            }
            return this.reader;
        }

        public void logAfterRequest(HttpServletRequest request, HttpServletResponse response) {
            StringBuilder message = new StringBuilder();
            message.append(RequestLoggingFilter.AFTER_REQUEST_LOG_MESSAGE_PREFIX);
            message.append("uri=").append(request.getRequestURI());
            if (RequestLoggingFilter.this.isIncludeQueryString() && StringUtils.hasText((String)request.getQueryString())) {
                message.append('?').append(request.getQueryString());
            }
            message.append(" method=").append(request.getMethod());
            message.append(" status=").append(response.getStatus());
            message.append(" responseTimeMillis=").append(System.currentTimeMillis() - this.requestBeginTimeMillis);
            LOGGER.debug(message.toString());
        }
    }
}

