/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.ui.controller;

import org.finra.herd.model.api.xml.BuildInformation;
import org.finra.herd.ui.controller.HerdUiControllerAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;

@Controller
public class HerdController {
    @Autowired
    private BuildInformation buildInformation;

    @RequestMapping(value={"/displayBuildInfo"})
    public ModelAndView displayBuildInfo() {
        ModelAndView modelAndView = new ModelAndView("displayBuildInfo");
        modelAndView.addObject("buildInformation", (Object)this.buildInformation);
        return modelAndView;
    }

    @RequestMapping(value={"/displayInfoMessage"})
    public ModelAndView displayInfoMessage(@RequestParam(value="message") String message) {
        String viewName = "displayInfoMessage";
        if (message == null) {
            return new ModelAndView(viewName);
        }
        return new ModelAndView(viewName, "message", (Object)HtmlUtils.htmlEscape((String)message));
    }

    @RequestMapping(value={"/displayErrorMessage"})
    public ModelAndView displayErrorMessage(@RequestParam(value="message") String message) {
        return HerdUiControllerAdvice.getDisplayErrorMessageModelAndView(message);
    }

    @Secured(value={"FN_DISPLAY_HERD_UI"})
    @RequestMapping(value={"/herd-ui"})
    public ModelAndView displayHerdUi() {
        return new ModelAndView("herd-ui");
    }
}

