/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.ui.controller;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.finra.herd.ui.controller.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;

@ControllerAdvice(value={"org.finra.herd.ui.controller"})
public class HerdUiControllerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(HerdUiControllerAdvice.class);

    @ExceptionHandler(value={UserException.class})
    public ModelAndView handleUserException(UserException ex) {
        return HerdUiControllerAdvice.getDisplayErrorMessageModelAndView(ex.getMessage());
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public void handleAccessDeniedException(AccessDeniedException accessDeniedException, HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.FORBIDDEN.value());
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        LOGGER.error("An error occurred in a UI controller.", (Throwable)ex);
        return HerdUiControllerAdvice.getDisplayErrorModelAndView();
    }

    public static ModelAndView getDisplayErrorModelAndView() {
        return HerdUiControllerAdvice.getDisplayErrorMessageModelAndView(null);
    }

    public static ModelAndView getDisplayErrorMessageModelAndView(String message) {
        String viewName = "displayErrorMessage";
        if (message == null) {
            return new ModelAndView(viewName);
        }
        return new ModelAndView(viewName, "message", (Object)HtmlUtils.htmlEscape((String)message));
    }
}

