/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fisco.bcos.sdk.abi.TypeMappingException;
import org.fisco.bcos.sdk.abi.TypeReference;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.Fixed;
import org.fisco.bcos.sdk.abi.datatypes.Int;
import org.fisco.bcos.sdk.abi.datatypes.StaticArray;
import org.fisco.bcos.sdk.abi.datatypes.StaticStruct;
import org.fisco.bcos.sdk.abi.datatypes.StructType;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Ufixed;
import org.fisco.bcos.sdk.abi.datatypes.Uint;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;

public class Utils {
    private Utils() {
    }

    public static <T extends Type> String getMethodSign(TypeReference<T> typeReference) {
        return Utils.getMethodSign(typeReference.getType());
    }

    public static <T extends Type> String getMethodSign(java.lang.reflect.Type type) {
        try {
            Class<T> cls = Utils.getClassType(type);
            if (type instanceof ParameterizedType) {
                return Utils.getParameterizedMethodName(type);
            }
            return Utils.getSimpleMethodSign(cls);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static <T extends Type, U extends Type> String getParameterizedMethodName(java.lang.reflect.Type type) {
        try {
            Class<T> cls = Utils.getClassType(type);
            if (DynamicArray.class.isAssignableFrom(cls)) {
                return Utils.getMethodSign(((ParameterizedType)type).getActualTypeArguments()[0]) + "[]";
            }
            if (StaticArray.class.isAssignableFrom(cls)) {
                int length = Integer.parseInt(cls.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                return Utils.getMethodSign(((ParameterizedType)type).getActualTypeArguments()[0]) + "[" + length + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + cls.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    public static String getSimpleMethodSign(Class<?> type) {
        String simpleName = type.getSimpleName().toLowerCase();
        if (type.equals(Uint.class) || type.equals(Int.class) || type.equals(Ufixed.class) || type.equals(Fixed.class)) {
            return simpleName + "256";
        }
        if (type.equals(Utf8String.class)) {
            return "string";
        }
        if (type.equals(DynamicBytes.class)) {
            return "bytes";
        }
        if (StructType.class.isAssignableFrom(type)) {
            Constructor constructor = Arrays.stream(type.getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom) && declaredConstructor.getParameterTypes().length > 0).findAny().orElseThrow(() -> new RuntimeException("TypeReferenced struct must contain a constructor with types that extend Type"));
            int length = constructor.getParameterCount();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            for (int i = 0; i < length; ++i) {
                TypeReference typeReferenceElement = TypeReference.create(constructor.getGenericParameterTypes()[i]);
                stringBuilder.append(Utils.getTypeName(typeReferenceElement));
                stringBuilder.append(',');
            }
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
        return simpleName;
    }

    public static <T extends Type> String getTypeName(TypeReference<T> typeReference) {
        return Utils.getTypeName(typeReference.getType());
    }

    public static <T extends Type> String getTypeName(java.lang.reflect.Type type) {
        try {
            Class<T> cls = Utils.getClassType(type);
            if (type instanceof ParameterizedType) {
                return Utils.getParameterizedTypeName(type);
            }
            return Utils.getSimpleTypeName(cls);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static <T extends Type, U extends Type> String getParameterizedTypeName(java.lang.reflect.Type type) {
        try {
            Class<T> cls = Utils.getClassType(type);
            if (DynamicArray.class.isAssignableFrom(cls)) {
                return Utils.getTypeName(((ParameterizedType)type).getActualTypeArguments()[0]) + "[]";
            }
            if (StaticArray.class.isAssignableFrom(cls)) {
                int length = Integer.parseInt(cls.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                return Utils.getTypeName(((ParameterizedType)type).getActualTypeArguments()[0]) + "[" + length + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + cls.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    static String getSimpleTypeName(Class<?> type) {
        String simpleName = type.getSimpleName().toLowerCase();
        if (type.equals(Uint.class) || type.equals(Int.class) || type.equals(Ufixed.class) || type.equals(Fixed.class)) {
            return simpleName + "256";
        }
        if (type.equals(Utf8String.class)) {
            return "string";
        }
        if (type.equals(DynamicBytes.class)) {
            return "bytes";
        }
        if (StructType.class.isAssignableFrom(type)) {
            return type.getName();
        }
        return simpleName;
    }

    public static <T extends Type> boolean dynamicType(java.lang.reflect.Type type) throws ClassNotFoundException {
        Class<T> cls = Utils.getClassType(type);
        if (Utf8String.class.isAssignableFrom(cls) || DynamicBytes.class.isAssignableFrom(cls) || DynamicArray.class.isAssignableFrom(cls)) {
            return true;
        }
        if (!StaticArray.class.isAssignableFrom(cls)) {
            return false;
        }
        java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
        return Utils.dynamicType(types[0]);
    }

    public static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            count += type.offset();
        }
        return count;
    }

    public static <T extends Type> int getOffset(java.lang.reflect.Type type) throws ClassNotFoundException {
        if (Utils.dynamicType(type)) {
            return 1;
        }
        Class<T> cls = Utils.getClassType(type);
        if (StaticArray.class.isAssignableFrom(cls)) {
            int length = Integer.parseInt(cls.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
            java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            return Utils.getOffset(types[0]) * length;
        }
        return 1;
    }

    public static <T extends Type> Class<T> getClassType(java.lang.reflect.Type type) throws ClassNotFoundException {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Class.forName(type.getTypeName());
    }

    public static <T extends Type> Class<T> getParameterizedTypeFromArray(java.lang.reflect.Type type) throws ClassNotFoundException {
        java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
        return Utils.getClassType(types[0]);
    }

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(input.size());
        result.addAll(input.stream().map(typeReference -> typeReference).collect(Collectors.toList()));
        return result;
    }

    public static <T, R extends Type<T>, E extends Type<T>> List<E> typeMap(List<List<T>> input, Class<E> outerDestType, Class<R> innerType) {
        ArrayList<Type> result = new ArrayList<Type>();
        try {
            Constructor<E> constructor = outerDestType.getDeclaredConstructor(List.class);
            for (List<T> ts : input) {
                Type e = (Type)constructor.newInstance(Utils.typeMap(ts, innerType));
                result.add(e);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TypeMappingException(e);
        }
        return result;
    }

    public static <T, R extends Type<T>> List<R> typeMap(List<T> input, Class<R> destType) throws TypeMappingException {
        ArrayList<R> result = new ArrayList<R>(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor<R> constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (T value : input) {
                    result.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }

    public static List typeMapWithoutGenericType(List input, Class destType) throws TypeMappingException {
        ArrayList result = new ArrayList(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (Object value : input) {
                    result.add(constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }

    public static List<Field> staticStructNestedPublicFieldsFlatList(Class<Type> classType) {
        return Utils.staticStructsNestedFieldsFlatList(classType).stream().filter(field -> Modifier.isPublic(field.getModifiers())).collect(Collectors.toList());
    }

    public static List<Field> staticStructsNestedFieldsFlatList(Class<Type> classType) {
        List canonicalFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> !StaticStruct.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        List nestedFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> StaticStruct.class.isAssignableFrom(field.getType())).map(field -> Utils.staticStructsNestedFieldsFlatList(field.getType())).flatMap(Collection::stream).collect(Collectors.toList());
        return Stream.concat(canonicalFields.stream(), nestedFields.stream()).collect(Collectors.toList());
    }
}

