/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.datatypes;

import java.util.List;
import org.fisco.bcos.sdk.abi.Utils;
import org.fisco.bcos.sdk.abi.datatypes.Array;
import org.fisco.bcos.sdk.abi.datatypes.StructType;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.generated.AbiTypes;

public class DynamicArray<T extends Type>
extends Array<T> {
    @SafeVarargs
    public DynamicArray(T ... values) {
        super(StructType.class.isAssignableFrom(values[0].getClass()) ? values[0].getClass() : (Array.class.isAssignableFrom(values[0].getClass()) ? values[0].getClass() : AbiTypes.getType(values[0].getTypeAsString())), values);
    }

    public DynamicArray(List<T> values) {
        super(StructType.class.isAssignableFrom(((Type)values.get(0)).getClass()) ? ((Type)values.get(0)).getClass() : (Array.class.isAssignableFrom(((Type)values.get(0)).getClass()) ? ((Type)values.get(0)).getClass() : AbiTypes.getType(((Type)values.get(0)).getTypeAsString())), values);
    }

    private DynamicArray(String type) {
        super(type);
    }

    public DynamicArray(Class<T> type, List<T> values) {
        super(type, values);
    }

    @SafeVarargs
    public DynamicArray(Class<T> type, T ... values) {
        super(type, values);
    }

    public static DynamicArray empty(String type) {
        return new DynamicArray(type);
    }

    @Override
    public boolean dynamicType() {
        return true;
    }

    @Override
    public String getTypeAsString() {
        String paramsType;
        if (!this.value.isEmpty() && StructType.class.isAssignableFrom(((Type)this.value.get(0)).getClass())) {
            paramsType = ((Type)this.value.get(0)).getTypeAsString();
        } else if (StructType.class.isAssignableFrom(this.typeClass)) {
            try {
                Type t = (Type)this.typeClass.newInstance();
                paramsType = t.getTypeAsString();
            }
            catch (IllegalAccessException | InstantiationException e) {
                paramsType = AbiTypes.getTypeAString(this.typeClass);
            }
        } else {
            paramsType = Array.class.isAssignableFrom(this.typeClass) ? (!this.value.isEmpty() ? ((Type)this.value.get(0)).getTypeAsString() : Utils.getTypeName(this.typeClass)) : AbiTypes.getTypeAString(this.typeClass);
        }
        return paramsType + "[]";
    }

    @Override
    public int offset() {
        return 1;
    }
}

