/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.datatypes;

import java.util.Arrays;
import java.util.List;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Array;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Bytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.NumericType;
import org.fisco.bcos.sdk.abi.datatypes.StructType;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.AbiTypes;

public class StaticArray<T extends Type>
extends Array<T> {
    public static int MAX_SIZE_OF_STATIC_ARRAY = 1024;
    private Integer expectedSize;

    @SafeVarargs
    public StaticArray(T ... values) {
        super(StructType.class.isAssignableFrom(values[0].getClass()) ? values[0].getClass() : AbiTypes.getType(values[0].getTypeAsString()), values);
        this.isValid();
    }

    @SafeVarargs
    public StaticArray(int expectedSize, T ... values) {
        super(StructType.class.isAssignableFrom(values[0].getClass()) ? values[0].getClass() : (Array.class.isAssignableFrom(values[0].getClass()) ? (values[0].dynamicType() ? DynamicArray.class : StaticArray.class) : AbiTypes.getType(values[0].getTypeAsString())), values);
        this.expectedSize = expectedSize;
        this.isValid();
    }

    public StaticArray(List<T> values) {
        super(StructType.class.isAssignableFrom(((Type)values.get(0)).getClass()) ? ((Type)values.get(0)).getClass() : AbiTypes.getType(((Type)values.get(0)).getTypeAsString()), values);
        this.isValid();
    }

    public StaticArray(int expectedSize, List<T> values) {
        super(StructType.class.isAssignableFrom(((Type)values.get(0)).getClass()) ? ((Type)values.get(0)).getClass() : AbiTypes.getType(((Type)values.get(0)).getTypeAsString()), values);
        this.expectedSize = expectedSize;
        this.isValid();
    }

    @SafeVarargs
    public StaticArray(Class<T> type, T ... values) {
        this(type, Arrays.asList(values));
    }

    @SafeVarargs
    public StaticArray(Class<T> type, int expectedSize, T ... values) {
        this(type, expectedSize, Arrays.asList(values));
    }

    public StaticArray(Class<T> type, List<T> values) {
        this(type, values == null ? 0 : values.size(), values);
    }

    public StaticArray(Class<T> type, int expectedSize, List<T> values) {
        super(type, values);
        this.expectedSize = expectedSize;
        this.isValid();
    }

    @Override
    public String getTypeAsString() {
        String type = StructType.class.isAssignableFrom(((Type)this.value.get(0)).getClass()) ? ((Type)this.value.get(0)).getTypeAsString() : AbiTypes.getTypeAString(this.typeClass);
        return type + "[" + this.value.size() + "]";
    }

    private void isValid() {
        if (this.expectedSize == null && this.value.size() > MAX_SIZE_OF_STATIC_ARRAY) {
            throw new UnsupportedOperationException("Static arrays with a length greater than 1024 are not supported.");
        }
        if (this.expectedSize != null && this.value.size() != this.expectedSize.intValue()) {
            throw new UnsupportedOperationException("Expected array of type [" + this.getClass().getSimpleName() + "] to have [" + this.expectedSize + "] elements.");
        }
    }

    @Override
    public boolean dynamicType() {
        Type obj = (Type)this.value.get(0);
        if (obj instanceof StaticArray) {
            return obj.dynamicType();
        }
        if (obj instanceof NumericType || obj instanceof Address || obj instanceof Bool || obj instanceof Bytes) {
            return false;
        }
        if (obj instanceof DynamicBytes || obj instanceof Utf8String || obj instanceof DynamicArray) {
            return true;
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + obj.getClass());
    }

    @Override
    public int offset() {
        if (this.dynamicType()) {
            return 1;
        }
        Object obj = this.value.get(0);
        if (obj instanceof StaticArray) {
            return ((Type)obj).offset() * this.getValue().size();
        }
        return this.getValue().size();
    }
}

