/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.wrapper;

import org.fisco.bcos.sdk.abi.ABICodecException;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.abi.wrapper.ContractABIDefinition;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABIDefinitionFactory {
    private static final Logger logger = LoggerFactory.getLogger(ABIDefinitionFactory.class);
    private CryptoSuite cryptoSuite;

    public ABIDefinitionFactory(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public ContractABIDefinition loadABI(String abi) {
        try {
            ABIDefinition[] abiDefinitions = (ABIDefinition[])ObjectMapperFactory.getObjectMapper().readValue(abi, ABIDefinition[].class);
            ContractABIDefinition contractABIDefinition = new ContractABIDefinition(this.cryptoSuite);
            for (ABIDefinition abiDefinition : abiDefinitions) {
                switch (abiDefinition.getType()) {
                    case "constructor": {
                        contractABIDefinition.setConstructor(abiDefinition);
                        break;
                    }
                    case "function": {
                        contractABIDefinition.addFunction(abiDefinition.getName(), abiDefinition);
                        break;
                    }
                    case "event": {
                        contractABIDefinition.addEvent(abiDefinition.getName(), abiDefinition);
                        break;
                    }
                    case "fallback": {
                        if (contractABIDefinition.hasFallbackFunction()) {
                            throw new ABICodecException("only single fallback is allowed");
                        }
                        contractABIDefinition.setFallbackFunction(abiDefinition);
                        break;
                    }
                    case "receive": {
                        if (contractABIDefinition.hasReceiveFunction()) {
                            throw new ABICodecException("only single receive is allowed");
                        }
                        if (!"payable".equals(abiDefinition.getStateMutability()) && !abiDefinition.isPayable()) {
                            throw new ABICodecException("the statemutability of receive can only be payable");
                        }
                        contractABIDefinition.setReceiveFunction(abiDefinition);
                        break;
                    }
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace(" abiDefinition: {}", (Object)abiDefinition);
            }
            if (contractABIDefinition.getConstructor() == null) {
                contractABIDefinition.setConstructor(ABIDefinition.createDefaultConstructorABIDefinition());
            }
            if (logger.isTraceEnabled()) {
                logger.trace(" contractABIDefinition {} ", (Object)contractABIDefinition);
            }
            return contractABIDefinition;
        }
        catch (Exception e) {
            logger.error(" e: ", (Throwable)e);
            return null;
        }
    }
}

