/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.protocol.request;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class JsonRpcRequest<T> {
    private static AtomicLong nextIdGetter = new AtomicLong(0L);
    private String jsonrpc = "2.0";
    private String method;
    private List<T> params;
    private long id;

    public JsonRpcRequest(String method, List<T> params) {
        this.method = method;
        this.params = params;
        this.id = nextIdGetter.getAndIncrement();
    }

    public static AtomicLong getNextIdGetter() {
        return nextIdGetter;
    }

    public static void setNextIdGetter(AtomicLong nextIdGetter) {
        JsonRpcRequest.nextIdGetter = nextIdGetter;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<T> getParams() {
        return this.params;
    }

    public void setParams(List<T> params) {
        this.params = params;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRpcRequest that = (JsonRpcRequest)o;
        return this.id == that.id && Objects.equals(this.jsonrpc, that.jsonrpc) && Objects.equals(this.method, that.method) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.jsonrpc, this.method, this.params, this.id);
    }

    public String toString() {
        return "JsonRpcRequest{jsonrpc='" + this.jsonrpc + '\'' + ", method='" + this.method + '\'' + ", params=" + this.params + ", id=" + this.id + '}';
    }
}

