/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.codegen;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.codegen.exceptions.CodeGenException;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;

public final class CodeGenUtils {
    public static String parsePositionalArg(String[] args, int idx) {
        if (args != null && args.length > idx) {
            return args[idx];
        }
        return "";
    }

    public static String parseParameterArgument(String[] args, String ... parameters) {
        for (String parameter : parameters) {
            for (int i = 0; i < args.length; ++i) {
                String parameterValue;
                if (!args[i].equals(parameter) || i + 1 >= args.length || (parameterValue = args[i + 1]).startsWith("-")) continue;
                return parameterValue;
            }
        }
        return "";
    }

    public static String getFileNameNoExtension(String fileName) {
        String[] splitName = fileName.split("\\.(?=[^.]*$)");
        return splitName[0];
    }

    public static List<ABIDefinition> loadContractAbiDefinition(File abiFile) throws CodeGenException {
        try {
            return (List)ObjectMapperFactory.getObjectMapper().readValue(abiFile, (TypeReference)new TypeReference<List<ABIDefinition>>(){});
        }
        catch (IOException e) {
            throw new CodeGenException("loadContractAbiDefinition for " + abiFile.getName().toString() + " failed, error info: " + e.getLocalizedMessage(), e);
        }
    }

    public static List<ABIDefinition> loadContractAbiDefinition(String abi) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        ABIDefinition[] abiDefinition = (ABIDefinition[])objectMapper.readValue(abi, ABIDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    public static byte[] readBytes(File file) throws CodeGenException, IOException {
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        if (!file.canRead()) {
            throw new CodeGenException("file " + file + " is not readable or contains invalid characters");
        }
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(bytes);
        }
        catch (IOException e) {
            throw new CodeGenException("read data from " + file + " failed, error information: " + e.getMessage(), e);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return bytes;
    }

    public static void exitError(Throwable throwable) {
        System.err.println(throwable.getMessage());
        System.exit(1);
    }
}

