/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.config.model;

import java.io.File;
import java.util.List;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.config.model.AmopTopic;
import org.fisco.bcos.sdk.config.model.ConfigProperty;

public class AmopConfig {
    private List<AmopTopic> amopTopicConfig;

    public AmopConfig(ConfigProperty configProperty) throws ConfigException {
        this.amopTopicConfig = configProperty.getAmop();
        if (this.amopTopicConfig == null) {
            return;
        }
    }

    private void checkFileExist() throws ConfigException {
        for (AmopTopic topic : this.amopTopicConfig) {
            if (null != topic.getPrivateKey()) {
                File privateKeyFile = new File(topic.getPrivateKey());
                if (privateKeyFile.exists()) continue;
                throw new ConfigException("Invalid configuration, " + topic.getPrivateKey() + " file not exist");
            }
            if (null != topic.getPublicKeys()) {
                for (String pubKey : topic.getPublicKeys()) {
                    File pubKeyFile = new File(pubKey);
                    if (pubKeyFile.exists()) continue;
                    throw new ConfigException("Invalid configuration, " + pubKey + " file not exist");
                }
                continue;
            }
            throw new ConfigException("Amop private topic is not configured right, please check your config file. Topic name " + topic.getTopicName() + ", neither private key nor public key list configured.");
        }
    }

    public List<AmopTopic> getAmopTopicConfig() {
        return this.amopTopicConfig;
    }

    public void setAmopTopicConfig(List<AmopTopic> amopTopicConfig) {
        this.amopTopicConfig = amopTopicConfig;
    }
}

