/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.cns;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.precompiled.cns.CNSPrecompiled;
import org.fisco.bcos.sdk.contract.precompiled.cns.CnsInfo;
import org.fisco.bcos.sdk.contract.precompiled.model.PrecompiledVersionCheck;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;

public class CnsService {
    private final CNSPrecompiled cnsPrecompiled;
    private String currentVersion;

    public CnsService(Client client, CryptoKeyPair credential) {
        this.cnsPrecompiled = CNSPrecompiled.load("0x0000000000000000000000000000000000001004", client, credential);
        this.currentVersion = client.getClientNodeVersion().getNodeVersion().getSupportedVersion();
    }

    public RetCode registerCNS(String contractName, String contractVersion, String contractAddress, String abiData) throws ContractException {
        return ReceiptParser.parseTransactionReceipt(this.cnsPrecompiled.insert(contractName, contractVersion, contractAddress, abiData));
    }

    public List<CnsInfo> selectByName(String contractName) throws ContractException {
        try {
            String cnsInfo = this.cnsPrecompiled.selectByName(contractName);
            return (List)ObjectMapperFactory.getObjectMapper().readValue(cnsInfo, (TypeReference)new TypeReference<List<CnsInfo>>(){});
        }
        catch (JsonProcessingException e) {
            throw new ContractException("CnsService: failed to call selectByName interface, error message: " + e.getMessage());
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public List<CnsInfo> selectByNameAndVersion(String contractName, String contractVersion) throws ContractException {
        String cnsInfo = null;
        try {
            cnsInfo = this.cnsPrecompiled.selectByNameAndVersion(contractName, contractVersion);
            return (List)ObjectMapperFactory.getObjectMapper().readValue(cnsInfo, (TypeReference)new TypeReference<List<CnsInfo>>(){});
        }
        catch (JsonProcessingException e) {
            throw new ContractException("CnsService: failed to call selectByNameAndVersion interface, error message: " + e.getMessage() + ", return cnsInfo: " + cnsInfo);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public String getContractAddress(String contractName, String contractVersion) throws ContractException {
        try {
            PrecompiledVersionCheck.CNS_GET_CONTRACT_ADDRESS_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
            return this.cnsPrecompiled.getContractAddress(contractName, contractVersion);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }
}

