/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.keystore;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collections;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.fisco.bcos.sdk.crypto.exceptions.LoadKeyStoreException;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyTool {
    protected static Logger logger = LoggerFactory.getLogger(KeyTool.class);
    protected final String keyStoreFile;
    protected final String password;
    protected KeyStore keyStore;
    private String hexedPublicKey = "";

    public KeyTool(String keyStoreFile, String password) {
        this.keyStoreFile = keyStoreFile;
        this.password = password;
        KeyTool.initSecurity();
        this.load();
    }

    public KeyTool(String keyStoreFile) {
        this(keyStoreFile, null);
    }

    public KeyTool(InputStream keyStoreFileInputStream, String password) {
        this.keyStoreFile = null;
        this.password = password;
        KeyTool.initSecurity();
        this.load(keyStoreFileInputStream);
    }

    public KeyTool(InputStream keyStoreFileInputStream) {
        this(keyStoreFileInputStream, null);
    }

    protected abstract PrivateKey getPrivateKey();

    private static void initSecurity() {
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public final String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public KeyPair getKeyPair() {
        PrivateKey privateKey = this.getPrivateKey();
        PublicKey publicKey = this.getPublicKeyFromPrivateKey();
        return new KeyPair(publicKey, privateKey);
    }

    protected abstract PublicKey getPublicKey();

    public static String getHexedPublicKey(PublicKey publicKey) {
        byte[] publicKeyBytes = ((BCECPublicKey)publicKey).getQ().getEncoded(false);
        BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length));
        return Numeric.toHexStringNoPrefixZeroPadded(publicKeyValue, 128);
    }

    public String getHexedPublicKey() {
        if (!"".equals(this.hexedPublicKey)) {
            return this.hexedPublicKey;
        }
        this.hexedPublicKey = KeyTool.getHexedPublicKey(this.getPublicKey());
        return this.hexedPublicKey;
    }

    public static String getHexedPrivateKey(PrivateKey privateKey) {
        return Numeric.toHexStringNoPrefixZeroPadded(((BCECPrivateKey)privateKey).getD(), 64);
    }

    public static PrivateKey convertHexedStringToPrivateKey(String hexedPrivateKey, String curveName) throws LoadKeyStoreException {
        BigInteger privateKeyValue = new BigInteger(hexedPrivateKey, 16);
        return KeyTool.convertHexedStringToPrivateKey(privateKeyValue, curveName);
    }

    public static PrivateKey convertHexedStringToPrivateKey(BigInteger privateKey, String curveName) {
        return KeyTool.convertPrivateKeyToKeyPair(privateKey, curveName).getPrivate();
    }

    public static KeyPair convertHexedStringToKeyPair(String hexedPrivateKey, String curveName) throws LoadKeyStoreException {
        BigInteger privateKeyValue = new BigInteger(hexedPrivateKey, 16);
        return KeyTool.convertPrivateKeyToKeyPair(privateKeyValue, curveName);
    }

    public static KeyPair convertPrivateKeyToKeyPair(BigInteger privateKey, String curveName) throws LoadKeyStoreException {
        try {
            KeyTool.initSecurity();
            ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(privateKey, (org.bouncycastle.jce.spec.ECParameterSpec)ecParameterSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            BCECPrivateKey privateKeyObject = (BCECPrivateKey)keyFactory.generatePrivate((KeySpec)privateKeySpec);
            PublicKey publicKey = KeyTool.getPublicKeyFromPrivateKey((PrivateKey)privateKeyObject);
            ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(privateKeyObject.getD(), new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN()));
            BCECPrivateKey bcecPrivateKey = new BCECPrivateKey(privateKeyObject.getAlgorithm(), ecPrivateKeyParameters, (BCECPublicKey)publicKey, (org.bouncycastle.jce.spec.ECParameterSpec)ecParameterSpec, BouncyCastleProvider.CONFIGURATION);
            return new KeyPair(publicKey, (PrivateKey)bcecPrivateKey);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new LoadKeyStoreException("covert private key into PrivateKey type failed,  error information: " + e.getMessage(), e);
        }
    }

    public static void storePublicKeyWithPem(PrivateKey privateKey, String privateKeyFilePath) throws IOException {
        PublicKey publicKey = KeyTool.getPublicKeyFromPrivateKey(privateKey);
        KeyTool.storePublicKeyWithPem(publicKey, privateKeyFilePath);
    }

    public static void storePublicKeyWithPem(PublicKey publicKey, String privateKeyFilePath) throws IOException {
        String publicKeyPath = privateKeyFilePath + ".pub";
        try (PemWriter writer = new PemWriter((Writer)new FileWriter(publicKeyPath));){
            writer.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", publicKey.getEncoded()));
            writer.flush();
        }
    }

    protected abstract void load(InputStream var1);

    protected void load() {
        try {
            FileInputStream keyStoreFileInputStream = new FileInputStream(this.keyStoreFile);
            this.load(keyStoreFileInputStream);
        }
        catch (FileNotFoundException | DecoderException e) {
            String errorMessage = "load keys from " + this.keyStoreFile + " failed for FileNotFoundException, error message:" + e.getMessage();
            logger.error(errorMessage);
            throw new LoadKeyStoreException(errorMessage, e);
        }
    }

    private static Method getMethod(Class<EC5Util> ec5UtilClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return ec5UtilClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            logger.debug("try to get method for EC5Util failed, method name: {}", (Object)methodName);
            return null;
        }
    }

    private static org.bouncycastle.jce.spec.ECParameterSpec convertToECParamSpec(ECParameterSpec _ecParams) throws LoadKeyStoreException {
        try {
            Class<EC5Util> ec5UtilClass = EC5Util.class;
            String methodName = "convertSpec";
            Object ecParamSpec = null;
            Object ec5utilObject = ec5UtilClass.newInstance();
            Method methodDeclare = KeyTool.getMethod(ec5UtilClass, methodName, ECParameterSpec.class);
            if (methodDeclare != null) {
                ecParamSpec = methodDeclare.invoke(ec5utilObject, _ecParams);
            } else {
                methodDeclare = KeyTool.getMethod(ec5UtilClass, methodName, ECParameterSpec.class, Boolean.TYPE);
                if (methodDeclare != null) {
                    ecParamSpec = methodDeclare.invoke(ec5utilObject, _ecParams, false);
                }
            }
            if (ecParamSpec != null) {
                return (org.bouncycastle.jce.spec.ECParameterSpec)ecParamSpec;
            }
            logger.error("convertToECParamSpec exception for {} not found, supported methodList: {}", (Object)methodName, (Object)(ec5UtilClass.getMethods() != null ? ec5UtilClass.getMethods().toString() : " none"));
            throw new LoadKeyStoreException("convertToECParamSpec exception for " + methodName + " not found! Please check the version of bcprov-jdk15on!");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("convertToECParamSpec exception, error: {}, e: {}", (Object)e.getMessage(), (Object)e.getStackTrace().toString());
            throw new LoadKeyStoreException("convertToECParamSpec exception for " + e.getMessage());
        }
    }

    protected PublicKey getPublicKeyFromPrivateKey() {
        return KeyTool.getPublicKeyFromPrivateKey(this.getPrivateKey());
    }

    public static PublicKey getPublicKeyFromPrivateKey(PrivateKey privateKey) throws LoadKeyStoreException {
        try {
            KeyTool.initSecurity();
            ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
            ECParameterSpec params = ecPrivateKey.getParams();
            org.bouncycastle.jce.spec.ECParameterSpec bcSpec = KeyTool.convertToECParamSpec(params);
            org.bouncycastle.math.ec.ECPoint q = bcSpec.getG().multiply(ecPrivateKey.getS());
            org.bouncycastle.math.ec.ECPoint bcW = bcSpec.getCurve().decodePoint(q.getEncoded(false));
            ECPoint w = new ECPoint(bcW.getAffineXCoord().toBigInteger(), bcW.getAffineYCoord().toBigInteger());
            ECPublicKeySpec keySpec = new ECPublicKeySpec(w, KeyTool.tryFindNamedCurveSpec(params));
            return KeyFactory.getInstance("EC", "BC").generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            String errorMessage = "get publicKey from given the private key failed, error message:" + e.getMessage();
            logger.error(errorMessage);
            throw new LoadKeyStoreException(errorMessage, e);
        }
    }

    private static ECParameterSpec tryFindNamedCurveSpec(ECParameterSpec params) throws LoadKeyStoreException {
        org.bouncycastle.jce.spec.ECParameterSpec bcSpec = KeyTool.convertToECParamSpec(params);
        for (Object name : Collections.list(ECNamedCurveTable.getNames())) {
            ECNamedCurveParameterSpec bcNamedSpec = ECNamedCurveTable.getParameterSpec((String)((String)name));
            if (!bcNamedSpec.getN().equals(bcSpec.getN()) || !bcNamedSpec.getH().equals(bcSpec.getH()) || !bcNamedSpec.getCurve().equals(bcSpec.getCurve()) || !bcNamedSpec.getG().equals(bcSpec.getG())) continue;
            return new ECNamedCurveSpec(bcNamedSpec.getName(), bcNamedSpec.getCurve(), bcNamedSpec.getG(), bcNamedSpec.getN(), bcNamedSpec.getH(), bcNamedSpec.getSeed());
        }
        return params;
    }
}

