/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.network.ChannelHandler;
import org.fisco.bcos.sdk.network.ConnectionInfo;
import org.fisco.bcos.sdk.network.MessageDecoder;
import org.fisco.bcos.sdk.network.MessageEncoder;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.fisco.bcos.sdk.network.NetworkException;
import org.fisco.bcos.sdk.network.SslContextInitializer;
import org.fisco.bcos.sdk.network.TimeoutConfig;
import org.fisco.bcos.sdk.utils.SystemInformation;
import org.fisco.bcos.sdk.utils.ThreadPoolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private ChannelHandler channelHandler;
    private List<ConnectionInfo> connectionInfoList = new CopyOnWriteArrayList<ConnectionInfo>();
    private Map<String, ChannelHandlerContext> availableConnections = new ConcurrentHashMap<String, ChannelHandlerContext>();
    private EventLoopGroup workerGroup;
    private Boolean running = false;
    private Bootstrap bootstrap = new Bootstrap();
    private SslContextInitializer sslContextInitializer = new SslContextInitializer();
    private List<ChannelFuture> connChannelFuture = new ArrayList<ChannelFuture>();
    private ScheduledExecutorService reconnSchedule = new ScheduledThreadPoolExecutor(1);
    private int cryptoType;

    public ConnectionManager(ConfigOption configOption, MsgHandler msgHandler) {
        this(configOption.getNetworkConfig().getPeers(), msgHandler);
    }

    public ConnectionManager(List<String> ipList, MsgHandler msgHandler) {
        if (ipList != null) {
            for (String peerIpPort : ipList) {
                this.connectionInfoList.add(new ConnectionInfo(peerIpPort));
            }
        }
        this.channelHandler = new ChannelHandler(this, msgHandler);
        logger.info(" all connections, size: {}, list: {}", (Object)this.connectionInfoList.size(), this.connectionInfoList);
    }

    public void startConnect(ConfigOption configOption) throws NetworkException {
        if (this.running.booleanValue()) {
            logger.debug("running");
            return;
        }
        logger.debug(" start connect. ");
        try {
            this.initNetty(configOption);
            this.running = true;
        }
        catch (Exception e) {
            logger.debug("init failed " + e.getMessage());
            throw new NetworkException("init failed " + e.getMessage());
        }
        for (ConnectionInfo connect : this.connectionInfoList) {
            logger.debug("startConnect to {}", (Object)connect.getEndPoint());
            ChannelFuture channelFuture = this.bootstrap.connect(connect.getIp(), connect.getPort().intValue());
            this.connChannelFuture.add(channelFuture);
        }
        boolean atLeastOneConnectSuccess = false;
        ArrayList<RetCode> errorMessageList = new ArrayList<RetCode>();
        for (int i = 0; i < this.connectionInfoList.size(); ++i) {
            ChannelFuture connectFuture;
            ConnectionInfo connInfo = this.connectionInfoList.get(i);
            if (!this.checkConnectionResult(this.cryptoType, connInfo, connectFuture = this.connChannelFuture.get(i), errorMessageList)) continue;
            atLeastOneConnectSuccess = true;
        }
        if (!atLeastOneConnectSuccess) {
            logger.error(" all connections have failed, {} ", errorMessageList);
            String errorMessageString = "";
            for (RetCode errorRetCode : errorMessageList) {
                errorMessageString = errorMessageString + "* " + errorRetCode.getMessage() + "\n";
            }
            for (RetCode errorRetCode : errorMessageList) {
                if (errorRetCode.getCode() != 1) continue;
                throw new NetworkException("Failed to connect to all the nodes!\n" + errorMessageString, 1);
            }
            throw new NetworkException("Failed to connect to all the nodes!\n" + errorMessageString, 2);
        }
        this.cryptoType = configOption.getCryptoMaterialConfig().getSslCryptoType();
        logger.debug(" start connect end. ");
    }

    public void startReconnectSchedule() {
        logger.debug(" start reconnect schedule");
        this.reconnSchedule.scheduleAtFixedRate(() -> this.reconnect(), TimeoutConfig.reconnectDelay, TimeoutConfig.reconnectDelay, TimeUnit.MILLISECONDS);
    }

    public void stopReconnectSchedule() {
        ThreadPoolService.stopThreadPool(this.reconnSchedule);
    }

    public void stopNetty() {
        try {
            if (this.running.booleanValue()) {
                if (this.workerGroup != null) {
                    this.workerGroup.shutdownGracefully().sync();
                }
                for (ChannelFuture channelFuture : this.connChannelFuture) {
                    channelFuture.channel().closeFuture().sync();
                }
                this.running = false;
                logger.info("The netty has been stopped");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Stop netty failed for {}", (Object)e.getMessage());
        }
    }

    private void reconnect() {
        ArrayList<ConnectionInfo> needReconnect = new ArrayList<ConnectionInfo>();
        int aliveConnectionCount = 0;
        for (ConnectionInfo connectionInfo : this.connectionInfoList) {
            ChannelHandlerContext ctx = this.availableConnections.get(connectionInfo.getEndPoint());
            if (Objects.isNull(ctx) || !ctx.channel().isActive()) {
                needReconnect.add(connectionInfo);
                continue;
            }
            ++aliveConnectionCount;
        }
        logger.trace(" Keep alive nodes count: {}", (Object)aliveConnectionCount);
        for (ConnectionInfo connectionInfo : needReconnect) {
            ArrayList<RetCode> errorMessageList;
            ChannelFuture connectFuture;
            if (this.checkConnectionResult(this.cryptoType, connectionInfo, connectFuture = this.bootstrap.connect(connectionInfo.getIp(), connectionInfo.getPort().intValue()), errorMessageList = new ArrayList<RetCode>())) {
                logger.info(" reconnect to {}:{} success", (Object)connectionInfo.getIp(), (Object)connectionInfo.getPort());
                continue;
            }
            logger.error(" reconnect to {}:{}, error: {}", new Object[]{connectionInfo.getIp(), connectionInfo.getPort(), errorMessageList});
        }
    }

    public void setMsgHandleThreadPool(ExecutorService msgHandleThreadPool) {
        this.channelHandler.setMsgHandleThreadPool(msgHandleThreadPool);
    }

    public List<ConnectionInfo> getConnectionInfoList() {
        return this.connectionInfoList;
    }

    public Map<String, ChannelHandlerContext> getAvailableConnections() {
        return this.availableConnections;
    }

    public ChannelHandlerContext getConnectionCtx(String peer) {
        return this.availableConnections.get(peer);
    }

    private void initNetty(ConfigOption configOption) throws NetworkException {
        SslContext sslContext;
        this.workerGroup = new NioEventLoopGroup();
        this.bootstrap.group(this.workerGroup);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)TimeoutConfig.connectTimeout));
        int sslCryptoType = configOption.getCryptoMaterialConfig().getSslCryptoType();
        if (configOption.getCryptoMaterialConfig().getCryptoProvider() != null && configOption.getCryptoMaterialConfig().getCryptoProvider().equalsIgnoreCase("hsm") && sslCryptoType == 0) {
            throw new NetworkException("NON-SM not support hardware secure module yet, please do not config cryptoMatirial.cryptoProvider = hsm.");
        }
        final SslContext finalSslContext = sslContext = sslCryptoType == 0 ? this.sslContextInitializer.initSslContext(configOption) : this.sslContextInitializer.initSMSslContext(configOption);
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                SslHandler sslHandler = finalSslContext.newHandler(ch.alloc());
                sslHandler.setHandshakeTimeoutMillis(TimeoutConfig.sslHandShakeTimeout);
                ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{sslHandler, new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0), new IdleStateHandler(TimeoutConfig.idleTimeout, TimeoutConfig.idleTimeout, TimeoutConfig.idleTimeout, TimeUnit.MILLISECONDS), new MessageEncoder(), new MessageDecoder(), ConnectionManager.this.channelHandler});
            }
        };
        this.bootstrap.handler((io.netty.channel.ChannelHandler)initializer);
    }

    private boolean checkConnectionResult(int cryptoType, ConnectionInfo connInfo, ChannelFuture connectFuture, List<RetCode> errorMessageList) {
        connectFuture.awaitUninterruptibly();
        if (!connectFuture.isSuccess()) {
            String errorMessage = "connect to " + connInfo.getIp() + ":" + connInfo.getPort() + " failed! Please make sure the nodes have been started, and the network between the SDK and the nodes are connected normally.";
            if (Objects.isNull(connectFuture.cause())) {
                logger.error("{}", (Object)errorMessage);
            } else {
                errorMessage = errorMessage + "reason: " + connectFuture.cause().getLocalizedMessage() + "\n";
                logger.error("{}, cause: {}", (Object)errorMessage, (Object)connectFuture.cause().getMessage());
            }
            errorMessageList.add(new RetCode(2, errorMessage));
            return false;
        }
        SslHandler sslhandler = (SslHandler)connectFuture.channel().pipeline().get(SslHandler.class);
        String checkerMessage = "! Please make sure the certificate is correctly configured and copied, ensure that the SDK and the node are in the same agency!";
        if (Objects.isNull(sslhandler)) {
            String sslHandshakeFailedMessage = "ssl handshake failed:/" + connInfo.getIp() + ":" + connInfo.getPort() + checkerMessage;
            logger.error(sslHandshakeFailedMessage);
            errorMessageList.add(new RetCode(1, sslHandshakeFailedMessage));
            return false;
        }
        Future sslHandshakeFuture = sslhandler.handshakeFuture().awaitUninterruptibly();
        if (sslHandshakeFuture.isSuccess()) {
            logger.info(" ssl handshake success {}:{}", (Object)connInfo.getIp(), (Object)connInfo.getPort());
            return true;
        }
        String sslHandshakeFailedMessage = "ssl handshake failed:/" + connInfo.getIp() + ":" + connInfo.getPort() + "\n";
        if (sslHandshakeFuture.cause() instanceof SSLHandshakeException) {
            if (cryptoType == 0 && !SystemInformation.supportSecp256K1) {
                sslHandshakeFailedMessage = sslHandshakeFailedMessage + " reason: secp256k1 algorithm is disabled by the current jdk. Please enable secp256k1 or replace to jdk that supports secp256k1.";
            } else {
                SSLHandshakeException e = (SSLHandshakeException)sslHandshakeFuture.cause();
                sslHandshakeFailedMessage = sslHandshakeFailedMessage + " reason: " + e.getLocalizedMessage() + ". Please make sure the certificate are correctly configured and copied.";
            }
        } else if (sslHandshakeFuture.cause() instanceof ClosedChannelException) {
            ClosedChannelException e = (ClosedChannelException)sslHandshakeFuture.cause();
            sslHandshakeFailedMessage = cryptoType == 0 ? sslHandshakeFailedMessage + " reason: The node closes the connection. Maybe connect to the sm node with ecdsa context or the node and the SDK are not belong to the same agency." : sslHandshakeFailedMessage + " reason: The node closes the connection. Maybe connect to the ecdsa node with sm context or the node and the SDK are not belong to the same agency.";
        } else {
            sslHandshakeFailedMessage = sslHandshakeFailedMessage + " reason: " + sslHandshakeFuture.cause().getLocalizedMessage() + " Please check if there is a netty conflict, the netty version currently supported by the sdk is:" + "4.1.53.Final";
        }
        logger.error(sslHandshakeFailedMessage);
        errorMessageList.add(new RetCode(1, sslHandshakeFailedMessage));
        return false;
    }

    protected ChannelHandlerContext addConnectionContext(String ip, int port, ChannelHandlerContext ctx) {
        String endpoint = ip + ":" + port;
        logger.debug("addConnectionContext, endpoint: {}, ctx:{}", (Object)endpoint, (Object)ctx);
        return this.availableConnections.put(endpoint, ctx);
    }

    protected void removeConnectionContext(String ip, int port, ChannelHandlerContext ctx) {
        String endpoint = ip + ":" + port;
        if (Objects.isNull(this.availableConnections.get(endpoint))) {
            return;
        }
        Boolean result = this.availableConnections.remove(endpoint, ctx);
        if (logger.isDebugEnabled()) {
            logger.debug(" result: {}, host: {}, port: {}, ctx: {}", new Object[]{result, ip, port, System.identityHashCode(ctx)});
        }
    }

    public void removeConnection(String peerIpPort) {
        for (ConnectionInfo conn : this.connectionInfoList) {
            String ipPort = conn.getIp() + ":" + conn.getPort();
            if (!ipPort.equals(peerIpPort)) continue;
            this.connectionInfoList.remove(conn);
            return;
        }
    }
}

