/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.abi.ABICodecException;
import org.fisco.bcos.sdk.abi.FunctionEncoder;
import org.fisco.bcos.sdk.abi.wrapper.ABICodecJsonWrapper;
import org.fisco.bcos.sdk.abi.wrapper.ABICodecObject;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinitionFactory;
import org.fisco.bcos.sdk.abi.wrapper.ABIObject;
import org.fisco.bcos.sdk.abi.wrapper.ABIObjectFactory;
import org.fisco.bcos.sdk.abi.wrapper.ContractABIDefinition;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.model.EventLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABICodec {
    private static final Logger logger = LoggerFactory.getLogger(ABICodec.class);
    private final CryptoSuite cryptoSuite;
    public static final String TYPE_CONSTRUCTOR = "constructor";
    private ABIDefinitionFactory abiDefinitionFactory;
    private final ABIObjectFactory abiObjectFactory = new ABIObjectFactory();
    private final ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();

    public ABICodec(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
        this.abiDefinitionFactory = new ABIDefinitionFactory(cryptoSuite);
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public String encodeConstructor(String ABI, String BIN, List<Object> params) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getConstructor();
        ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
        ABICodecObject abiCodecObject = new ABICodecObject();
        try {
            return BIN + abiCodecObject.encodeValue(inputABIObject, params).encode();
        }
        catch (Exception e) {
            logger.error(" exception in encodeMethodFromObject : {}", (Object)e.getMessage());
            String errorMsg = " cannot encode in encodeMethodFromObject with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public String encodeConstructorFromString(String ABI, String BIN, List<String> params) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getConstructor();
        ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
        try {
            return BIN + this.abiCodecJsonWrapper.encode(inputABIObject, params).encode();
        }
        catch (Exception e) {
            logger.error(" exception in encodeMethodFromObject : {}", (Object)e.getMessage());
            String errorMsg = " cannot encode in encodeMethodFromObject with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public String encodeMethod(String ABI, String methodName, List<Object> params) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        List<ABIDefinition> methods = contractABIDefinition.getFunctions().get(methodName);
        for (ABIDefinition abiDefinition : methods) {
            if (abiDefinition.getInputs().size() != params.size()) continue;
            ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
            ABICodecObject abiCodecObject = new ABICodecObject();
            try {
                String methodId = abiDefinition.getMethodId(this.cryptoSuite);
                return methodId + abiCodecObject.encodeValue(inputABIObject, params).encode();
            }
            catch (Exception e) {
                logger.error(" exception in encodeMethodFromObject : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot encode in encodeMethodFromObject with appropriate interface ABI";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public String encodeMethodById(String ABI, String methodId, List<Object> params) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getABIDefinitionByMethodId(methodId);
        if (abiDefinition == null) {
            String errorMsg = " methodId " + methodId + " is invalid";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
        ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
        ABICodecObject abiCodecObject = new ABICodecObject();
        try {
            return methodId + abiCodecObject.encodeValue(inputABIObject, params).encode();
        }
        catch (Exception e) {
            logger.error(" exception in encodeMethodByIdFromObject : {}", (Object)e.getMessage());
            String errorMsg = " cannot encode in encodeMethodByIdFromObject with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    private ABIDefinition getABIDefinition(String methodInterface) throws ABICodecException {
        int start = methodInterface.indexOf("(");
        int end = methodInterface.lastIndexOf(")");
        if (start == -1 || end == -1 || start >= end) {
            String errorMsg = " error format";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
        String name = methodInterface.substring(0, start);
        String type = methodInterface.substring(start + 1, end);
        if (type.indexOf("tuple") != -1) {
            String errorMsg = " cannot support tuple type";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
        String[] types = type.split(",");
        ArrayList<ABIDefinition.NamedType> inputs = new ArrayList<ABIDefinition.NamedType>();
        for (String s : types) {
            ABIDefinition.NamedType input = new ABIDefinition.NamedType("name", s);
            inputs.add(input);
        }
        return new ABIDefinition(false, inputs, name, null, "function", false, "nonpayable");
    }

    public String encodeMethodByInterface(String methodInterface, List<Object> params) throws ABICodecException {
        ABIDefinition abiDefinition = this.getABIDefinition(methodInterface);
        if (abiDefinition.getInputs().size() == params.size()) {
            ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
            ABICodecObject abiCodecObject = new ABICodecObject();
            try {
                String methodId = abiDefinition.getMethodId(this.cryptoSuite);
                return methodId + abiCodecObject.encodeValue(inputABIObject, params).encode();
            }
            catch (Exception e) {
                logger.error(" exception in encodeMethodByInterfaceFromObject : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot encode in encodeMethodByInterfaceFromObject";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public String encodeMethodFromString(String ABI, String methodName, List<String> params) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        List<ABIDefinition> methods = contractABIDefinition.getFunctions().get(methodName);
        if (methods == null) {
            logger.debug("Invalid methodName: {}, all the functions are: {}", (Object)methodName, contractABIDefinition.getFunctions());
            throw new ABICodecException("Invalid method " + methodName + " , supported functions are: " + contractABIDefinition.getFunctions().keySet());
        }
        for (ABIDefinition abiDefinition : methods) {
            if (abiDefinition.getInputs().size() != params.size()) continue;
            ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
            ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();
            try {
                String methodId = abiDefinition.getMethodId(this.cryptoSuite);
                return methodId + abiCodecJsonWrapper.encode(inputABIObject, params).encode();
            }
            catch (IOException e) {
                logger.error(" exception in encodeMethodFromString : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot encode in encodeMethodFromString with appropriate interface ABI";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public String encodeMethodByIdFromString(String ABI, String methodId, List<String> params) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getABIDefinitionByMethodId(methodId);
        if (abiDefinition == null) {
            String errorMsg = " methodId " + methodId + " is invalid";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
        ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
        ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();
        try {
            return methodId + abiCodecJsonWrapper.encode(inputABIObject, params).encode();
        }
        catch (IOException e) {
            logger.error(" exception in encodeMethodByIdFromString : {}", (Object)e.getMessage());
            String errorMsg = " cannot encode in encodeMethodByIdFromString with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public String encodeMethodByInterfaceFromString(String methodInterface, List<String> params) throws ABICodecException {
        ABIDefinition abiDefinition = this.getABIDefinition(methodInterface);
        if (abiDefinition.getInputs().size() == params.size()) {
            ABIObject inputABIObject = ABIObjectFactory.createInputObject(abiDefinition);
            ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();
            try {
                String methodId = abiDefinition.getMethodId(this.cryptoSuite);
                return methodId + abiCodecJsonWrapper.encode(inputABIObject, params).encode();
            }
            catch (IOException e) {
                logger.error(" exception in encodeMethodByInterfaceFromString : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot encode in encodeMethodByInterfaceFromString";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public Pair<List<Object>, List<ABIObject>> decodeMethodAndGetOutputObject(ABIDefinition abiDefinition, String output) throws ABICodecException {
        ABIObject outputABIObject = ABIObjectFactory.createOutputObject(abiDefinition);
        ABICodecObject abiCodecObject = new ABICodecObject();
        try {
            return abiCodecObject.decodeJavaObjectAndOutputObject(outputABIObject, output);
        }
        catch (Exception e) {
            logger.error(" exception in decodeMethodToObject : {}", (Object)e.getMessage());
            String errorMsg = " cannot decode in decodeMethodToObject with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public Pair<List<Object>, List<ABIObject>> decodeMethodAndGetOutputObject(String ABI, String methodName, String output) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        List<ABIDefinition> methods = contractABIDefinition.getFunctions().get(methodName);
        for (ABIDefinition abiDefinition : methods) {
            ABIObject outputABIObject = ABIObjectFactory.createOutputObject(abiDefinition);
            ABICodecObject abiCodecObject = new ABICodecObject();
            try {
                return abiCodecObject.decodeJavaObjectAndOutputObject(outputABIObject, output);
            }
            catch (Exception e) {
                logger.error(" exception in decodeMethodToObject : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot decode in decodeMethodToObject with appropriate interface ABI";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public List<Object> decodeMethod(ABIDefinition abiDefinition, String output) throws ABICodecException {
        return (List)this.decodeMethodAndGetOutputObject(abiDefinition, output).getLeft();
    }

    public List<Object> decodeMethod(String ABI, String methodName, String output) throws ABICodecException {
        return (List)this.decodeMethodAndGetOutputObject(ABI, methodName, output).getLeft();
    }

    public List<Object> decodeMethodById(String ABI, String methodId, String output) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getABIDefinitionByMethodId(methodId);
        if (abiDefinition == null) {
            String errorMsg = " methodId " + methodId + " is invalid";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
        ABIObject outputABIObject = ABIObjectFactory.createOutputObject(abiDefinition);
        ABICodecObject abiCodecObject = new ABICodecObject();
        try {
            return abiCodecObject.decodeJavaObject(outputABIObject, output);
        }
        catch (Exception e) {
            logger.error(" exception in decodeMethodByIdToObject : {}", (Object)e.getMessage());
            String errorMsg = " cannot decode in decodeMethodToObject with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public List<Object> decodeMethodByInterface(String ABI, String methodInterface, String output) throws ABICodecException {
        FunctionEncoder functionEncoder = new FunctionEncoder(this.cryptoSuite);
        String methodId = functionEncoder.buildMethodId(methodInterface);
        return this.decodeMethodById(ABI, methodId, output);
    }

    public List<String> decodeMethodToString(String ABI, String methodName, String output) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        List<ABIDefinition> methods = contractABIDefinition.getFunctions().get(methodName);
        if (methods == null) {
            throw new ABICodecException("Invalid method " + methodName + ", supported methods are: " + contractABIDefinition.getFunctions().keySet());
        }
        for (ABIDefinition abiDefinition : methods) {
            ABIObject outputABIObject = ABIObjectFactory.createOutputObject(abiDefinition);
            ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();
            try {
                return abiCodecJsonWrapper.decode(outputABIObject, output);
            }
            catch (Exception e) {
                logger.error(" exception in decodeMethodToString : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot decode in decodeMethodToString with appropriate interface ABI";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public List<String> decodeMethodByIdToString(String ABI, String methodId, String output) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getABIDefinitionByMethodId(methodId);
        if (abiDefinition == null) {
            String errorMsg = " methodId " + methodId + " is invalid";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
        ABIObject outputABIObject = ABIObjectFactory.createOutputObject(abiDefinition);
        ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();
        try {
            return abiCodecJsonWrapper.decode(outputABIObject, output);
        }
        catch (UnsupportedOperationException e) {
            logger.error(" exception in decodeMethodByIdToString : {}", (Object)e.getMessage());
            String errorMsg = " cannot decode in decodeMethodByIdToString with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public List<String> decodeMethodByInterfaceToString(String ABI, String methodInterface, String output) throws ABICodecException {
        FunctionEncoder functionEncoder = new FunctionEncoder(this.cryptoSuite);
        String methodId = functionEncoder.buildMethodId(methodInterface);
        return this.decodeMethodByIdToString(ABI, methodId, output);
    }

    public List<Object> decodeEvent(String ABI, String eventName, EventLog log) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        List<ABIDefinition> events = contractABIDefinition.getEvents().get(eventName);
        if (events == null) {
            throw new ABICodecException("Invalid event " + eventName + ", supported events are: " + contractABIDefinition.getEvents().keySet());
        }
        for (ABIDefinition abiDefinition : events) {
            ABIObject inputObject = ABIObjectFactory.createEventInputObject(abiDefinition);
            ABICodecObject abiCodecObject = new ABICodecObject();
            try {
                ArrayList<Object> params = new ArrayList();
                if (!log.getData().equals("0x")) {
                    params = abiCodecObject.decodeJavaObject(inputObject, log.getData());
                }
                List<String> topics = log.getTopics();
                return this.mergeEventParamsAndTopics(abiDefinition, params, topics);
            }
            catch (Exception e) {
                logger.error(" exception in decodeEventToObject : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot decode in decodeEventToObject with appropriate interface ABI";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public List<Object> decodeEventByTopic(String ABI, String eventTopic, EventLog log) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getABIDefinitionByEventTopic(eventTopic);
        ABIObject inputObject = ABIObjectFactory.createEventInputObject(abiDefinition);
        ABICodecObject abiCodecObject = new ABICodecObject();
        try {
            ArrayList<Object> params = new ArrayList();
            if (!log.getData().equals("0x")) {
                params = abiCodecObject.decodeJavaObject(inputObject, log.getData());
            }
            List<String> topics = log.getTopics();
            return this.mergeEventParamsAndTopics(abiDefinition, params, topics);
        }
        catch (Exception e) {
            logger.error(" exception in decodeEventByTopicToObject : {}", (Object)e.getMessage());
            String errorMsg = " cannot decode in decodeEventByTopicToObject with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public List<Object> decodeEventByInterface(String ABI, String eventSignature, EventLog log) throws ABICodecException {
        FunctionEncoder functionEncoder = new FunctionEncoder(this.cryptoSuite);
        String methodId = functionEncoder.buildMethodId(eventSignature);
        return this.decodeEventByTopic(ABI, methodId, log);
    }

    public List<String> decodeEventToString(String ABI, String eventName, EventLog log) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        List<ABIDefinition> events = contractABIDefinition.getEvents().get(eventName);
        if (events == null) {
            throw new ABICodecException("Invalid event " + eventName + ", current supported events are: " + contractABIDefinition.getEvents().keySet());
        }
        for (ABIDefinition abiDefinition : events) {
            ABIObject inputObject = ABIObjectFactory.createEventInputObject(abiDefinition);
            ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();
            try {
                ArrayList<String> params = new ArrayList();
                if (!log.getData().equals("0x")) {
                    params = abiCodecJsonWrapper.decode(inputObject, log.getData());
                }
                List<String> topics = log.getTopics();
                return this.mergeEventParamsAndTopicsToString(abiDefinition, params, topics);
            }
            catch (Exception e) {
                logger.error(" exception in decodeEventToString : {}", (Object)e.getMessage());
            }
        }
        String errorMsg = " cannot decode in decodeEventToString with appropriate interface ABI";
        logger.error(errorMsg);
        throw new ABICodecException(errorMsg);
    }

    public List<String> decodeEventByTopicToString(String ABI, String eventTopic, EventLog log) throws ABICodecException {
        ContractABIDefinition contractABIDefinition = this.abiDefinitionFactory.loadABI(ABI);
        ABIDefinition abiDefinition = contractABIDefinition.getABIDefinitionByEventTopic(eventTopic);
        ABIObject inputObject = ABIObjectFactory.createEventInputObject(abiDefinition);
        ABICodecJsonWrapper abiCodecJsonWrapper = new ABICodecJsonWrapper();
        try {
            ArrayList<String> params = new ArrayList();
            if (!log.getData().equals("0x")) {
                params = abiCodecJsonWrapper.decode(inputObject, log.getData());
            }
            List<String> topics = log.getTopics();
            return this.mergeEventParamsAndTopicsToString(abiDefinition, params, topics);
        }
        catch (Exception e) {
            logger.error(" exception in decodeEventByTopicToString : {}", (Object)e.getMessage());
            String errorMsg = " cannot decode in decodeEventByTopicToString with appropriate interface ABI";
            logger.error(errorMsg);
            throw new ABICodecException(errorMsg);
        }
    }

    public List<String> decodeEventByInterfaceToString(String ABI, String eventSignature, EventLog log) throws ABICodecException {
        FunctionEncoder functionEncoder = new FunctionEncoder(this.cryptoSuite);
        String methodId = functionEncoder.buildMethodId(eventSignature);
        return this.decodeEventByTopicToString(ABI, methodId, log);
    }

    private List<Object> mergeEventParamsAndTopics(ABIDefinition abiDefinition, List<Object> params, List<String> topics) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int paramIdx = 0;
        int topicIdx = 1;
        for (ABIDefinition.NamedType namedType : abiDefinition.getInputs()) {
            if (namedType.isIndexed()) {
                ret.add(topics.get(topicIdx));
                ++topicIdx;
                continue;
            }
            ret.add(params.get(paramIdx));
            ++paramIdx;
        }
        return ret;
    }

    private List<String> mergeEventParamsAndTopicsToString(ABIDefinition abiDefinition, List<String> params, List<String> topics) {
        ArrayList<String> ret = new ArrayList<String>();
        int paramIdx = 0;
        int topicIdx = 1;
        for (ABIDefinition.NamedType namedType : abiDefinition.getInputs()) {
            if (namedType.isIndexed()) {
                ret.add(topics.get(topicIdx));
                ++topicIdx;
                continue;
            }
            ret.add(params.get(paramIdx));
            ++paramIdx;
        }
        return ret;
    }
}

