/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.fisco.bcos.sdk.abi.Utils;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Array;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Bytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.Fixed;
import org.fisco.bcos.sdk.abi.datatypes.FixedPointType;
import org.fisco.bcos.sdk.abi.datatypes.Int;
import org.fisco.bcos.sdk.abi.datatypes.IntType;
import org.fisco.bcos.sdk.abi.datatypes.NumericType;
import org.fisco.bcos.sdk.abi.datatypes.StaticArray;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Ufixed;
import org.fisco.bcos.sdk.abi.datatypes.Uint;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Uint160;
import org.fisco.bcos.sdk.utils.Numeric;

public class TypeDecoder {
    static final int MAX_BYTE_LENGTH_FOR_HEX_STRING = 64;

    public static <T extends Type> T decode(String input, int offset, Class<T> type) {
        if (NumericType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Address.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeAddress(input.substring(offset));
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeUtf8String(input, offset);
        }
        if (Array.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Array types must be wrapped in a TypeReference");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    static Address decodeAddress(String input) {
        return new Address(TypeDecoder.decodeNumeric(input, Uint160.class));
    }

    static <T extends NumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            byte[] inputByteArray = Numeric.hexStringToByteArray(input);
            int typeLengthAsBytes = TypeDecoder.getTypeLengthInBytes(type);
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int.class.isAssignableFrom(type) || Fixed.class.isAssignableFrom(type)) {
                resultByteArray[0] = inputByteArray[0];
            }
            int valueOffset = 32 - typeLengthAsBytes;
            System.arraycopy(inputByteArray, valueOffset, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static <T extends NumericType> int getTypeLengthInBytes(Class<T> type) {
        return TypeDecoder.getTypeLength(type) >> 3;
    }

    static <T extends NumericType> int getTypeLength(Class<T> type) {
        if (IntType.class.isAssignableFrom(type)) {
            String regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                return Integer.parseInt(splitName[1]);
            }
        } else if (FixedPointType.class.isAssignableFrom(type)) {
            String regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                String[] bitsCounts = splitName[1].split("x");
                return Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
            }
        }
        return 256;
    }

    static int decodeUintAsInt(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        return TypeDecoder.decode(input, 0, Uint.class).getValue().intValue();
    }

    static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        BigInteger numericValue = Numeric.toBigInt(input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    static <T extends Bytes> T decodeBytes(String input, Class<T> type) {
        return TypeDecoder.decodeBytes(input, 0, type);
    }

    static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray(input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static DynamicBytes decodeDynamicBytes(String input, int offset) {
        int encodedLength = TypeDecoder.decodeUintAsInt(input, offset);
        int hexStringEncodedLength = encodedLength << 1;
        int valueOffset = offset + 64;
        String data = input.substring(valueOffset, valueOffset + hexStringEncodedLength);
        byte[] bytes = Numeric.hexStringToByteArray(data);
        return new DynamicBytes(bytes);
    }

    static Utf8String decodeUtf8String(String input, int offset) {
        DynamicBytes dynamicBytesResult = TypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    public static <T extends Type> T decodeStaticArray(String input, int offset, java.lang.reflect.Type type, int length) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStaticArray(type, elements);
        };
        return (T)TypeDecoder.decodeArrayElements(input, offset, type, length, function);
    }

    private static <T extends Type> T instantiateStaticArray(java.lang.reflect.Type type, List<T> elements) {
        try {
            Class cls = Utils.getClassType(type);
            return (T)((Type)cls.getConstructor(List.class).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            return (T)new StaticArray<T>(elements);
        }
    }

    public static <T extends Type> T decodeDynamicArray(String input, int offset, java.lang.reflect.Type type) {
        int length = TypeDecoder.decodeUintAsInt(input, offset);
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                return DynamicArray.empty(typeName);
            }
            return new DynamicArray(elements);
        };
        int valueOffset = offset + 64;
        return (T)TypeDecoder.decodeArrayElements(input, valueOffset, type, length, function);
    }

    private static <T extends Type> T decodeArrayElements(String input, int offset, java.lang.reflect.Type type, int length, BiFunction<List<T>, String, T> consumer) {
        try {
            ArrayList<Object> elements = new ArrayList<Object>(length);
            java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            Class paraType = Utils.getClassType(types[0]);
            for (int i = 0; i < length; ++i) {
                int currEleOffset = offset + i * 64 * Utils.getOffset(types[0]);
                Object t = null;
                if (Array.class.isAssignableFrom(paraType)) {
                    int size = 0;
                    if (StaticArray.class.isAssignableFrom(paraType)) {
                        size = Integer.parseInt(Utils.getClassType(types[0]).getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                        t = TypeDecoder.decodeStaticArray(input, currEleOffset, types[0], size);
                    } else {
                        int getOffset = TypeDecoder.decodeUintAsInt(input, currEleOffset) << 1;
                        t = TypeDecoder.decodeDynamicArray(input, offset + getOffset, types[0]);
                    }
                } else if (Utf8String.class.isAssignableFrom(paraType) || DynamicBytes.class.isAssignableFrom(paraType)) {
                    int getOffset = TypeDecoder.decodeUintAsInt(input, currEleOffset) << 1;
                    t = TypeDecoder.decode(input, offset + getOffset, paraType);
                } else {
                    t = TypeDecoder.decode(input, currEleOffset, paraType);
                }
                elements.add(t);
            }
            String typeName = Utils.getSimpleTypeName(paraType);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + type.getTypeName(), e);
        }
    }
}

