/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.datatypes;

import java.math.BigInteger;
import org.fisco.bcos.sdk.abi.Constant;
import org.fisco.bcos.sdk.abi.datatypes.IntType;

public class Int
extends IntType {
    public static final String TYPE_NAME = "int";
    public static final Int DEFAULT = new Int(BigInteger.ZERO);

    public Int(BigInteger value) {
        this(256, value);
    }

    public boolean validInt(BigInteger value) {
        return value.compareTo(Constant.MIN_INT256) >= 0 && value.compareTo(Constant.MAX_INT256) <= 0;
    }

    @Override
    boolean valid(int bitSize, BigInteger value) {
        return super.valid(bitSize, value) && this.validInt(value);
    }

    protected Int(int bitSize, BigInteger value) {
        super(TYPE_NAME, bitSize, value);
    }

    @Override
    public boolean dynamicType() {
        return false;
    }

    @Override
    public int offset() {
        return 1;
    }
}

