/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import org.fisco.bcos.sdk.abi.FunctionEncoder;
import org.fisco.bcos.sdk.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.abi.TypeReference;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.Event;
import org.fisco.bcos.sdk.abi.datatypes.Function;
import org.fisco.bcos.sdk.abi.datatypes.StaticArray;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.AbiTypes;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.codegen.CodeGenUtils;
import org.fisco.bcos.sdk.codegen.exceptions.CodeGenException;
import org.fisco.bcos.sdk.contract.Contract;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.eventsub.EventCallback;
import org.fisco.bcos.sdk.model.CryptoType;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.utils.Collection;
import org.fisco.bcos.sdk.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolidityContractWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SolidityContractWrapper.class);
    private static final int maxSolidityBinSize = 262144;
    private static final int maxField = 8192;
    private static String BINARY_ARRAY_NAME = "BINARY_ARRAY";
    private static String SM_BINARY_ARRAY_NAME = "SM_BINARY_ARRAY";
    private static final String BINARY_NAME = "BINARY";
    private static final String SM_BINARY_NAME = "SM_BINARY";
    private static final String ABI_ARRAY_NAME = "ABI_ARRAY";
    private static final String ABI_NAME = "ABI";
    private static final String GET_BINARY_FUNC = "getBinary";
    private static final String CLIENT = "client";
    private static final String CREDENTIAL = "credential";
    private static final String CRYPTOSUITE = "cryptoSuite";
    private static final String CONTRACT_ADDRESS = "contractAddress";
    private static final String FROM_BLOCK = "fromBlock";
    private static final String TO_BLOCK = "toBlock";
    private static final String CALLBACK_VALUE = "callback";
    private static final String OTHER_TOPICS = "otherTopics";
    private static final String FUNC_NAME_PREFIX = "FUNC_";
    private static final String EVENT_ENCODER = "eventEncoder";
    private static final String regex = "(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?";
    private static final Pattern pattern = Pattern.compile("(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?");

    public void generateJavaFiles(String contractName, String bin, String smBin, String abi, String destinationDir, String basePackageName) throws IOException, ClassNotFoundException, UnsupportedOperationException, CodeGenException {
        String className = StringUtils.capitaliseFirstLetter(contractName);
        logger.info("bin: {}", (Object)bin);
        logger.info("smBin: {}", (Object)smBin);
        if (bin.length() > 262144) {
            throw new UnsupportedOperationException(" contract binary too long, max support is 256k, now is " + Integer.valueOf(bin.length()));
        }
        List<ABIDefinition> abiDefinitions = CodeGenUtils.loadContractAbiDefinition(abi);
        TypeSpec.Builder classBuilder = this.createClassBuilder(className, bin, smBin, abi);
        classBuilder.addMethod(SolidityContractWrapper.buildGetBinaryMethod(CryptoSuite.class, CryptoType.class, CRYPTOSUITE));
        classBuilder.addMethod(SolidityContractWrapper.buildConstructor(CryptoKeyPair.class, CREDENTIAL));
        classBuilder.addFields(this.buildFuncNameConstants(abiDefinitions));
        classBuilder.addMethods(this.buildFunctionDefinitions(classBuilder, abiDefinitions));
        classBuilder.addMethod(SolidityContractWrapper.buildLoad(className, CryptoKeyPair.class, CREDENTIAL));
        classBuilder.addMethods(this.buildDeployMethods(className, abiDefinitions));
        this.write(basePackageName, classBuilder.build(), destinationDir);
    }

    protected void write(String packageName, TypeSpec typeSpec, String destinationDir) throws IOException {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).indent("    ").skipJavaLangImports(true).build();
        javaFile.writeTo(new File(destinationDir));
    }

    private TypeSpec.Builder createClassBuilder(String className, String binary, String smBinary, String abi) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(Contract.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addField(this.createArrayDefinition(BINARY_ARRAY_NAME, binary)).addField(this.createDefinition(BINARY_NAME, BINARY_ARRAY_NAME)).addField(this.createArrayDefinition(SM_BINARY_ARRAY_NAME, smBinary)).addField(this.createDefinition(SM_BINARY_NAME, SM_BINARY_ARRAY_NAME)).addField(this.createArrayDefinition(ABI_ARRAY_NAME, abi)).addField(this.createDefinition(ABI_NAME, ABI_ARRAY_NAME));
        return builder;
    }

    public List<String> stringToArrayString(String binary) {
        String item;
        ArrayList<String> binaryArray = new ArrayList<String>();
        for (int offset = 0; offset < binary.length(); offset += item.length()) {
            int length = binary.length() - offset;
            if (length > 8192) {
                length = 8192;
            }
            item = binary.substring(offset, offset + length);
            binaryArray.add(item);
        }
        return binaryArray;
    }

    private FieldSpec createArrayDefinition(String type, String binary) {
        List<String> binaryArray = this.stringToArrayString(binary);
        ArrayList<String> formatArray = new ArrayList<String>(Collections.nCopies(binaryArray.size(), "$S"));
        return FieldSpec.builder(String[].class, (String)type, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("{" + String.join((CharSequence)",", formatArray) + "}", binaryArray.toArray()).build();
    }

    private FieldSpec createDefinition(String type, String binayArrayName) {
        return FieldSpec.builder(String.class, (String)type, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("String.join(\"\", " + binayArrayName + ")", new Object[0]).build();
    }

    private FieldSpec createEventDefinition(String name, List<NamedTypeName> parameters) {
        CodeBlock initializer = SolidityContractWrapper.buildVariableLengthEventInitializer(name, parameters);
        return FieldSpec.builder(Event.class, (String)this.buildEventDefinitionName(name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer).build();
    }

    private String buildEventDefinitionName(String eventName) {
        return eventName.toUpperCase() + "_EVENT";
    }

    private static boolean isOverLoadFunction(String name, List<ABIDefinition> functionDefinitions) {
        int count = 0;
        for (ABIDefinition functionDefinition : functionDefinitions) {
            if (!functionDefinition.getType().equals("function") || !functionDefinition.getName().equals(name)) continue;
            ++count;
        }
        return count > 1;
    }

    private List<MethodSpec> buildFunctionDefinitions(TypeSpec.Builder classBuilder, List<ABIDefinition> functionDefinitions) throws ClassNotFoundException {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (ABIDefinition functionDefinition : functionDefinitions) {
            if (functionDefinition.getType().equals("function")) {
                MethodSpec ms = this.buildFunction(functionDefinition);
                methodSpecs.add(ms);
                if (functionDefinition.isConstant()) continue;
                MethodSpec msCallback = this.buildFunctionWithCallback(functionDefinition);
                methodSpecs.add(msCallback);
                MethodSpec msSeq = this.buildFunctionSignedTransaction(functionDefinition);
                methodSpecs.add(msSeq);
                boolean isOverLoad = SolidityContractWrapper.isOverLoadFunction(functionDefinition.getName(), functionDefinitions);
                if (!functionDefinition.getInputs().isEmpty()) {
                    MethodSpec inputDecoder = this.buildFunctionWithInputDecoder(functionDefinition, isOverLoad);
                    methodSpecs.add(inputDecoder);
                }
                if (functionDefinition.getOutputs().isEmpty()) continue;
                MethodSpec outputDecoder = this.buildFunctionWithOutputDecoder(functionDefinition, isOverLoad);
                methodSpecs.add(outputDecoder);
                continue;
            }
            if (!functionDefinition.getType().equals("event")) continue;
            methodSpecs.addAll(this.buildEventFunctions(functionDefinition, classBuilder));
        }
        return methodSpecs;
    }

    private List<MethodSpec> buildDeployMethods(String className, List<ABIDefinition> functionDefinitions) {
        boolean constructor = false;
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (ABIDefinition functionDefinition : functionDefinitions) {
            if (!functionDefinition.getType().equals("constructor")) continue;
            constructor = true;
            methodSpecs.add(this.buildDeploy(className, functionDefinition, CryptoKeyPair.class, CREDENTIAL));
        }
        if (!constructor) {
            MethodSpec.Builder credentialsMethodBuilder = SolidityContractWrapper.getDeployMethodSpec(className, CryptoKeyPair.class, CREDENTIAL);
            methodSpecs.add(SolidityContractWrapper.buildDeployNoParams(credentialsMethodBuilder, className, CREDENTIAL));
        }
        return methodSpecs;
    }

    private Iterable<FieldSpec> buildFuncNameConstants(List<ABIDefinition> functionDefinitions) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.add("deploy");
        for (ABIDefinition functionDefinition : functionDefinitions) {
            String funcName;
            if (!functionDefinition.getType().equals("function") || fieldNames.contains(funcName = functionDefinition.getName())) continue;
            FieldSpec field = FieldSpec.builder(String.class, (String)SolidityContractWrapper.funcNameToConst(funcName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{funcName}).build();
            fields.add(field);
            fieldNames.add(funcName);
        }
        return fields;
    }

    private static MethodSpec buildGetBinaryMethod(Class authType, Class cryptoType, String authName) {
        MethodSpec.Builder toReturn = MethodSpec.methodBuilder((String)GET_BINARY_FUNC).addParameter((Type)authType, authName, new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(String.class);
        toReturn.addStatement("return ($N.getCryptoTypeConfig() == $T.ECDSA_TYPE ? $N : $N)", new Object[]{authName, cryptoType, BINARY_NAME, SM_BINARY_NAME});
        return toReturn.build();
    }

    private static MethodSpec buildConstructor(Class authType, String authName) {
        MethodSpec.Builder toReturn = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Client.class, CLIENT, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]).addStatement("super($N, $N, $N, $N)", new Object[]{SolidityContractWrapper.getBinaryFuncDefinition(), CONTRACT_ADDRESS, CLIENT, authName});
        return toReturn.build();
    }

    private MethodSpec buildDeploy(String className, ABIDefinition functionDefinition, Class authType, String authName) {
        MethodSpec.Builder methodBuilder = SolidityContractWrapper.getDeployMethodSpec(className, authType, authName);
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        if (!inputParams.isEmpty()) {
            return SolidityContractWrapper.buildDeployWithParams(methodBuilder, className, inputParams, authName);
        }
        return SolidityContractWrapper.buildDeployNoParams(methodBuilder, className, authName);
    }

    private static MethodSpec buildDeployWithParams(MethodSpec.Builder methodBuilder, String className, String inputParams, String authName) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($T.<$T>asList($L))", new Object[]{String.class, FunctionEncoder.class, Arrays.class, org.fisco.bcos.sdk.abi.datatypes.Type.class, inputParams}).addStatement("return deploy($L.class, $L, $L, $L, encodedConstructor)", new Object[]{className, CLIENT, authName, SolidityContractWrapper.getBinaryFuncDefinition()});
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployNoParams(MethodSpec.Builder methodBuilder, String className, String authName) {
        methodBuilder.addStatement("return deploy($L.class, $L, $L, $L, \"\")", new Object[]{className, CLIENT, authName, SolidityContractWrapper.getBinaryFuncDefinition()});
        return methodBuilder.build();
    }

    private static MethodSpec.Builder getDeployMethodSpec(String className, Class authType, String authName) {
        return MethodSpec.methodBuilder((String)"deploy").addException(ContractException.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{org.fisco.bcos.sdk.abi.datatypes.Type.class})).addParameter(Client.class, CLIENT, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]);
    }

    private static MethodSpec buildLoad(String className, Class authType, String authName) {
        MethodSpec.Builder toReturn = MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{org.fisco.bcos.sdk.abi.datatypes.Type.class})).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Client.class, CLIENT, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]).addStatement("return new $L($L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, CLIENT, authName});
        return toReturn.build();
    }

    private MethodSpec.Builder addParameter(MethodSpec.Builder methodBuilder, String type, String name) {
        ParameterSpec parameterSpec = this.buildParameterType(type, name);
        TypeName typeName = SolidityContractWrapper.getNativeType(parameterSpec.type);
        ParameterSpec inputParameter = ParameterSpec.builder((TypeName)typeName, (String)parameterSpec.name, (Modifier[])new Modifier[0]).build();
        methodBuilder.addParameter(inputParameter);
        return methodBuilder;
    }

    private String addParameters(MethodSpec.Builder methodBuilder, List<ABIDefinition.NamedType> namedTypes) {
        List<ParameterSpec> inputParameterTypes = SolidityContractWrapper.buildParameterTypes(namedTypes);
        ArrayList<ParameterSpec> nativeInputParameterTypes = new ArrayList<ParameterSpec>(inputParameterTypes.size());
        for (ParameterSpec parameterSpec : inputParameterTypes) {
            TypeName typeName = SolidityContractWrapper.getNativeType(parameterSpec.type);
            nativeInputParameterTypes.add(ParameterSpec.builder((TypeName)typeName, (String)parameterSpec.name, (Modifier[])new Modifier[0]).build());
        }
        methodBuilder.addParameters(nativeInputParameterTypes);
        return Collection.join(namedTypes, ", \n", this::createMappedParameterTypes);
    }

    private String addParameters(List<ABIDefinition.NamedType> namedTypes) {
        List<ParameterSpec> inputParameterTypes = SolidityContractWrapper.buildParameterTypes(namedTypes);
        ArrayList<ParameterSpec> nativeInputParameterTypes = new ArrayList<ParameterSpec>(inputParameterTypes.size());
        for (ParameterSpec parameterSpec : inputParameterTypes) {
            TypeName typeName = SolidityContractWrapper.getNativeType(parameterSpec.type);
            nativeInputParameterTypes.add(ParameterSpec.builder((TypeName)typeName, (String)parameterSpec.name, (Modifier[])new Modifier[0]).build());
        }
        return Collection.join(namedTypes, ", \n", this::createMappedParameterTypes);
    }

    private String createMappedParameterTypes(ABIDefinition.NamedType namedType) {
        String name = namedType.getName();
        String type = namedType.getType();
        ABIDefinition.Type innerType = new ABIDefinition.Type(type);
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)SolidityContractWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build();
        if (parameterSpec.type instanceof ParameterizedTypeName) {
            List typeNames = ((ParameterizedTypeName)parameterSpec.type).typeArguments;
            if (typeNames.size() != 1) {
                throw new UnsupportedOperationException("Only a single parameterized type is supported");
            }
            String parameterSpecType = parameterSpec.type.toString();
            TypeName typeName = (TypeName)typeNames.get(0);
            String typeMapInput = typeName + ".class";
            if (typeName instanceof ParameterizedTypeName) {
                List typeArguments = ((ParameterizedTypeName)typeName).typeArguments;
                if (typeArguments.size() != 1) {
                    throw new UnsupportedOperationException("Only a single parameterized type is supported");
                }
                TypeName innerTypeName = (TypeName)typeArguments.get(0);
                parameterSpecType = ((ParameterizedTypeName)parameterSpec.type).rawType.toString();
                typeMapInput = ((ParameterizedTypeName)typeName).rawType + ".class, " + innerTypeName + ".class";
            }
            if (innerType.isDynamicList()) {
                return parameterSpec.name + ".isEmpty()?org.fisco.bcos.sdk.abi.datatypes.DynamicArray.empty(\"" + type + "\"):new " + parameterSpecType + "(\n        org.fisco.bcos.sdk.abi.Utils.typeMap(" + parameterSpec.name + ", " + typeMapInput + "))";
            }
            return "new " + parameterSpecType + "(\n        org.fisco.bcos.sdk.abi.Utils.typeMap(" + parameterSpec.name + ", " + typeMapInput + "))";
        }
        return "new " + parameterSpec.type + "(" + parameterSpec.name + ")";
    }

    private TypeName getWrapperRawType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return ClassName.get(List.class);
        }
        return SolidityContractWrapper.getNativeType(typeName);
    }

    protected static TypeName getNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return SolidityContractWrapper.getNativeType((ParameterizedTypeName)typeName);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.startsWith(Address.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Uint")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.startsWith("Int")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.startsWith(Utf8String.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Bytes")) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.startsWith(DynamicBytes.class.getSimpleName())) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.startsWith(Bool.class.getSimpleName())) {
            return TypeName.get(Boolean.class);
        }
        throw new UnsupportedOperationException("Unsupported type: " + typeName + ", no native type mapping exists.");
    }

    protected static TypeName getNativeType(ParameterizedTypeName parameterizedTypeName) {
        List typeNames = parameterizedTypeName.typeArguments;
        ArrayList<TypeName> nativeTypeNames = new ArrayList<TypeName>(typeNames.size());
        for (TypeName enclosedTypeName : typeNames) {
            nativeTypeNames.add(SolidityContractWrapper.getNativeType(enclosedTypeName));
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])nativeTypeNames.toArray(new TypeName[nativeTypeNames.size()]));
    }

    protected static TypeName getEventNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return TypeName.get(byte[].class);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if ("Utf8String".equals(simpleName)) {
            return TypeName.get(byte[].class);
        }
        return SolidityContractWrapper.getNativeType(typeName);
    }

    private ParameterSpec buildParameterType(String type, String name) {
        return ParameterSpec.builder((TypeName)SolidityContractWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build();
    }

    protected static List<ParameterSpec> buildParameterTypes(List<ABIDefinition.NamedType> namedTypes) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>(namedTypes.size());
        for (int i = 0; i < namedTypes.size(); ++i) {
            ABIDefinition.NamedType namedType = namedTypes.get(i);
            String name = SolidityContractWrapper.createValidParamName(namedType.getName(), i);
            String type = namedTypes.get(i).getType();
            namedType.setName(name);
            result.add(ParameterSpec.builder((TypeName)SolidityContractWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build());
        }
        return result;
    }

    protected static String createValidParamName(String name, int idx) {
        if (name.equals("")) {
            return "param" + idx;
        }
        return name;
    }

    protected static List<TypeName> buildTypeNames(List<ABIDefinition.NamedType> namedTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(namedTypes.size());
        for (ABIDefinition.NamedType namedType : namedTypes) {
            result.add(SolidityContractWrapper.buildTypeName(namedType.getType()));
        }
        return result;
    }

    private MethodSpec buildFunction(ABIDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (!SourceVersion.isName(functionName)) {
            functionName = "_" + functionName;
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        List<TypeName> outputParameterTypes = SolidityContractWrapper.buildTypeNames(functionDefinition.getOutputs());
        if (functionDefinition.isConstant()) {
            this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams);
        } else {
            this.buildTransactionFunction(functionDefinition, methodBuilder, inputParams);
        }
        return methodBuilder.build();
    }

    private MethodSpec buildFunctionSignedTransaction(ABIDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = "getSignedTransactionFor";
        if (!SourceVersion.isName(functionName = functionName + StringUtils.capitaliseFirstLetter(functionDefinition.getName()))) {
            functionName = "_" + functionName;
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        this.buildTransactionFunctionSeq(functionDefinition, methodBuilder, inputParams);
        return methodBuilder.build();
    }

    private MethodSpec buildFunctionWithCallback(ABIDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        List<TypeName> outputParameterTypes = SolidityContractWrapper.buildTypeNames(functionDefinition.getOutputs());
        if (functionDefinition.isConstant()) {
            String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
            this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams);
        } else {
            String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
            methodBuilder.addParameter(TransactionCallback.class, CALLBACK_VALUE, new Modifier[0]);
            this.buildTransactionFunctionWithCallback(functionDefinition, methodBuilder, inputParams);
        }
        return methodBuilder.build();
    }

    public static String getInputOutputFunctionName(ABIDefinition functionDefinition, boolean isOverLoad) {
        if (!isOverLoad) {
            return functionDefinition.getName();
        }
        List<ABIDefinition.NamedType> nameTypes = functionDefinition.getInputs();
        String name = functionDefinition.getName();
        for (int i = 0; i < nameTypes.size(); ++i) {
            ABIDefinition.Type type = nameTypes.get(i).newType();
            name = name + StringUtils.capitaliseFirstLetter(type.getRawType());
            if (!type.isList()) continue;
            List<Integer> depths = type.getDimensions();
            for (int j = 0; j < depths.size(); ++j) {
                name = name + type.getRawType();
                if (0 == depths.get(j)) continue;
                name = name + String.valueOf(depths.get(j));
            }
        }
        logger.debug(" name: {}, nameTypes: {}", (Object)name, nameTypes);
        return name;
    }

    private MethodSpec buildFunctionWithInputDecoder(ABIDefinition functionDefinition, boolean isOverLoad) throws ClassNotFoundException {
        String functionName = SolidityContractWrapper.getInputOutputFunctionName(functionDefinition, isOverLoad);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)("get" + StringUtils.capitaliseFirstLetter(functionName) + "Input")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new Modifier[0]);
        List<TypeName> returnTypes = this.buildReturnTypes(SolidityContractWrapper.buildTypeNames(functionDefinition.getInputs()));
        ParameterizedTypeName parameterizedTupleType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated", (String)("Tuple" + returnTypes.size()), (String[])new String[0]), (TypeName[])returnTypes.toArray(new TypeName[returnTypes.size()]));
        methodBuilder.returns((TypeName)parameterizedTupleType);
        methodBuilder.addStatement("String data = transactionReceipt.getInput().substring(10)", new Object[0]);
        SolidityContractWrapper.buildVariableLengthReturnFunctionConstructor(methodBuilder, functionDefinition.getName(), "", SolidityContractWrapper.buildTypeNames(functionDefinition.getInputs()));
        methodBuilder.addStatement("$T<Type> results = $T.decode(data, function.getOutputParameters())", new Object[]{List.class, FunctionReturnDecoder.class});
        this.buildTupleResultContainer0(methodBuilder, parameterizedTupleType, SolidityContractWrapper.buildTypeNames(functionDefinition.getInputs()));
        return methodBuilder.build();
    }

    private MethodSpec buildFunctionWithOutputDecoder(ABIDefinition functionDefinition, boolean isOverLoad) throws ClassNotFoundException {
        String functionName = SolidityContractWrapper.getInputOutputFunctionName(functionDefinition, isOverLoad);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)("get" + StringUtils.capitaliseFirstLetter(functionName) + "Output")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new Modifier[0]);
        List<TypeName> returnTypes = this.buildReturnTypes(SolidityContractWrapper.buildTypeNames(functionDefinition.getOutputs()));
        ParameterizedTypeName parameterizedTupleType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated", (String)("Tuple" + returnTypes.size()), (String[])new String[0]), (TypeName[])returnTypes.toArray(new TypeName[returnTypes.size()]));
        methodBuilder.returns((TypeName)parameterizedTupleType);
        methodBuilder.addStatement("String data = transactionReceipt.getOutput()", new Object[0]);
        SolidityContractWrapper.buildVariableLengthReturnFunctionConstructor(methodBuilder, functionDefinition.getName(), "", SolidityContractWrapper.buildTypeNames(functionDefinition.getOutputs()));
        methodBuilder.addStatement("$T<Type> results = $T.decode(data, function.getOutputParameters())", new Object[]{List.class, FunctionReturnDecoder.class});
        this.buildTupleResultContainer0(methodBuilder, parameterizedTupleType, SolidityContractWrapper.buildTypeNames(functionDefinition.getOutputs()));
        return methodBuilder.build();
    }

    private void buildConstantFunction(ABIDefinition functionDefinition, MethodSpec.Builder methodBuilder, List<TypeName> outputParameterTypes, String inputParams) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        methodBuilder.addException(ContractException.class);
        if (outputParameterTypes.isEmpty()) {
            methodBuilder.addStatement("throw new RuntimeException(\"cannot call constant function with void return type\")", new Object[0]);
        } else if (outputParameterTypes.size() == 1) {
            TypeName typeName = outputParameterTypes.get(0);
            TypeName nativeReturnTypeName = this.getWrapperRawType(typeName);
            methodBuilder.returns(nativeReturnTypeName);
            methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(new $T<$T>() {}))", new Object[]{Function.class, Function.class, SolidityContractWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.sdk.abi.datatypes.Type.class, inputParams, Arrays.class, TypeReference.class, TypeReference.class, typeName});
            if (nativeReturnTypeName.equals((Object)ClassName.get(List.class))) {
                ParameterizedTypeName listType = ParameterizedTypeName.get(List.class, (Type[])new Type[]{org.fisco.bcos.sdk.abi.datatypes.Type.class});
                CodeBlock.Builder callCode = CodeBlock.builder();
                callCode.addStatement("$T result = ($T) executeCallWithSingleValueReturn(function, $T.class)", new Object[]{listType, listType, nativeReturnTypeName});
                callCode.addStatement("return convertToNative(result)", new Object[0]);
                methodBuilder.returns(nativeReturnTypeName).addCode(callCode.build());
            } else {
                methodBuilder.addStatement("return executeCallWithSingleValueReturn(function, $T.class)", new Object[]{nativeReturnTypeName});
            }
        } else {
            List<TypeName> returnTypes = this.buildReturnTypes(outputParameterTypes);
            ParameterizedTypeName parameterizedTupleType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated", (String)("Tuple" + returnTypes.size()), (String[])new String[0]), (TypeName[])returnTypes.toArray(new TypeName[returnTypes.size()]));
            methodBuilder.returns((TypeName)parameterizedTupleType);
            SolidityContractWrapper.buildVariableLengthReturnFunctionConstructor(methodBuilder, functionName, inputParams, outputParameterTypes);
            this.buildTupleResultContainer(methodBuilder, parameterizedTupleType, outputParameterTypes);
        }
    }

    private void buildTransactionFunction(ABIDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        methodBuilder.returns(TypeName.get(TransactionReceipt.class));
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{Function.class, Function.class, SolidityContractWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.sdk.abi.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        methodBuilder.addStatement("return executeTransaction(function)", new Object[0]);
    }

    private void buildTransactionFunctionWithCallback(ABIDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        methodBuilder.returns(TypeName.VOID);
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{Function.class, Function.class, SolidityContractWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.sdk.abi.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        methodBuilder.addStatement("asyncExecuteTransaction(function, callback)", new Object[0]);
    }

    private void buildTransactionFunctionSeq(ABIDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        TypeName returnType = TypeName.get(String.class);
        methodBuilder.returns(returnType);
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{Function.class, Function.class, SolidityContractWrapper.funcNameToConst(functionName), Arrays.class, org.fisco.bcos.sdk.abi.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        methodBuilder.addStatement("return createSignedTransaction(function)", new Object[0]);
    }

    private TypeSpec buildEventResponseObject(String className, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        TypeName typeName;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        builder.addField(TransactionReceipt.Logs.class, "log", new Modifier[]{Modifier.PUBLIC});
        for (NamedTypeName namedType : indexedParameters) {
            typeName = SolidityContractWrapper.getEventNativeType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        for (NamedTypeName namedType : nonIndexedParameters) {
            typeName = SolidityContractWrapper.getNativeType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        return builder.build();
    }

    private MethodSpec buildSubscribeEventFunction(String eventName) throws ClassNotFoundException {
        String generatedFunctionName = "subscribe" + StringUtils.capitaliseFirstLetter(eventName) + "Event";
        MethodSpec.Builder getEventMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, FROM_BLOCK, new Modifier[0]).addParameter(String.class, TO_BLOCK, new Modifier[0]);
        this.addParameter(getEventMethodBuilder, "string[]", OTHER_TOPICS);
        getEventMethodBuilder.addParameter(EventCallback.class, CALLBACK_VALUE, new Modifier[0]);
        getEventMethodBuilder.addStatement("String topic0 = $N.encode(" + this.buildEventDefinitionName(eventName) + ")", new Object[]{EVENT_ENCODER});
        getEventMethodBuilder.addStatement("subscribeEvent(ABI,BINARY,topic0,fromBlock,toBlock,otherTopics,callback)", new Object[0]);
        return getEventMethodBuilder.build();
    }

    private MethodSpec buildDefaultSubscribeEventLog(String eventName) {
        String generatedFunctionName = "subscribe" + StringUtils.capitaliseFirstLetter(eventName) + "Event";
        MethodSpec.Builder getEventMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(EventCallback.class, CALLBACK_VALUE, new Modifier[0]);
        getEventMethodBuilder.addStatement("String topic0 = $N.encode(" + this.buildEventDefinitionName(eventName) + ")", new Object[]{EVENT_ENCODER});
        getEventMethodBuilder.addStatement("subscribeEvent(ABI,BINARY,topic0,callback)", new Object[0]);
        return getEventMethodBuilder.build();
    }

    private MethodSpec buildEventTransactionReceiptFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        String generatedFunctionName = "get" + StringUtils.capitaliseFirstLetter(functionName) + "Events";
        MethodSpec.Builder transactionMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new Modifier[0]).returns((TypeName)parameterizedTypeName);
        transactionMethodBuilder.addStatement("$T valueList = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", transactionReceipt)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{Contract.EventValuesWithLog.class})}).addStatement("$1T responses = new $1T(valueList.size())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})}).beginControlFlow("for ($T eventValues : valueList)", new Object[]{Contract.EventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, false)).addStatement("responses.add(typedResponse)", new Object[0]).endControlFlow();
        transactionMethodBuilder.addStatement("return responses", new Object[0]);
        return transactionMethodBuilder.build();
    }

    private List<MethodSpec> buildEventFunctions(ABIDefinition functionDefinition, TypeSpec.Builder classBuilder) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        List<ABIDefinition.NamedType> inputs = functionDefinition.getInputs();
        String responseClassName = StringUtils.capitaliseFirstLetter(functionName) + "EventResponse";
        ArrayList<NamedTypeName> parameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> indexedParameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> nonIndexedParameters = new ArrayList<NamedTypeName>();
        Integer index = 0;
        HashSet<String> eventParamNameFilter = new HashSet<String>();
        for (ABIDefinition.NamedType namedType : inputs) {
            if (namedType.getName() == null || namedType.getName().equals("")) continue;
            eventParamNameFilter.add(namedType.getName());
        }
        for (ABIDefinition.NamedType namedType : inputs) {
            if (namedType.getName() == null || namedType.getName().equals("")) {
                String paramName = functionName + "Param" + index;
                while (eventParamNameFilter.contains(paramName)) {
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    paramName = functionName + "Param" + index;
                }
                eventParamNameFilter.add(paramName);
                namedType.setName(paramName);
            }
            NamedTypeName parameter = new NamedTypeName(namedType.getName(), SolidityContractWrapper.buildTypeName(namedType.getType()), namedType.isIndexed());
            if (namedType.isIndexed()) {
                indexedParameters.add(parameter);
            } else {
                nonIndexedParameters.add(parameter);
            }
            parameters.add(parameter);
        }
        classBuilder.addField(this.createEventDefinition(functionName, parameters));
        classBuilder.addType(this.buildEventResponseObject(responseClassName, indexedParameters, nonIndexedParameters));
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.buildEventTransactionReceiptFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildSubscribeEventFunction(functionName));
        methods.add(this.buildDefaultSubscribeEventLog(functionName));
        return methods;
    }

    private CodeBlock buildTypedResponse(String objectName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters, boolean flowable) {
        int i;
        String nativeConversion = ".getValue()";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (flowable) {
            builder.addStatement("$L.log = log", new Object[]{objectName});
        } else {
            builder.addStatement("$L.log = eventValues.getLog()", new Object[]{objectName});
        }
        for (i = 0; i < indexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, indexedParameters.get(i).getName(), SolidityContractWrapper.getEventNativeType(indexedParameters.get(i).getTypeName()), i});
        }
        for (i = 0; i < nonIndexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getNonIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, nonIndexedParameters.get(i).getName(), SolidityContractWrapper.getNativeType(nonIndexedParameters.get(i).getTypeName()), i});
        }
        return builder.build();
    }

    protected static TypeName buildTypeName(String typeDeclaration) {
        String type = SolidityContractWrapper.trimStorageDeclaration(typeDeclaration);
        Matcher matcher = pattern.matcher(type);
        if (matcher.find()) {
            Class<?> rawType;
            ParameterizedTypeName typeName;
            Class<?> baseType = AbiTypes.getType(matcher.group(1));
            String firstArrayDimension = matcher.group(2);
            String secondArrayDimension = matcher.group(3);
            if ("".equals(firstArrayDimension)) {
                typeName = ParameterizedTypeName.get(DynamicArray.class, (Type[])new Type[]{baseType});
            } else {
                rawType = SolidityContractWrapper.getStaticArrayTypeReferenceClass(firstArrayDimension);
                typeName = ParameterizedTypeName.get(rawType, (Type[])new Type[]{baseType});
            }
            if (secondArrayDimension != null) {
                if ("".equals(secondArrayDimension)) {
                    return ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{typeName});
                }
                rawType = SolidityContractWrapper.getStaticArrayTypeReferenceClass(secondArrayDimension);
                return ParameterizedTypeName.get((ClassName)ClassName.get(rawType), (TypeName[])new TypeName[]{typeName});
            }
            return typeName;
        }
        Class<?> cls = AbiTypes.getType(type);
        return ClassName.get(cls);
    }

    private static Class<?> getStaticArrayTypeReferenceClass(String type) {
        try {
            return Class.forName("org.fisco.bcos.sdk.abi.datatypes.generated.StaticArray" + type);
        }
        catch (ClassNotFoundException e) {
            return StaticArray.class;
        }
    }

    private static String trimStorageDeclaration(String type) {
        if (type.endsWith(" storage") || type.endsWith(" memory")) {
            return type.split(" ")[0];
        }
        return type;
    }

    private List<TypeName> buildReturnTypes(List<TypeName> outputParameterTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(outputParameterTypes.size());
        for (TypeName typeName : outputParameterTypes) {
            result.add(SolidityContractWrapper.getNativeType(typeName));
        }
        return result;
    }

    private static void buildVariableLengthReturnFunctionConstructor(MethodSpec.Builder methodBuilder, String functionName, String inputParameters, List<TypeName> outputParameterTypes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Function.class);
        objects.add(Function.class);
        objects.add(SolidityContractWrapper.funcNameToConst(functionName));
        objects.add(Arrays.class);
        objects.add(org.fisco.bcos.sdk.abi.datatypes.Type.class);
        objects.add(inputParameters);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (TypeName outputParameterType : outputParameterTypes) {
            objects.add(TypeReference.class);
            objects.add(outputParameterType);
        }
        String asListParams = Collection.join(outputParameterTypes, ", ", typeName -> "new $T<$T>() {}");
        methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray());
    }

    private void buildTupleResultContainer(MethodSpec.Builder methodBuilder, ParameterizedTypeName tupleType, List<TypeName> outputParameterTypes) {
        List typeArguments = tupleType.typeArguments;
        CodeBlock.Builder tupleConstructor = CodeBlock.builder();
        tupleConstructor.addStatement("$T results = executeCallWithMultipleValueReturn(function)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{org.fisco.bcos.sdk.abi.datatypes.Type.class})}).add("return new $T(", new Object[]{tupleType}).add("$>$>", new Object[0]);
        String resultStringSimple = "\n($T) results.get($L)";
        resultStringSimple = resultStringSimple + ".getValue()";
        String resultStringNativeList = "\nconvertToNative(($T) results.get($L).getValue())";
        int size = typeArguments.size();
        ClassName classList = ClassName.get(List.class);
        for (int i = 0; i < size; ++i) {
            TypeName param = outputParameterTypes.get(i);
            TypeName convertTo = (TypeName)typeArguments.get(i);
            String resultString = resultStringSimple;
            if (param instanceof ParameterizedTypeName) {
                ParameterizedTypeName oldContainer = (ParameterizedTypeName)param;
                ParameterizedTypeName newContainer = (ParameterizedTypeName)convertTo;
                if (newContainer.rawType.compareTo(classList) == 0 && newContainer.typeArguments.size() == 1) {
                    convertTo = ParameterizedTypeName.get((ClassName)classList, (TypeName[])new TypeName[]{(TypeName)oldContainer.typeArguments.get(0)});
                    resultString = resultStringNativeList;
                }
            }
            tupleConstructor.add(resultString, new Object[]{convertTo, i});
            tupleConstructor.add(i < size - 1 ? ", " : ");\n", new Object[0]);
        }
        tupleConstructor.add("$<$<", new Object[0]);
        methodBuilder.returns((TypeName)tupleType).addCode(tupleConstructor.build());
    }

    private void buildTupleResultContainer0(MethodSpec.Builder methodBuilder, ParameterizedTypeName tupleType, List<TypeName> outputParameterTypes) {
        List typeArguments = tupleType.typeArguments;
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        String resultStringSimple = "\n($T) results.get($L)";
        resultStringSimple = resultStringSimple + ".getValue()";
        String resultStringNativeList = "\nconvertToNative(($T) results.get($L).getValue())";
        int size = typeArguments.size();
        ClassName classList = ClassName.get(List.class);
        for (int i = 0; i < size; ++i) {
            TypeName param = outputParameterTypes.get(i);
            TypeName convertTo = (TypeName)typeArguments.get(i);
            String resultString = resultStringSimple;
            if (param instanceof ParameterizedTypeName) {
                ParameterizedTypeName oldContainer = (ParameterizedTypeName)param;
                ParameterizedTypeName newContainer = (ParameterizedTypeName)convertTo;
                if (newContainer.rawType.compareTo(classList) == 0 && newContainer.typeArguments.size() == 1) {
                    convertTo = ParameterizedTypeName.get((ClassName)classList, (TypeName[])new TypeName[]{(TypeName)oldContainer.typeArguments.get(0)});
                    resultString = resultStringNativeList;
                }
            }
            codeBuilder.add(resultString, new Object[]{convertTo, i});
            codeBuilder.add(i < size - 1 ? ", " : "\n", new Object[0]);
        }
        methodBuilder.addStatement("return new $T(\n$L)", new Object[]{tupleType, codeBuilder.build()});
    }

    private static CodeBlock buildVariableLengthEventInitializer(String eventName, List<NamedTypeName> parameterTypes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Event.class);
        objects.add(eventName);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (NamedTypeName parameterType : parameterTypes) {
            objects.add(TypeReference.class);
            objects.add(parameterType.getTypeName());
        }
        String asListParams = parameterTypes.stream().map(type -> {
            if (type.isIndexed()) {
                return "new $T<$T>(true) {}";
            }
            return "new $T<$T>() {}";
        }).collect(Collectors.joining(", "));
        return CodeBlock.builder().addStatement("new $T($S, \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray()).build();
    }

    private static String funcNameToConst(String funcName) {
        return FUNC_NAME_PREFIX + funcName.toUpperCase();
    }

    private static String getBinaryFuncDefinition() {
        return "getBinary(client.getCryptoSuite())";
    }

    private static class NamedTypeName {
        private final TypeName typeName;
        private final String name;
        private final boolean indexed;

        NamedTypeName(String name, TypeName typeName, boolean indexed) {
            this.name = name;
            this.typeName = typeName;
            this.indexed = indexed;
        }

        public String getName() {
            return this.name;
        }

        public TypeName getTypeName() {
            return this.typeName;
        }

        public boolean isIndexed() {
            return this.indexed;
        }
    }
}

