/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.config.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.sdk.config.model.AmopTopic;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigProperty {
    public Map<String, Object> cryptoMaterial;
    public Map<String, Object> network;
    public List<AmopTopic> amop;
    public Map<String, Object> account;
    public Map<String, Object> threadPool;

    public Map<String, Object> getCryptoMaterial() {
        return this.cryptoMaterial;
    }

    public void setCryptoMaterial(Map<String, Object> cryptoMaterial) {
        this.cryptoMaterial = cryptoMaterial;
    }

    public Map<String, Object> getNetwork() {
        return this.network;
    }

    public void setNetwork(Map<String, Object> network) {
        this.network = network;
    }

    public List<AmopTopic> getAmop() {
        return this.amop;
    }

    public void setAmop(List<AmopTopic> amop) {
        this.amop = amop;
    }

    public Map<String, Object> getAccount() {
        return this.account;
    }

    public void setAccount(Map<String, Object> account) {
        this.account = account;
    }

    public Map<String, Object> getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(Map<String, Object> threadPool) {
        this.threadPool = threadPool;
    }

    public static String getValue(Map<String, Object> config, String key, String defaultValue) {
        if (config == null || config.get(key) == null) {
            return defaultValue;
        }
        return (String)config.get(key);
    }

    public static String getConfigFilePath(String configFilePath) {
        if (configFilePath == null) {
            return null;
        }
        File file = new File(configFilePath);
        if (file.exists()) {
            return configFilePath;
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(configFilePath);
        if (url == null) {
            return configFilePath;
        }
        String resourceCertPath = url.getPath();
        if (new File(resourceCertPath).exists()) {
            return resourceCertPath;
        }
        return configFilePath;
    }
}

